/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.persistence.EntityManagerFactory;
import weblogic.deployment.InterceptingInvocationHandler;
import weblogic.deployment.InvocationHandlerInterceptor;
import weblogic.diagnostics.debug.DebugLogger;

public final class EntityManagerFactoryProxyImpl
implements InterceptingInvocationHandler {
    private final EntityManagerFactory emf;
    private final Method closeMethod;
    private final Method equalsMethod;
    private final String unitName;
    private String appName;
    private String moduleName;
    private InvocationHandlerInterceptor iceptor;
    private static final DebugLogger logger = DebugLogger.getDebugLogger((String)"DebugKodoWeblogic");

    public EntityManagerFactoryProxyImpl(EntityManagerFactory entityManagerFactory, String string) {
        this.emf = entityManagerFactory;
        this.unitName = string;
        try {
            this.closeMethod = EntityManagerFactory.class.getMethod("close", null);
            this.equalsMethod = Object.class.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Couldn't get expected method: " + noSuchMethodException));
        }
    }

    public void setInterceptor(InvocationHandlerInterceptor invocationHandlerInterceptor) {
        this.iceptor = invocationHandlerInterceptor;
    }

    EntityManagerFactory getEntityManagerFactory() {
        return this.emf;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setModuleName(String string) {
        this.moduleName = string;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        if (this.iceptor != null) {
            this.iceptor.preInvoke(method, objectArray);
        }
        if (method.equals(this.closeMethod)) {
            return null;
        }
        if (method.equals(this.equalsMethod) && objectArray.length == 1 && objectArray[0] instanceof Proxy) {
            try {
                object2 = (EntityManagerFactoryProxyImpl)Proxy.getInvocationHandler(objectArray[0]);
                objectArray = new Object[]{((EntityManagerFactoryProxyImpl)object2).getEntityManagerFactory()};
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        object2 = null;
        try {
            object2 = method.invoke((Object)this.emf, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        if (this.iceptor != null) {
            return this.iceptor.postInvoke(method, objectArray, object2);
        }
        return object2;
    }
}

