/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.cacheprovider.coherence.jndi.CoherenceOpaqueReference;
import weblogic.deployment.BaseEnvironmentBuilder;
import weblogic.deployment.EnvironmentException;
import weblogic.deployment.JMSConnFactoryOpaqueReferenceImpl;
import weblogic.deployment.descriptors.EJBReference;
import weblogic.deployment.descriptors.EnvironmentEntry;
import weblogic.deployment.descriptors.IllegalTypeException;
import weblogic.deployment.descriptors.IllegalValueException;
import weblogic.deployment.descriptors.ResourceReference;
import weblogic.deployment.jms.PooledConnectionFactory;
import weblogic.j2ee.J2EELogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.work.j2ee.J2EEWorkManager;

public final class EnvironmentBuilder
extends BaseEnvironmentBuilder {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public EnvironmentBuilder(Context context, String string, String string2) throws NamingException {
        super(context, string, string2);
    }

    protected void unbindEnvEntry(Object object) {
        block2: {
            EnvironmentEntry environmentEntry = (EnvironmentEntry)object;
            try {
                this.envCtx.unbind(environmentEntry.getName());
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot remove " + environmentEntry.getName()));
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
    }

    protected void bindEnvEntry(Object object) throws NamingException, EnvironmentException {
        EnvironmentEntry environmentEntry = (EnvironmentEntry)object;
        try {
            String string = environmentEntry.getName();
            if (string == null || string.length() == 0) {
                throw new EnvironmentException("EnvironmentEntry has no name set");
            }
            this.envCtx.bind(string, environmentEntry.getValue());
            if (DEBUG) {
                Debug.say((String)("Bound env entry " + this.envCtx.getNameInNamespace() + "/" + environmentEntry.getName() + " to " + environmentEntry.getValue().getClass().getName()));
            }
        }
        catch (IllegalValueException illegalValueException) {
            throw new EnvironmentException((Throwable)((Object)illegalValueException));
        }
        catch (IllegalTypeException illegalTypeException) {
            throw new EnvironmentException((Throwable)((Object)illegalTypeException));
        }
    }

    public void removeResourceReferences(Collection collection) {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (ResourceReference resourceReference : collection) {
            String string = null;
            try {
                string = resourceReference.getResourceType();
            }
            catch (IllegalValueException illegalValueException) {
                J2EELogger.logDebug((String)("Cannot remove: " + string));
                continue;
            }
            if ("javax.sql.DataSource".equals(string)) {
                this.removeDataSourceRef(resourceReference);
                continue;
            }
            if (this.isJMSConnectionFactory(string)) {
                this.removeJMSConnectionFactoryRef(resourceReference);
                continue;
            }
            if ("java.net.URL".equals(string)) {
                this.removeURLRef(resourceReference);
                continue;
            }
            if ("commonj.work.WorkManager".equals(string)) {
                this.removeWorkManagerRef(resourceReference);
                continue;
            }
            if ("commonj.timers.TimerManager".equals(string)) {
                this.removeTimerManagerRef(resourceReference.getName());
                continue;
            }
            if ("com.tangosol.net.NamedCache".equals(string) || "com.tangosol.net.Service".equals(string)) {
                this.removeCoherenceEntityRef(resourceReference, string);
                continue;
            }
            this.removeConnectorRef(resourceReference);
        }
    }

    private boolean isJMSConnectionFactory(String string) {
        return "javax.jms.QueueConnectionFactory".equals(string) || "javax.jms.TopicConnectionFactory".equals(string) || "javax.jms.XAQueueConnectionFactory".equals(string) || "javax.jms.XATopicConnectionFactory".equals(string) || "javax.jms.ConnectionFactory".equals(string) || "javax.jms.XAConnectionFactory".equals(string);
    }

    public void addResourceReferences(Collection collection) throws NamingException, EnvironmentException {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (ResourceReference resourceReference : collection) {
            String string = null;
            try {
                string = resourceReference.getResourceType();
            }
            catch (IllegalValueException illegalValueException) {
                throw new EnvironmentException(illegalValueException.toString());
            }
            if ("javax.sql.DataSource".equals(string)) {
                this.addDataSourceRef(resourceReference);
                continue;
            }
            if (this.isJMSConnectionFactory(string)) {
                this.addJMSConnectionFactoryRef(resourceReference);
                continue;
            }
            if ("java.net.URL".equals(string)) {
                this.addURLRef(resourceReference);
                continue;
            }
            if ("commonj.work.WorkManager".equals(string)) {
                this.addJ2EEWorkManager(resourceReference);
                continue;
            }
            if ("commonj.timers.TimerManager".equals(string)) {
                this.addTimerManager(resourceReference.getName());
                continue;
            }
            if ("com.tangosol.net.NamedCache".equals(string) || "com.tangosol.net.Service".equals(string)) {
                this.addCoherenceEntityRef(resourceReference, string);
                continue;
            }
            this.addConnectorRef(resourceReference);
        }
    }

    private void addCoherenceEntityRef(ResourceReference resourceReference, String string) throws NamingException, EnvironmentException {
        String string2 = resourceReference.getName();
        if (string2 == null || string2.length() == 0) {
            throw new EnvironmentException("ResourceReference has no name set");
        }
        String string3 = resourceReference.getMappedName();
        if (string3 == null || string3.length() == 0) {
            throw new EnvironmentException("ResourceReference has no mappedName set");
        }
        CoherenceOpaqueReference coherenceOpaqueReference = new CoherenceOpaqueReference(string3, string, Thread.currentThread().getContextClassLoader());
        this.envCtx.bind(string2, (Object)coherenceOpaqueReference);
    }

    private void removeCoherenceEntityRef(ResourceReference resourceReference, String string) {
        block2: {
            try {
                String string2 = resourceReference.getName();
                this.envCtx.unbind(string2);
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot unbind " + resourceReference.getName()));
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
    }

    private void addJ2EEWorkManager(ResourceReference resourceReference) throws NamingException, EnvironmentException {
        String string = resourceReference.getName();
        if (string == null || string.length() == 0) {
            throw new EnvironmentException("ResourceReference has no name set");
        }
        this.envCtx.bind(string, (Object)J2EEWorkManager.get(this.applicationName, this.moduleName, string));
    }

    private boolean isResourceShareable(ResourceReference resourceReference) {
        boolean bl = true;
        if (resourceReference.getResourceSharingScope() != null && resourceReference.getResourceSharingScope().equalsIgnoreCase("Unshareable")) {
            bl = false;
        }
        return bl;
    }

    protected Map createJMSPoolProperties(String string, AuthenticatedSubject authenticatedSubject) throws NamingException {
        String string2;
        Context context = null;
        try {
            context = (Context)this.rootCtx.lookup("app/jms");
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(1);
        hashMap.put("JNDIName", string);
        hashMap.put("JmsApplicationContext", context);
        if (authenticatedSubject != null) {
            hashMap.put("RunAsSubject", authenticatedSubject);
        }
        if ((string2 = ApplicationVersionUtils.getBindApplicationId()) != null) {
            hashMap.put("weblogic.jndi.lookupApplicationId", string2);
        }
        return hashMap;
    }

    private void addConnectorRef(ResourceReference resourceReference) throws NamingException, EnvironmentException {
        if (resourceReference.getName() == null || resourceReference.getName().length() == 0) {
            throw new EnvironmentException("ResourceReference has no name set");
        }
        String string = resourceReference.getJNDINameString();
        if (string == null || string.length() == 0) {
            string = resourceReference.getName();
        }
        try {
            String string2 = resourceReference.getResourceType();
            boolean bl = this.isResourceShareable(resourceReference);
            boolean bl2 = false;
            if (resourceReference.getResourceAuthModeString() != null && resourceReference.getResourceAuthModeString().equalsIgnoreCase("Container")) {
                bl2 = true;
            }
            super.bindResRef(string2, bl, bl2, string, resourceReference.getName(), 2);
        }
        catch (IllegalValueException illegalValueException) {
            throw new EnvironmentException((Throwable)((Object)illegalValueException));
        }
        String string3 = resourceReference.getName() + "JNDI";
        String string4 = resourceReference.getName() + "Auth";
        String string5 = resourceReference.getName() + "SharingScope";
        this.resCtx.bind(string3, (Object)resourceReference.getJNDIName());
        this.resCtx.bind(string4, (Object)resourceReference.getResourceAuthModeString());
        if (resourceReference.getResourceSharingScope() != null) {
            this.resCtx.bind(string5, (Object)resourceReference.getResourceSharingScope());
        }
    }

    private void removeConnectorRef(ResourceReference resourceReference) {
        block2: {
            try {
                this.envCtx.unbind(resourceReference.getName());
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot unbind " + resourceReference.getName()));
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceReference);
    }

    private void removeWorkManagerRef(ResourceReference resourceReference) {
        block2: {
            try {
                J2EEWorkManager j2EEWorkManager = (J2EEWorkManager)((Object)this.envCtx.lookup(resourceReference.getName()));
                j2EEWorkManager.shutdown(null);
                this.envCtx.unbind(resourceReference.getName());
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot unbind " + resourceReference.getName()));
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceReference);
    }

    private void removeDataSourceRef(ResourceReference resourceReference) {
        block2: {
            try {
                this.envCtx.unbind(resourceReference.getName());
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot unbind " + resourceReference.getName()));
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceReference);
    }

    private void addDataSourceRef(ResourceReference resourceReference) throws NamingException, EnvironmentException {
        Context context;
        String string = resourceReference.getJNDINameString();
        String string2 = resourceReference.getName();
        if (string2 == null || string2.length() == 0) {
            throw new EnvironmentException("ResourceReference has no name set");
        }
        if (string == null || string.length() == 0) {
            string = string2;
        }
        Object object = null;
        try {
            context = (Context)this.rootCtx.lookup("app");
            object = context.lookup(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (object == null) {
            try {
                context = (Context)this.rootCtx.lookup("app");
                object = context.lookup("jdbc/" + string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object == null) {
            try {
                object = new InitialContext().lookup(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (object != null) {
            this.envCtx.bind(string2, object);
        } else {
            this.envCtx.bind(string2, (Object)new LinkRef(string));
            J2EELogger.logDebug((String)("Cannot find JDBC DataSource at " + string));
        }
    }

    private void addJMSConnectionFactoryRef(ResourceReference resourceReference) throws NamingException, EnvironmentException {
        String string = resourceReference.getJNDINameString();
        String string2 = resourceReference.getName();
        if (string2 == null || string2.length() == 0) {
            throw new EnvironmentException("ResourceReference has no name set");
        }
        if (string == null || string.length() == 0) {
            string = string2;
        }
        boolean bl = false;
        if (resourceReference.getResourceAuthModeString() != null && resourceReference.getResourceAuthModeString().equalsIgnoreCase("Container")) {
            bl = true;
        }
        boolean bl2 = this.isResourceShareable(resourceReference);
        String string3 = string;
        string3 = !bl2 ? this.applicationName + "-" + this.componentName + "-" + string : string;
        if (bl2) {
            PooledConnectionFactory pooledConnectionFactory;
            try {
                pooledConnectionFactory = new PooledConnectionFactory(string3, 2, bl, this.createJMSPoolProperties(string, null));
            }
            catch (JMSException jMSException) {
                throw new EnvironmentException("Could not create a new JMS ConnectionFactory for the application: " + (Object)((Object)jMSException));
            }
            this.envCtx.bind(string2, (Object)pooledConnectionFactory);
        } else {
            JMSConnFactoryOpaqueReferenceImpl jMSConnFactoryOpaqueReferenceImpl = new JMSConnFactoryOpaqueReferenceImpl(string3, 1, bl, this.createJMSPoolProperties(string, null));
            this.envCtx.bind(string2, (Object)jMSConnFactoryOpaqueReferenceImpl);
        }
    }

    public void removeResourceEnvReferences(Map map) {
        if (DEBUG) {
            Debug.assertion((map != null ? 1 : 0) != 0);
        }
        for (Map.Entry entry : map.entrySet()) {
            try {
                this.envCtx.unbind((String)entry.getKey());
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot remove " + (String)entry.getKey()));
                if (!DEBUG) continue;
                namingException.printStackTrace();
            }
        }
    }

    private void removeJMSConnectionFactoryRef(ResourceReference resourceReference) {
        block3: {
            try {
                PooledConnectionFactory pooledConnectionFactory = (PooledConnectionFactory)this.envCtx.lookup(resourceReference.getName());
                if (pooledConnectionFactory != null) {
                    ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
                    boolean bl = serverRuntimeMBean.getStateVal() == 18;
                    pooledConnectionFactory.close(bl);
                }
                this.envCtx.unbind(resourceReference.getName());
            }
            catch (Throwable throwable) {
                J2EELogger.logDebug((String)("Cannot unbind " + resourceReference.getName()));
                if (!DEBUG) break block3;
                throwable.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceReference);
    }

    public void addResourceEnvReferences(Map map) throws NamingException {
        if (DEBUG) {
            Debug.assertion((map != null ? 1 : 0) != 0);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.envCtx.bind((String)entry.getKey(), (Object)new LinkRef((String)entry.getValue()));
        }
    }

    public void addResourceReference(ResourceReference resourceReference) throws NamingException, EnvironmentException {
        this.addResourceReferences(Arrays.asList((Object[])new ResourceReference[]{resourceReference}));
    }

    public void addEJBReferences(Collection collection, String string) throws NamingException, EnvironmentException {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (EJBReference eJBReference : collection) {
            if (eJBReference.getName() == null || eJBReference.getName().length() == 0) {
                throw new EnvironmentException("EJB Reference has no name set");
            }
            if (eJBReference.getLinkedEjbName() != null && eJBReference.getLinkedEjbName().length() > 0) {
                this.addEJBLinkRef(eJBReference.getName(), eJBReference.getLinkedEjbName(), eJBReference.getHomeInterfaceName(), eJBReference.getRemoteInterfaceName(), string, eJBReference.isLocalLink());
                continue;
            }
            if (eJBReference.getJNDIName() != null && eJBReference.getJNDIName().length() > 0) {
                this.envCtx.rebind(eJBReference.getName(), (Object)this.createLinkRef(eJBReference.getJNDIName()));
                continue;
            }
            if (eJBReference.getMappedName() != null && eJBReference.getMappedName().length() > 0) {
                String string2 = null;
                string2 = eJBReference.getMappedName().startsWith("weblogic-jndi:") ? eJBReference.getMappedName().substring("weblogic-jndi:".length(), eJBReference.getMappedName().length()) : eJBReference.getMappedName() + "#" + eJBReference.getRemoteInterfaceName();
                this.envCtx.rebind(eJBReference.getName(), (Object)this.createLinkRef(string2));
                continue;
            }
            this.autowireEJBRef(eJBReference.getName(), eJBReference.getHomeInterfaceName(), eJBReference.getRemoteInterfaceName());
        }
    }

    public void removeEJBReferences(Collection collection) {
        if (DEBUG) {
            Debug.assertion((collection != null ? 1 : 0) != 0);
        }
        for (EJBReference eJBReference : collection) {
            try {
                this.envCtx.unbind(eJBReference.getName());
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot remove " + eJBReference.getName()));
                if (!DEBUG) continue;
                namingException.printStackTrace();
            }
        }
    }

    public void addEJBReference(EJBReference eJBReference, String string) throws NamingException, EnvironmentException {
        this.addEJBReferences(Arrays.asList((Object[])new EJBReference[]{eJBReference}), string);
    }

    private void removeFromResCtx(ResourceReference resourceReference) {
        block5: {
            block4: {
                try {
                    this.resCtx.unbind(resourceReference.getName() + "JNDI");
                }
                catch (NamingException namingException) {
                    J2EELogger.logDebug((String)("Cannot remove " + resourceReference.getName() + "JNDI"));
                    if (!DEBUG) break block4;
                    namingException.printStackTrace();
                }
            }
            try {
                this.resCtx.unbind(resourceReference.getName() + "Auth");
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot remove " + resourceReference.getName() + "Auth"));
                if (!DEBUG) break block5;
                namingException.printStackTrace();
            }
        }
    }

    private void addURLRef(ResourceReference resourceReference) throws NamingException, EnvironmentException {
        if (resourceReference.getName() == null || resourceReference.getName().length() == 0) {
            throw new EnvironmentException("ResourceReference \"" + resourceReference.getName() + "\" has no name set");
        }
        String string = resourceReference.getJNDINameString();
        if (string == null || string.length() == 0) {
            string = resourceReference.getName();
        }
        try {
            this.envCtx.bind(resourceReference.getName(), (Object)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            this.envCtx.bind(resourceReference.getName(), (Object)this.createLinkRef(string));
        }
        String string2 = resourceReference.getName() + "JNDI";
        String string3 = resourceReference.getName() + "Auth";
        String string4 = resourceReference.getName() + "SharingScope";
        this.resCtx.bind(string2, (Object)resourceReference.getJNDIName());
        this.resCtx.bind(string3, (Object)resourceReference.getResourceAuthModeString());
        if (resourceReference.getResourceSharingScope() != null) {
            this.resCtx.bind(string4, (Object)resourceReference.getResourceSharingScope());
        }
    }

    private void removeURLRef(ResourceReference resourceReference) {
        block2: {
            try {
                this.envCtx.unbind(resourceReference.getName());
            }
            catch (NamingException namingException) {
                J2EELogger.logDebug((String)("Cannot unbind " + resourceReference.getName()));
                if (!DEBUG) break block2;
                namingException.printStackTrace();
            }
        }
        this.removeFromResCtx(resourceReference);
    }

    protected String transformJNDIName(String string) {
        return string;
    }
}

