/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.deployment.BaseEnvironmentBuilder;
import weblogic.jndi.OpaqueReference;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MailSessionMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;

public final class MailSessionOpaqueReferenceImpl
implements OpaqueReference {
    private final String jndiName;
    private final String applicationName;
    private Properties props = null;
    private static Map jndiNameToMailSession = new HashMap();

    public MailSessionOpaqueReferenceImpl(String string, String string2) {
        this.jndiName = string;
        this.applicationName = string2;
    }

    public Object getReferent(Name name, Context context) throws NamingException {
        String string = BaseEnvironmentBuilder.transformJNDIName(this.jndiName, this.applicationName);
        MailSessionMBean mailSessionMBean = (MailSessionMBean)jndiNameToMailSession.get(string);
        if (mailSessionMBean == null) {
            String string2 = string.replace('/', '.');
            mailSessionMBean = (MailSessionMBean)jndiNameToMailSession.get(string2);
            if (mailSessionMBean == null) {
                string2 = string.replace('.', '/');
            }
            if ((mailSessionMBean = (MailSessionMBean)jndiNameToMailSession.get(string2)) == null) {
                throw new AssertionError("Error received when trying to get a mail session with jndiName: " + string);
            }
        }
        this.props = mailSessionMBean.getProperties();
        if (this.props == null) {
            this.props = new Properties();
        }
        try {
            return Session.getInstance((Properties)this.props, null);
        }
        catch (Exception exception) {
            throw new AssertionError("Error received when trying to create a mail session", (Throwable)exception);
        }
    }

    static {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getDomain();
        MailSessionMBean[] mailSessionMBeanArray = domainMBean.getMailSessions();
        for (int i = 0; i < mailSessionMBeanArray.length; ++i) {
            jndiNameToMailSession.put(mailSessionMBeanArray[i].getJNDIName(), mailSessionMBeanArray[i]);
        }
    }
}

