/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.ModuleLocationInfo;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.IOUtils;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deployment.AbstractPersistenceUnitRegistry;
import weblogic.deployment.EarPersistenceUnitRegistry;
import weblogic.deployment.EnvironmentException;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.ejb.container.deployer.EJBModule;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public class ModulePersistenceUnitRegistry
extends AbstractPersistenceUnitRegistry {
    private EarPersistenceUnitRegistry parent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulePersistenceUnitRegistry(GenericClassLoader genericClassLoader, ApplicationContextInternal applicationContextInternal, Module module, boolean bl) throws EnvironmentException, MalformedURLException {
        block6: {
            super(genericClassLoader, module.getId(), EarUtils.getConfigDir(applicationContextInternal), applicationContextInternal.findDeploymentPlan(), applicationContextInternal);
            this.parent = (EarPersistenceUnitRegistry)applicationContextInternal.getUserObject(EarPersistenceUnitRegistry.class);
            try {
                File file = this.getOutputFile(applicationContextInternal, module);
                URL uRL = file.toURL();
                if (module.getType().equals(WebLogicModuleType.MODULETYPE_WAR)) {
                    this.loadPersistenceDescriptors(bl);
                    break block6;
                }
                VirtualJarFile virtualJarFile = null;
                try {
                    virtualJarFile = module instanceof EJBModule ? applicationContextInternal.getApplicationFileManager().getVirtualJarFile(module.getId()) : applicationContextInternal.getApplicationFileManager().getVirtualJarFile(((ModuleLocationInfo)module).getModuleURI());
                    this.loadPersistenceDescriptor(virtualJarFile, bl, file);
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    IOUtils.forceClose(virtualJarFile);
                    throw throwable;
                }
                IOUtils.forceClose(virtualJarFile);
                {
                }
            }
            catch (EnvironmentException environmentException) {
                throw environmentException;
            }
            catch (Exception exception) {
                throw new EnvironmentException(exception);
            }
        }
    }

    protected File getOutputFile(ApplicationContextInternal applicationContextInternal, Module module) {
        String string = applicationContextInternal.getOutputPath();
        if (applicationContextInternal.isEar()) {
            string = string + System.getProperty("file.separator");
            if (module instanceof EJBModule) {
                return applicationContextInternal.getApplicationFileManager().getOutputPath(module.getId());
            }
            return applicationContextInternal.getApplicationFileManager().getOutputPath(((ModuleLocationInfo)module).getModuleURI());
        }
        return new File(string);
    }

    public PersistenceUnitInfoImpl getPersistenceUnit(String string) throws IllegalArgumentException {
        PersistenceUnitInfoImpl persistenceUnitInfoImpl = (PersistenceUnitInfoImpl)this.persistenceUnits.get(string);
        if (persistenceUnitInfoImpl != null) {
            return persistenceUnitInfoImpl;
        }
        if (this.parent != null) {
            persistenceUnitInfoImpl = this.parent.getPersistenceUnit(string);
        }
        if (persistenceUnitInfoImpl == null) {
            throw new IllegalArgumentException("No persistence unit named '" + string + "' is available in scope " + this.getScopeName() + ". Available persistence units: " + this.getPersistenceUnitNames());
        }
        return persistenceUnitInfoImpl;
    }

    public void close() {
        super.close();
        if (this.parent != null) {
            this.parent.close();
        }
    }

    public Collection getPersistenceUnitNames() {
        Collection collection = super.getPersistenceUnitNames();
        if (this.parent != null) {
            collection.addAll(this.parent.getPersistenceUnitNames());
        }
        return collection;
    }

    void putPersistenceUnit(PersistenceUnitInfoImpl persistenceUnitInfoImpl) throws EnvironmentException {
        if (persistenceUnitInfoImpl.getPersistenceUnitName().startsWith("../")) {
            throw new IllegalArgumentException("'" + persistenceUnitInfoImpl.getPersistenceUnitName() + "' is not a valid persistence unit name. A persistence unit name " + "cannot start with '../'.");
        }
        super.putPersistenceUnit(persistenceUnitInfoImpl);
    }

    public String getQualifiedName() {
        if (this.parent == null) {
            return this.getScopeName();
        }
        return this.parent.getQualifiedName() + "#" + this.getScopeName();
    }
}

