/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kodo.jdbc.conf.descriptor.JDBCConfigurationBeanParser;
import kodo.jdbc.conf.descriptor.PersistenceConfigurationBean;
import kodo.jdbc.conf.descriptor.PersistenceUnitConfigurationBean;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.BootstrapException;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.persistence.PersistenceProductDerivation;
import org.apache.openjpa.persistence.PersistenceUnitInfoImpl;
import org.apache.openjpa.util.UserException;
import weblogic.deployment.PersistenceDescriptorLoader;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;

public class PersistenceConfigurationProductDerivation
extends AbstractProductDerivation {
    private static final String PREFIX_KODO = "kodo.";
    private static final String PREFIX_OPENJPA = "openjpa.";

    public int getType() {
        return 1000;
    }

    public boolean beforeConfigurationConstruct(ConfigurationProvider configurationProvider) {
        Properties properties;
        boolean bl = false;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource("META-INF/persistence-configuration.xml");
        if (uRL == null) {
            return false;
        }
        File file = null;
        DeploymentPlanBean deploymentPlanBean = null;
        String string = "";
        String string2 = null;
        try {
            string2 = uRL.toURI().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UserException((Throwable)uRISyntaxException);
        }
        Map map = configurationProvider.getProperties();
        boolean bl2 = Configurations.containsProperty((String)"Id", (Map)map);
        String string3 = bl2 ? Configurations.getProperty((String)"Id", (Map)map).toString() : null;
        PersistenceUnitInfoImpl persistenceUnitInfoImpl = this.getPersistenceUnit(string3);
        Properties properties2 = properties = persistenceUnitInfoImpl == null ? new Properties() : persistenceUnitInfoImpl.getProperties();
        if (persistenceUnitInfoImpl != null && !properties.isEmpty()) {
            throw new BootstrapException(properties.keySet() + " is set " + "before sourcing " + string2).setFatal(true);
        }
        try {
            PersistenceDescriptorLoader persistenceDescriptorLoader = new PersistenceDescriptorLoader(uRL, file, deploymentPlanBean, string, string2);
            JDBCConfigurationBeanParser jDBCConfigurationBeanParser = new JDBCConfigurationBeanParser();
            DescriptorBean descriptorBean = persistenceDescriptorLoader.loadDescriptorBean();
            if (descriptorBean instanceof PersistenceConfigurationBean) {
                PersistenceConfigurationBean persistenceConfigurationBean = (PersistenceConfigurationBean)descriptorBean;
                PersistenceUnitConfigurationBean[] persistenceUnitConfigurationBeanArray = persistenceConfigurationBean.getPersistenceUnitConfigurations();
                for (int i = 0; i < persistenceUnitConfigurationBeanArray.length; ++i) {
                    Properties properties3 = null;
                    if (!this.matches(persistenceUnitConfigurationBeanArray[i].getName(), string3)) continue;
                    properties3 = jDBCConfigurationBeanParser.load(persistenceUnitConfigurationBeanArray[i]);
                    properties3.remove("kodo.Name");
                    Iterator<Object> iterator = properties3.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string4 = iterator.next().toString();
                        String string5 = string4.substring(PREFIX_KODO.length());
                        boolean bl3 = Configurations.containsProperty((String)string5, (Map)map);
                        if (bl3) continue;
                        configurationProvider.addProperty(string4, properties3.get(string4));
                        bl = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return bl;
    }

    public boolean beforeConfigurationLoad(Configuration configuration) {
        if (!(configuration instanceof OpenJPAConfigurationImpl)) {
            return false;
        }
        OpenJPAConfigurationImpl openJPAConfigurationImpl = (OpenJPAConfigurationImpl)configuration;
        openJPAConfigurationImpl.managedRuntimePlugin.setDefault("org.apache.openjpa.ee.WLSManagedRuntime");
        openJPAConfigurationImpl.managedRuntimePlugin.setString("org.apache.openjpa.ee.WLSManagedRuntime");
        return true;
    }

    boolean matches(String string, String string2) {
        return this.isEmpty(string) && this.isEmpty(string2) || !this.isEmpty(string) && string.equals(string2);
    }

    boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public void validate() throws Exception {
        Class.forName("weblogic.descriptor.DescriptorBean");
    }

    PersistenceUnitInfoImpl getPersistenceUnit(String string) {
        try {
            Enumeration<URL> enumeration = ((Object)((Object)this)).getClass().getClassLoader().getResources("META-INF/persistence.xml");
            while (enumeration.hasMoreElements()) {
                PersistenceProductDerivation.ConfigurationParser configurationParser = new PersistenceProductDerivation.ConfigurationParser(new HashMap());
                configurationParser.parse(enumeration.nextElement());
                List list = configurationParser.getResults();
                for (PersistenceUnitInfoImpl persistenceUnitInfoImpl : list) {
                    if (!this.matches(string, persistenceUnitInfoImpl.getPersistenceUnitName())) continue;
                    return persistenceUnitInfoImpl;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    Map ignoreKnownOrUnrecognizedProperty(Map map) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        HashMap hashMap = new HashMap(map);
        Configurations.removeProperty((String)"Id", hashMap);
        Configurations.removeProperty((String)"BrokerFactory", hashMap);
        for (String string : hashMap.keySet()) {
            if (string.startsWith(PREFIX_KODO) || string.startsWith(PREFIX_OPENJPA)) continue;
            hashMap.remove(string);
        }
        return hashMap;
    }
}

