/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.CachingDescriptorLoader2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.deployment.PersistenceReader;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.PersistenceBean;
import weblogic.j2ee.descriptor.PersistenceUnitBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.utils.jars.VirtualJarFile;

public final class PersistenceDescriptorLoader
extends CachingDescriptorLoader2 {
    private static boolean isDebug = Boolean.getBoolean("weblogic.deployment.PersistenceDescriptor");
    private final URL resourceURL;
    public static final String PERSISTENCE_RESOURCE_URI = "META-INF/persistence.xml";
    public static final String PERSISTENCE_CONFIG_RESOURCE_URI = "META-INF/persistence-configuration.xml";

    public PersistenceDescriptorLoader(URL uRL, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        super((VirtualJarFile)null, file, deploymentPlanBean, string, string2);
        this.resourceURL = uRL;
    }

    public PersistenceDescriptorLoader(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        super(virtualJarFile, file, deploymentPlanBean, string, string2);
        this.resourceURL = null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.resourceURL != null) {
            return this.resourceURL.openStream();
        }
        return super.getInputStream();
    }

    protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        if (this.isPersistenceConfigurationDescriptor()) {
            String string = "kodo.jdbc.conf.descriptor.PersistenceConfigurationBeanImpl$SchemaHelper2";
            return new VersionMunger(inputStream, (AbstractDescriptorLoader2)this, string, "http://xmlns.oracle.com/weblogic/persistence-configuration");
        }
        return new PersistenceReader(inputStream, this);
    }

    public DescriptorBean loadDescriptorBean() throws IOException, XMLStreamException {
        DescriptorBean descriptorBean = super.loadDescriptorBean();
        if (descriptorBean == null || this.isPersistenceConfigurationDescriptor()) {
            return descriptorBean;
        }
        PersistenceBean persistenceBean = (PersistenceBean)descriptorBean;
        PersistenceUnitBean persistenceUnitBean = persistenceBean.lookupPersistenceUnit("__ORACLE_WLS_INTERNAL_DUMMY_PERSISTENCE_UNIT");
        if (persistenceUnitBean != null) {
            persistenceBean.destroyPersistenceUnit(persistenceUnitBean);
        }
        PersistenceReader persistenceReader = (PersistenceReader)this.getMunger();
        persistenceBean.setOriginalVersion(persistenceReader.getOriginalVersion());
        return descriptorBean;
    }

    private boolean isPersistenceConfigurationDescriptor() {
        return this.getDocumentURI() != null && this.getDocumentURI().endsWith(PERSISTENCE_CONFIG_RESOURCE_URI);
    }

    public static void debug(String string, Exception exception) {
        if (isDebug) {
            System.out.println(string);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    public static void debug(String string) {
        PersistenceDescriptorLoader.debug(string, null);
    }

    public static URI getRelativeURI(URI uRI, URI uRI2) {
        URI uRI3 = uRI.relativize(uRI2);
        PersistenceDescriptorLoader.debug("Relativizing " + uRI2 + " to " + uRI);
        if (uRI3.equals(uRI2)) {
            PersistenceDescriptorLoader.debug("No initial match, schemes are " + uRI2.getScheme() + " and " + uRI.getScheme());
            if ((uRI2.getScheme().equals("jar") || uRI2.getScheme().equals("zip")) && uRI.getScheme().equals("file")) {
                PersistenceDescriptorLoader.debug("Schema mismatch detected");
                String string = uRI2.toString();
                String string2 = string.substring(string.indexOf("!") + 1);
                PersistenceDescriptorLoader.debug("Descriptor URI is " + string2);
                String string3 = null;
                string3 = uRI2.getScheme().equals("zip") ? "file:/" + string.substring(4, string.indexOf("!")) : string.substring(4, string.indexOf("!"));
                PersistenceDescriptorLoader.debug("Jar URI is " + string3);
                try {
                    URI uRI4 = new URI(string3);
                    URI uRI5 = uRI.relativize(uRI4);
                    PersistenceDescriptorLoader.debug("Relative jar URI is " + uRI5.toString());
                    return new URI(uRI5 + "!" + string2);
                }
                catch (URISyntaxException uRISyntaxException) {
                    PersistenceDescriptorLoader.debug("Unable to relativize URI", uRISyntaxException);
                    return uRI3;
                }
            }
        }
        return uRI3;
    }

    public static URI getRelativeURI(File[] fileArray, URI uRI) {
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                URI uRI2 = PersistenceDescriptorLoader.getRelativeURI(fileArray[i].toURI(), uRI);
                if (uRI2.equals(uRI)) continue;
                return uRI2;
            }
        }
        return uRI;
    }

    public static URI getResourceURI(URL uRL) throws IOException {
        String string = uRL.getFile();
        if ("jar".equals(uRL.getProtocol())) {
            string = string.substring(5);
        }
        return new File(string).getCanonicalFile().toURI();
    }

    public static void main(String[] stringArray) throws IOException, XMLStreamException, URISyntaxException {
        if (stringArray.length < 1) {
            System.out.println("Usage: java weblogic.deployment.PersistenceDescriptorLoader [descriptor-uri] [plan path] [module] [root-uri]");
        } else {
            Object object;
            String string = stringArray[0];
            DeploymentPlanBean deploymentPlanBean = null;
            String string2 = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URI uRI = new File(".").toURI();
            if (stringArray.length > 1) {
                object = new DescriptorManager();
                deploymentPlanBean = (DeploymentPlanBean)object.createDescriptor((InputStream)new FileInputStream(stringArray[1])).getRootBean();
                if (stringArray.length > 2) {
                    string2 = stringArray[2];
                    if (stringArray.length > 3) {
                        uRI = new File(stringArray[3]).toURI();
                    }
                }
            }
            object = classLoader.getResources(string);
            while (object.hasMoreElements()) {
                URL uRL = (URL)object.nextElement();
                URI uRI2 = uRL.toURI();
                String string3 = uRL.toString();
                String string4 = PersistenceDescriptorLoader.getRelativeURI(uRI, uRI2).toString();
                System.out.println("Trying to load URL " + string3 + " aka " + string4);
                PersistenceDescriptorLoader persistenceDescriptorLoader = new PersistenceDescriptorLoader(uRL, null, deploymentPlanBean, string2, string4);
                DescriptorBean descriptorBean = persistenceDescriptorLoader.loadDescriptorBean();
                DescriptorUtils.writeAsXML(descriptorBean);
            }
        }
    }
}

