/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.io.InputStream;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.ReaderEvent2;
import weblogic.application.descriptor.ReaderEventInfo;
import weblogic.application.descriptor.VersionMunger;

public final class PersistenceReader
extends VersionMunger {
    private static final String SCHEMA_HELPER = "weblogic.j2ee.descriptor.PersistenceBeanImpl$SchemaHelper2";
    public static final String DUMMY_PERSISTENCE_UNIT = "__ORACLE_WLS_INTERNAL_DUMMY_PERSISTENCE_UNIT";
    private boolean addDummyPU;
    private boolean addExcludeUnlisted;

    public PersistenceReader(InputStream inputStream, AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
        super(inputStream, abstractDescriptorLoader2, SCHEMA_HELPER);
    }

    protected String getLatestSchemaVersion() {
        return "2.0";
    }

    protected boolean isOldSchema() {
        if ("persistence".equals(this.currentEvent.getElementName())) {
            ReaderEventInfo readerEventInfo = this.currentEvent.getReaderEventInfo();
            if ("1.0".equals(readerEventInfo.getAttributeValue(null, "version"))) {
                this.isOldSchema = true;
            } else if (readerEventInfo.getAttributeValue(null, "version") == null) {
                this.isOldSchema = true;
            }
        }
        return this.isOldSchema;
    }

    protected boolean enableCallbacksOnSchema() {
        return this.isOldSchema;
    }

    protected void transformOldSchema() {
        if ("persistence".equals(this.currentEvent.getElementName())) {
            ReaderEventInfo readerEventInfo = this.currentEvent.getReaderEventInfo();
            int n = readerEventInfo.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                if (!"version".equals(readerEventInfo.getAttributeLocalName(i))) continue;
                this.versionInfo = readerEventInfo.getAttributeValue(i);
                this.currentEvent.getReaderEventInfo().setAttributeValue("2.0", i);
            }
            if (this.versionInfo == null) {
                this.versionInfo = "1.0";
            }
        }
    }

    protected VersionMunger.Continuation onStartElement(String string) {
        if ("persistence".equals(string)) {
            this.addDummyPU = "1.0".equals(this.versionInfo);
        } else if ("persistence-unit".equals(string)) {
            this.addExcludeUnlisted = "1.0".equals(this.versionInfo);
            this.addDummyPU = false;
        } else if ("exclude-unlisted-classes".equals(string)) {
            this.addExcludeUnlisted = false;
        } else if ("properties".equals(string) && this.addExcludeUnlisted) {
            this.addExcludeUnlistedClasses();
            Stack stack = this.currentEvent.getParent().getChildren();
            Object e = stack.remove(stack.size() - 2);
            stack.add(e);
            return this.USE_BUFFER;
        }
        return CONTINUE;
    }

    protected VersionMunger.Continuation onEndElement(String string) {
        ReaderEventInfo readerEventInfo;
        char[] cArray;
        if ("persistence".equals(string) && this.addDummyPU) {
            this.addDummyPU();
            this.pushEndElement(string);
            return this.USE_BUFFER;
        }
        if ("persistence-unit".equals(string) && this.addExcludeUnlisted) {
            this.addExcludeUnlistedClasses();
            this.pushEndElement(string);
            return this.USE_BUFFER;
        }
        if ("exclude-unlisted-classes".equals(string) && "1.0".equals(this.versionInfo) && ((cArray = (readerEventInfo = this.lastEvent.getReaderEventInfo()).getCharacters()) == null || this.isAllWhiteSpace(cArray))) {
            readerEventInfo.setCharacters("false".toCharArray());
        }
        return CONTINUE;
    }

    protected String getOriginalVersion() {
        return this.versionInfo;
    }

    private void addDummyPU() {
        this.forceSkipParent = true;
        this.pushStartElementLastEvent("persistence-unit");
        ReaderEventInfo readerEventInfo = ((ReaderEvent2)this.stack.peek()).getReaderEventInfo();
        readerEventInfo.setAttributeCount(1);
        readerEventInfo.setAttributeValue(DUMMY_PERSISTENCE_UNIT, null, "name");
        this.pushEndElement("persistence-unit");
        this.forceSkipParent = false;
        this.addDummyPU = false;
    }

    private void addExcludeUnlistedClasses() {
        this.forceSkipParent = true;
        this.pushStartElementLastEvent("exclude-unlisted-classes");
        ReaderEventInfo readerEventInfo = ((ReaderEvent2)this.stack.peek()).getReaderEventInfo();
        readerEventInfo.setCharacters("false".toCharArray());
        this.pushEndElement("exclude-unlisted-classes");
        this.forceSkipParent = false;
        this.addExcludeUnlisted = false;
    }

    private boolean isAllWhiteSpace(char[] cArray) {
        for (char c : cArray) {
            if (this.isWhiteSpace(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }
}

