/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.io.File;
import weblogic.deployment.AbstractPersistenceUnitRegistry;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFile;

public abstract class PersistenceUnitViewer
extends AbstractPersistenceUnitRegistry {
    private static boolean disablePUViewer = Boolean.getBoolean("weblogic.deployment.disablePersistenceViewer");

    public PersistenceUnitViewer(GenericClassLoader genericClassLoader, String string, File file, DeploymentPlanBean deploymentPlanBean) {
        super(genericClassLoader, string, file, deploymentPlanBean);
    }

    public abstract void loadDescriptors() throws ToolFailureException;

    public PersistenceUnitInfoImpl getPersistenceUnit(String string) throws IllegalArgumentException {
        throw new AssertionError((Object)"This class is for descriptor viewing only");
    }

    protected void throwLoadException(Exception exception) throws ToolFailureException {
        throw new ToolFailureException("Unable to load persistence descriptor", (Throwable)exception);
    }

    public static class EntryViewer
    extends PersistenceUnitViewer {
        private final VirtualJarFile vjf;

        public EntryViewer(VirtualJarFile virtualJarFile, String string, File file, DeploymentPlanBean deploymentPlanBean) {
            super(null, string, file, deploymentPlanBean);
            this.vjf = virtualJarFile;
        }

        public void loadDescriptors() throws ToolFailureException {
            if (disablePUViewer) {
                return;
            }
            try {
                this.loadPersistenceDescriptor(this.vjf, false, null);
            }
            catch (Exception exception) {
                this.throwLoadException(exception);
            }
        }
    }

    public static class ResourceViewer
    extends PersistenceUnitViewer {
        public ResourceViewer(GenericClassLoader genericClassLoader, String string, File file, DeploymentPlanBean deploymentPlanBean) {
            super(genericClassLoader, string, file, deploymentPlanBean);
        }

        public void loadDescriptors() throws ToolFailureException {
            if (disablePUViewer) {
                return;
            }
            try {
                this.loadPersistenceDescriptors(false);
            }
            catch (Exception exception) {
                this.throwLoadException(exception);
            }
        }
    }
}

