/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.transaction.Transaction;
import weblogic.deployment.TransactionalEntityManagerProxyImpl;
import weblogic.transaction.TransactionHelper;

public final class QueryProxyImpl
implements Query {
    private final TransactionalEntityManagerProxyImpl emProxy;
    private final Method createQueryMethod;
    private final Object[] createQueryArgs;
    private final Map hints = new HashMap();
    private final Map params = new HashMap();
    private int firstResult = -1;
    private int maxResults = -1;
    private FlushModeType flushMode = null;

    public QueryProxyImpl(TransactionalEntityManagerProxyImpl transactionalEntityManagerProxyImpl, Method method, Object[] objectArray) {
        this.emProxy = transactionalEntityManagerProxyImpl;
        this.createQueryMethod = method;
        this.createQueryArgs = objectArray;
    }

    private Query createQuery(EntityManager entityManager) {
        Query query = null;
        String string = this.createQueryMethod.getName();
        query = string.equals("createQuery") ? entityManager.createQuery((String)this.createQueryArgs[0]) : (string.equals("createNamedQuery") ? entityManager.createNamedQuery((String)this.createQueryArgs[0]) : (this.createQueryArgs.length == 1 ? entityManager.createNativeQuery((String)this.createQueryArgs[0]) : (this.createQueryArgs[1].getClass() == String.class ? entityManager.createNativeQuery((String)this.createQueryArgs[0], (String)this.createQueryArgs[1]) : entityManager.createNativeQuery((String)this.createQueryArgs[0], (Class)this.createQueryArgs[1]))));
        if (this.firstResult > 0) {
            query.setFirstResult(this.firstResult);
        }
        if (this.maxResults > 0) {
            query.setMaxResults(this.maxResults);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (String string2 : this.hints.keySet()) {
            query.setHint(string2, this.hints.get(string2));
        }
        for (String string2 : this.params.keySet()) {
            Object object = this.params.get(string2);
            TemporalType temporalType = null;
            if (object instanceof ParameterValue) {
                temporalType = ((ParameterValue)object).temporalType;
                object = ((ParameterValue)object).value;
            }
            if (string2 instanceof IndexKey) {
                int n = ((IndexKey)((Object)string2)).index;
                if (temporalType == null) {
                    query.setParameter(n, object);
                    continue;
                }
                if (object instanceof Date) {
                    query.setParameter(n, (Date)object, temporalType);
                    continue;
                }
                query.setParameter(n, (Calendar)object, temporalType);
                continue;
            }
            if (temporalType == null) {
                query.setParameter(string2, object);
                continue;
            }
            if (object instanceof Date) {
                query.setParameter(string2, (Date)object, temporalType);
                continue;
            }
            query.setParameter(string2, (Calendar)object, temporalType);
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() {
        int n;
        block2: {
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
            EntityManager entityManager = (EntityManager)this.emProxy.getPersistenceContext(transaction);
            try {
                n = this.createQuery(entityManager).executeUpdate();
                Object var5_4 = null;
                if (transaction != null || entityManager == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (transaction != null || entityManager == null) break block3;
                    entityManager.close();
                }
                throw throwable;
            }
            entityManager.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getResultList() {
        List list;
        block2: {
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
            EntityManager entityManager = (EntityManager)this.emProxy.getPersistenceContext(transaction);
            try {
                list = this.createQuery(entityManager).getResultList();
                Object var5_4 = null;
                if (transaction != null || entityManager == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (transaction != null || entityManager == null) break block3;
                    entityManager.close();
                }
                throw throwable;
            }
            entityManager.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSingleResult() {
        Object object;
        block2: {
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
            EntityManager entityManager = (EntityManager)this.emProxy.getPersistenceContext(transaction);
            try {
                object = this.createQuery(entityManager).getSingleResult();
                Object var5_4 = null;
                if (transaction != null || entityManager == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_5 = null;
                    if (transaction != null || entityManager == null) break block3;
                    entityManager.close();
                }
                throw throwable;
            }
            entityManager.close();
        }
        return object;
    }

    public Query setFirstResult(int n) {
        this.validatePositiveArgument(n);
        this.firstResult = n;
        return this;
    }

    public Query setFlushMode(FlushModeType flushModeType) {
        this.flushMode = flushModeType;
        return this;
    }

    public Query setHint(String string, Object object) {
        this.hints.put(string, object);
        return this;
    }

    public Query setMaxResults(int n) {
        this.validatePositiveArgument(n);
        this.maxResults = n;
        return this;
    }

    public Query setParameter(int n, Calendar calendar, TemporalType temporalType) {
        this.params.put(new IndexKey(n), new ParameterValue(calendar, temporalType));
        return this;
    }

    public Query setParameter(int n, Date date, TemporalType temporalType) {
        this.params.put(new IndexKey(n), new ParameterValue(date, temporalType));
        return this;
    }

    public Query setParameter(int n, Object object) {
        this.params.put(new IndexKey(n), object);
        return this;
    }

    public Query setParameter(String string, Calendar calendar, TemporalType temporalType) {
        this.params.put(string, new ParameterValue(calendar, temporalType));
        return this;
    }

    public Query setParameter(String string, Date date, TemporalType temporalType) {
        this.params.put(string, new ParameterValue(date, temporalType));
        return this;
    }

    public Query setParameter(String string, Object object) {
        this.params.put(string, object);
        return this;
    }

    private void validatePositiveArgument(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument is negative: " + n);
        }
    }

    private class IndexKey {
        public int index;

        public IndexKey(int n) {
            this.index = n;
        }

        public boolean equals(Object object) {
            if (object instanceof IndexKey) {
                return this.index == ((IndexKey)object).index;
            }
            return false;
        }
    }

    private class ParameterValue {
        public Object value;
        public TemporalType temporalType;

        public ParameterValue(Object object, TemporalType temporalType) {
            this.value = object;
            this.temporalType = temporalType;
        }
    }
}

