/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.Service;
import weblogic.deployment.ServiceRefProcessor;
import weblogic.deployment.ServiceRefProcessorException;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;

public class ServiceRefProcessorFactory {
    private static final ServiceRefProcessorFactory instance = new ServiceRefProcessorFactory();
    private static final String JAXRPC_PROCESSOR = "weblogic.wsee.jaxrpc.ServiceRefProcessorImpl";
    private static final String JAXWS_PROCESSOR = "weblogic.wsee.jaxws.ServiceRefProcessorImpl";

    private ServiceRefProcessorFactory() {
    }

    public static ServiceRefProcessorFactory getInstance() {
        return instance;
    }

    public ServiceRefProcessor getProcessor(ServiceRefBean serviceRefBean, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, ServletContext servletContext) throws ServiceRefProcessorException {
        String string = JAXRPC_PROCESSOR;
        String string2 = serviceRefBean.getServiceInterface();
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
            if (Service.class.isAssignableFrom(clazz) || clazz.isAnnotationPresent(WebService.class)) {
                string = JAXWS_PROCESSOR;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServiceRefProcessorException("Unable to load specified service-interface: " + string2, classNotFoundException);
        }
        return this.constructProcessor(string, serviceRefBean, serviceReferenceDescriptionBean, servletContext);
    }

    private ServiceRefProcessor constructProcessor(String string, ServiceRefBean serviceRefBean, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, ServletContext servletContext) throws ServiceRefProcessorException {
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(ServiceRefBean.class, ServiceReferenceDescriptionBean.class, ServletContext.class);
            return (ServiceRefProcessor)constructor.newInstance(serviceRefBean, serviceReferenceDescriptionBean, servletContext);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new ServiceRefProcessorException(throwable.getMessage(), throwable);
        }
        catch (Exception exception) {
            throw new ServiceRefProcessorException("Error constructing ServiceRefProcessor: " + string, exception);
        }
    }
}

