/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.deployment.BasePersistenceContextProxyImpl;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;

public final class TransactionalEntityManagerProxyImpl
extends BasePersistenceContextProxyImpl {
    Set<Method> queryMethods = new HashSet<Method>();

    TransactionalEntityManagerProxyImpl(String string, String string2, String string3, PersistenceUnitRegistry persistenceUnitRegistry) {
        super(string, string2, string3, persistenceUnitRegistry);
        try {
            Class<EntityManager> clazz = EntityManager.class;
            this.setTransactionAccessMethod(clazz.getMethod("getTransaction", null));
            this.setCloseMethod(clazz.getMethod("close", null));
            this.setDelegateMethod(clazz.getMethod("getDelegate", null));
            HashSet<Method> hashSet = new HashSet<Method>();
            hashSet.add(clazz.getMethod("refresh", Object.class));
            hashSet.add(clazz.getMethod("remove", Object.class));
            hashSet.add(clazz.getMethod("merge", Object.class));
            hashSet.add(clazz.getMethod("persist", Object.class));
            hashSet.add(clazz.getMethod("flush", null));
            hashSet.add(clazz.getMethod("lock", Object.class, LockModeType.class));
            hashSet.add(clazz.getMethod("joinTransaction", null));
            this.setTransactionalMethods(hashSet);
            for (Method method : clazz.getMethods()) {
                if (!method.getName().startsWith("create") || !method.getName().endsWith("Query")) continue;
                this.queryMethods.add(method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Couldn't get expected method: " + noSuchMethodException));
        }
    }

    protected String getPersistenceContextStyleName() {
        return "EntityManager";
    }

    protected Object newPersistenceContext(PersistenceUnitInfoImpl persistenceUnitInfoImpl) {
        return persistenceUnitInfoImpl.getUnwrappedEntityManagerFactory().createEntityManager();
    }

    protected Object invoke(Object object, Method method, Object[] objectArray, Transaction transaction) throws Throwable {
        if (transaction == null && this.queryMethods.contains(method)) {
            return this.persistenceUnit.createNonTransactionalQueryProxy(this, method, objectArray);
        }
        return super.invoke(object, method, objectArray, transaction);
    }

    protected void checkTransactionStatus(Object object, Transaction transaction) {
        EntityManager entityManager = (EntityManager)object;
        if (!entityManager.isOpen()) {
            try {
                if (transaction != null && transaction.getStatus() == 4) {
                    throw new IllegalStateException("The transaction associated with this transaction-scoped persistence context has been rolled back and as a result, the EntityManager has been closed.  No further operations are allowed in this transaction context. Please see the server log for the cause of the rollback.");
                }
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    protected void close(Object object) {
        EntityManager entityManager = (EntityManager)object;
        if (entityManager.isOpen()) {
            entityManager.close();
        }
    }
}

