/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment;

import java.lang.reflect.Method;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import kodo.jdo.KodoJDOHelper;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import weblogic.deployment.BasePersistenceContextProxyImpl;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.PersistenceUnitRegistry;

public final class TransactionalPersistenceManagerProxyImpl
extends BasePersistenceContextProxyImpl {
    public TransactionalPersistenceManagerProxyImpl(String string, String string2, String string3, PersistenceUnitRegistry persistenceUnitRegistry) {
        super(string, string2, string3, persistenceUnitRegistry);
        try {
            Class<PersistenceManager> clazz = PersistenceManager.class;
            this.setTransactionAccessMethod(clazz.getMethod("currentTransaction", null));
            this.setCloseMethod(clazz.getMethod("close", null));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)("Couldn't get expected method: " + noSuchMethodException));
        }
    }

    protected String getPersistenceContextStyleName() {
        return "PersistenceManager";
    }

    protected Object newPersistenceContext(PersistenceUnitInfoImpl persistenceUnitInfoImpl) {
        EntityManager entityManager = persistenceUnitInfoImpl.getEntityManagerFactory().createEntityManager();
        return TransactionalPersistenceManagerProxyImpl.toPersistenceManager(entityManager);
    }

    protected void close(Object object) {
        ((PersistenceManager)object).close();
    }

    protected static PersistenceManager toPersistenceManager(EntityManager entityManager) {
        if (!(entityManager instanceof OpenJPAEntityManager)) {
            try {
                Class<?> clazz = Class.forName(JPAFacadeHelper.class.getName(), true, entityManager.getClass().getClassLoader());
                Method method = clazz.getMethod("toBroker", EntityManager.class);
                Class<?> clazz2 = Class.forName(KodoJDOHelper.class.getName(), true, entityManager.getClass().getClassLoader());
                Class<?> clazz3 = method.getReturnType();
                Method method2 = clazz2.getMethod("toPersistenceManager", clazz3);
                Object object = method.invoke(null, entityManager);
                return (PersistenceManager)method2.invoke(null, object);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException("Error converting EntityManager to Broker", exception);
            }
        }
        return KodoJDOHelper.toPersistenceManager((Broker)JPAFacadeHelper.toBroker((EntityManager)entityManager));
    }

    protected static PersistenceManagerFactory toPersistenceManagerFactory(EntityManagerFactory entityManagerFactory) {
        if (!(entityManagerFactory instanceof OpenJPAEntityManagerFactory)) {
            try {
                Class<?> clazz = Class.forName(JPAFacadeHelper.class.getName(), true, entityManagerFactory.getClass().getClassLoader());
                Method method = clazz.getMethod("toBrokerFactory", EntityManagerFactory.class);
                Class<?> clazz2 = Class.forName(KodoJDOHelper.class.getName(), true, entityManagerFactory.getClass().getClassLoader());
                Class<?> clazz3 = method.getReturnType();
                Method method2 = clazz2.getMethod("toPersistenceManagerFactory", clazz3);
                Object object = method.invoke(null, entityManagerFactory);
                return (PersistenceManagerFactory)method2.invoke(null, object);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException("Error converting EntityManagerFactory to BrokerFactory", exception);
            }
        }
        return KodoJDOHelper.toPersistenceManagerFactory((BrokerFactory)JPAFacadeHelper.toBrokerFactory((EntityManagerFactory)entityManagerFactory));
    }
}

