/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment.descriptors;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.deployment.descriptors.BaseDescriptor;
import weblogic.deployment.descriptors.DDValidationErrorCodes;
import weblogic.deployment.descriptors.IllegalValueException;

public class EJBReference
extends BaseDescriptor
implements DDValidationErrorCodes {
    public static final Set VALID_EJB_REF_TYPES = new HashSet<Object>(Arrays.asList((Object[])new String[]{"Session", "Entity"}));
    private String refDesc;
    private String refName;
    private String refType;
    private String refHome;
    private String refRemote;
    private String refEjbName;
    private String refJndiName;
    private String refMappedName;
    private boolean isLocalLink;

    public EJBReference(String string, String string2, String string3, String string4, String string5, String string6) {
        super("weblogic.deployment.descriptors.DDValidationBundle");
        this.setDescription(string);
        this.setName(string2);
        this.setRefType(string3);
        this.setHomeInterfaceName(string4);
        this.setRemoteInterfaceName(string5);
        this.setLinkedEjbName(string6);
    }

    public void setDescription(String string) {
        this.refDesc = string;
    }

    public String getDescription() {
        return this.refDesc;
    }

    public void setName(String string) {
        this.refName = string;
    }

    public String getName() {
        return this.refName;
    }

    public void validateName() {
        if (this.refName == null || this.refName.length() == 0) {
            this.addError("NO_RES_REF_NAME_SET");
        }
    }

    public void setRefType(String string) {
        this.refType = string;
    }

    public String getRefTypeString() {
        return this.refType;
    }

    public String getRefType() throws IllegalValueException {
        if (VALID_EJB_REF_TYPES.contains(this.refType)) {
            return this.refType;
        }
        throw new IllegalValueException("INVALID_EJB_REF_TYPE");
    }

    public void validateType() {
        if (this.refType == null || this.refType.length() == 0) {
            this.addError("NO_EJB_REF_TYPE_SET");
        } else {
            try {
                this.getRefType();
            }
            catch (IllegalValueException illegalValueException) {
                this.addError("INVALID_EJB_REF_TYPE");
            }
        }
    }

    public void setHomeInterfaceName(String string) {
        this.refHome = string;
    }

    public String getHomeInterfaceName() {
        return this.refHome;
    }

    public void validateHomeInterfaceName() {
        if (this.refHome == null || this.refHome.length() == 0) {
            this.addError("NO_EJB_REF_HOME_SET");
        }
    }

    public void setRemoteInterfaceName(String string) {
        this.refRemote = string;
    }

    public String getRemoteInterfaceName() {
        return this.refRemote;
    }

    public void validateRemoteInterfaceName() {
        if (this.refRemote == null || this.refRemote.length() == 0) {
            this.addError("NO_EJB_REF_REMOTE_SET");
        }
    }

    public void setLinkedEjbName(String string) {
        this.refEjbName = string;
    }

    public String getLinkedEjbName() {
        return this.refEjbName;
    }

    public void setJNDIName(String string) {
        this.refJndiName = string;
    }

    public String getJNDIName() {
        return this.refJndiName;
    }

    public void validateJNDIName() {
        if (this.refEjbName == null && (this.refJndiName == null || this.refJndiName.length() == 0)) {
            this.addError("NO_EJB_REF_JNDI_NAME_SET", this.refName);
        }
    }

    public void setMappedName(String string) {
        this.refMappedName = string;
    }

    public String getMappedName() {
        return this.refMappedName;
    }

    public void validateSelf() {
        this.validateName();
        this.validateType();
        this.validateHomeInterfaceName();
        this.validateRemoteInterfaceName();
        this.validateJNDIName();
    }

    public Iterator getSubObjectsIterator() {
        return Collections.EMPTY_SET.iterator();
    }

    public boolean isLocalLink() {
        return this.isLocalLink;
    }

    public void setLocalLink(boolean bl) {
        this.isLocalLink = bl;
    }
}

