/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment.descriptors;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.deployment.descriptors.BaseDescriptor;
import weblogic.deployment.descriptors.DDValidationErrorCodes;
import weblogic.deployment.descriptors.IllegalTypeException;
import weblogic.deployment.descriptors.IllegalValueException;
import weblogic.utils.AssertionError;

public class EnvironmentEntry
extends BaseDescriptor
implements DDValidationErrorCodes {
    public static Set VALID_ENV_ENTRY_TYPES = new HashSet<Object>(Arrays.asList((Object[])new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Integer", "java.lang.Double", "java.lang.Float", "java.lang.Short", "java.lang.Long", "java.lang.Byte", "java.lang.Character"}));
    private String name;
    private String type;
    private String value;
    private String description;

    public EnvironmentEntry() {
        super("weblogic.deployment.descriptors.DDValidationBundle");
    }

    public EnvironmentEntry(String string) {
        this();
        this.name = string;
    }

    public EnvironmentEntry(String string, String string2) {
        this(string);
        this.setType(string2);
    }

    public EnvironmentEntry(String string, String string2, String string3) {
        this(string, string2);
        this.setValue(string3);
    }

    public EnvironmentEntry(String string, String string2, String string3, String string4) {
        this(string, string2, string3);
        this.setDescription(string4);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setTypeClass(Class clazz) {
        this.setType(clazz.getName());
    }

    public Class getTypeClass() {
        return this.getNamedType(this.type);
    }

    public String getValueString() {
        return this.value;
    }

    public void setValueString(String string) {
        this.setValue(string);
    }

    public Object getValue() throws IllegalValueException, IllegalTypeException {
        Class[] classArray = new Class[1];
        Object[] objectArray = new String[1];
        classArray[0] = String.class;
        objectArray[0] = this.value;
        Class clazz = this.getNamedType(this.type);
        if (clazz == null) {
            String string = this.localizer.getFormattedMsg("INVALID_ENV_TYPE", this.type);
            throw new IllegalTypeException(string);
        }
        try {
            if (this.value == null) {
                return clazz.newInstance();
            }
            if (clazz.getName().equals("java.lang.Character")) {
                if (this.value.trim().length() > 1) {
                    throw new IllegalValueException("");
                }
                char c = this.value.charAt(0);
                return new Character(c);
            }
            Constructor constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            String string = this.localizer.getFormattedMsg("ENV_VALUE_NOT_OF_TYPE", this.value, this.type);
            throw new IllegalValueException(string);
        }
    }

    private Class getNamedType(String string) {
        String string2 = string;
        if (!VALID_ENV_ENTRY_TYPES.contains(string2) && !VALID_ENV_ENTRY_TYPES.contains(string2 = "java.lang." + string2)) {
            return null;
        }
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setValue(Class clazz, String string) {
        this.setValue(clazz.getName(), string);
    }

    public void setValue(String string, String string2) {
        this.setType(string);
        this.setValue(string2);
    }

    public void validateSelf() {
        if (this.name == null || this.name.length() == 0) {
            this.addError("NO_ENV_ENTRY_NAME_SET");
        }
        if (this.value == null || this.value.length() == 0) {
            this.addError("NO_ENV_ENTRY_VALUE_SET");
        }
        if (this.getNamedType(this.type) == null) {
            this.addError("INVALID_ENV_TYPE", this.type);
        } else if (this.value != null && this.value.length() != 0) {
            try {
                this.getValue();
            }
            catch (IllegalValueException illegalValueException) {
                this.addError("ENV_VALUE_NOT_OF_TYPE", this.value, this.type);
            }
            catch (IllegalTypeException illegalTypeException) {
                this.addError("INVALID_ENV_TYPE", this.type);
            }
        }
    }

    public Iterator getSubObjectsIterator() {
        return Collections.EMPTY_SET.iterator();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof EnvironmentEntry && this.name.equals(((EnvironmentEntry)object).name);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name [" + this.name + "] ");
        stringBuffer.append("type [" + this.type + "] ");
        stringBuffer.append("value [" + this.value + "] ");
        stringBuffer.append("description [" + this.description + "] ");
        return stringBuffer.toString();
    }
}

