/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment.descriptors;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import weblogic.deployment.descriptors.BaseDescriptor;
import weblogic.deployment.descriptors.DDValidationErrorCodes;
import weblogic.deployment.descriptors.IllegalValueException;

public class ResourceReference
extends BaseDescriptor
implements DDValidationErrorCodes {
    public static final Set VALID_RESOURCE_TYPES = new HashSet<Object>(Arrays.asList((Object[])new String[]{"javax.sql.DataSource", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "java.net.URL", "javax.mail.Session"}));
    public static final Set VALID_AUTH_MODES = new HashSet<Object>(Arrays.asList((Object[])new String[]{"Application", "Container", "CONTAINER", "SERVLET"}));
    private String refDesc;
    private String refName;
    private String resType;
    private String resAuthMode;
    private String resSharingScope;
    private String jndiName;
    private String mappedName;

    public ResourceReference(String string, String string2, String string3, String string4, String string5) {
        super("weblogic.deployment.descriptors.DDValidationBundle");
        this.refDesc = string;
        this.refName = string2;
        this.setResourceType(string3);
        this.setResourceAuthMode(string4);
        this.setResourceSharingScope(string5);
    }

    public void setDescription(String string) {
        this.refDesc = string;
    }

    public String getDescription() {
        return this.refDesc;
    }

    public void setName(String string) {
        this.refName = string;
    }

    public String getName() {
        return this.refName;
    }

    public void validateName() {
        if (this.refName == null || this.refName.length() == 0) {
            this.addError("NO_RES_REF_NAME_SET");
        }
    }

    public void setResourceType(String string) {
        this.resType = string;
    }

    public String getResourceType() throws IllegalValueException {
        return this.resType;
    }

    public void validateType() {
        if (this.resType == null || this.resType.length() == 0) {
            this.addError("NO_RES_REF_TYPE_SET");
        } else {
            try {
                this.getResourceType();
            }
            catch (IllegalValueException illegalValueException) {
                this.addError("INVALID_RES_TYPE");
            }
        }
    }

    public String getResourceTypeString() {
        return this.resType;
    }

    public void setResourceAuthMode(String string) {
        this.resAuthMode = string;
    }

    public String getResourceAuthModeString() {
        return this.resAuthMode;
    }

    public void setResourceSharingScope(String string) {
        this.resSharingScope = string;
    }

    public String getResourceSharingScope() {
        return this.resSharingScope;
    }

    public void validateAuthMode() {
        if (this.resAuthMode == null || this.resAuthMode.length() == 0) {
            this.addError("NO_RES_AUTH_SET");
        } else {
            try {
                this.getResourceAuthMode();
            }
            catch (IllegalValueException illegalValueException) {
                this.addError("INVALID_RES_AUTH");
            }
        }
    }

    public String getResourceAuthMode() throws IllegalValueException {
        if (!VALID_AUTH_MODES.contains(this.resAuthMode)) {
            throw new IllegalValueException("Invalid resource authorization mode");
        }
        return this.resAuthMode;
    }

    public void setJNDIName(String string) {
        this.jndiName = string;
    }

    public String getJNDINameString() {
        return this.jndiName != null ? this.jndiName : this.mappedName;
    }

    public Name getJNDIName() throws InvalidNameException {
        String string;
        String string2 = string = this.jndiName != null ? this.jndiName : this.mappedName;
        if (string == null) {
            return null;
        }
        return new CompositeName(string);
    }

    public void validateJNDIName() {
        if (this.getJNDINameString() == null || this.getJNDINameString().length() == 0) {
            this.addError("NO_RES_JNDI_NAME", this.refName, this.resType);
        } else {
            try {
                this.getJNDIName();
            }
            catch (InvalidNameException invalidNameException) {
                this.addError("INVALID_RES_JNDI_NAME");
            }
        }
    }

    public void setMappedName(String string) {
        this.mappedName = string;
    }

    public String getMappedName() {
        return this.mappedName;
    }

    public void validateSelf() {
        this.validateName();
        this.validateType();
        this.validateAuthMode();
        this.validateJNDIName();
    }

    public Iterator getSubObjectsIterator() {
        return Collections.EMPTY_SET.iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("refName [" + this.refName + "] ");
        stringBuffer.append("refDesc [" + this.refDesc + "] ");
        stringBuffer.append("resType [" + this.resType + "] ");
        stringBuffer.append("resAuthMode [" + this.resAuthMode + "] ");
        stringBuffer.append("jndiName [" + this.jndiName + "] ");
        return stringBuffer.toString();
    }
}

