/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment.descriptors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.deployment.descriptors.BaseDescriptor;
import weblogic.deployment.descriptors.DDValidationErrorCodes;

public class RoleDescriptor
extends BaseDescriptor
implements DDValidationErrorCodes {
    private String description;
    private String roleName;
    private Set principals = new HashSet();

    public RoleDescriptor() {
        this("", "");
    }

    public RoleDescriptor(String string, String string2) {
        super("weblogic.deployment.descriptors.DDValidationBundle");
        this.description = string;
        this.roleName = string2;
    }

    public RoleDescriptor(String string) {
        super("weblogic.deployment.descriptors.DDValidationBundle");
        this.roleName = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getName() {
        return this.roleName;
    }

    public void setName(String string) {
        this.roleName = string;
    }

    public void addSecurityPrincipal(String string) {
        this.principals.add(string);
    }

    public boolean hasSecurityPrincipal(String string) {
        return this.principals.contains(string);
    }

    public void addSecurityPrincipals(Map map) {
        this.principals.addAll(map.values());
    }

    public void addSecurityPrincipals(Collection collection) {
        this.principals.addAll(collection);
    }

    public void removeSecurityPrincipal(String string) {
        this.principals.remove(string);
    }

    public void removeAllSecurityPrincipals() {
        this.principals.clear();
    }

    public Collection getAllSecurityPrincipals() {
        return this.principals;
    }

    public void validateSelf() {
        if (this.roleName == null || this.roleName.length() == 0) {
            this.addError("NO_ROLE_NAME_SET");
        }
    }

    public Iterator getSubObjectsIterator() {
        return Collections.EMPTY_SET.iterator();
    }
}

