/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment.jms;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import weblogic.deployment.jms.ForeignOpaqueTag;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ForeignJNDIObjectBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.PropertyBean;
import weblogic.jndi.OpaqueReference;
import weblogic.kernel.KernelStatus;
import weblogic.management.EncryptionHelper;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.security.SubjectUtils;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public class ForeignOpaqueReference
implements ForeignOpaqueTag,
OpaqueReference,
Serializable {
    static final long serialVersionUID = 4404892619941441265L;
    private static final transient AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private boolean isFactory = false;
    private String username;
    private String password;
    private String connectionHealthChecking = "enabled";
    private Hashtable jndiEnvironment;
    private String remoteJNDIName;
    private static String AQJMS_ICF = "oracle.jms.AQjmsInitialContextFactory";
    private static String AQJMS_QPREFIX = "Queues/";
    private static String AQJMS_TPREFIX = "Topics/";
    private transient Object cachedReferent;

    public ForeignOpaqueReference() {
    }

    public ForeignOpaqueReference(ForeignServerBean foreignServerBean, ForeignJNDIObjectBean foreignJNDIObjectBean) {
        byte[] byArray;
        String string;
        String string2;
        PropertyBean[] propertyBeanArray;
        this.remoteJNDIName = foreignJNDIObjectBean.getRemoteJNDIName();
        if (foreignJNDIObjectBean instanceof ForeignConnectionFactoryBean) {
            this.isFactory = true;
            this.username = ((ForeignConnectionFactoryBean)foreignJNDIObjectBean).getUsername();
            this.password = ((ForeignConnectionFactoryBean)foreignJNDIObjectBean).getPassword();
            this.connectionHealthChecking = ((ForeignConnectionFactoryBean)foreignJNDIObjectBean).getConnectionHealthChecking();
        }
        if ((propertyBeanArray = foreignServerBean.getJNDIProperties()) != null && propertyBeanArray.length != 0) {
            this.jndiEnvironment = new Hashtable(propertyBeanArray.length);
            for (int i = 0; i < propertyBeanArray.length; ++i) {
                this.jndiEnvironment.put(propertyBeanArray[i].getKey(), propertyBeanArray[i].getValue());
            }
        }
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Hashtable(3);
        }
        if ((string2 = foreignServerBean.getInitialContextFactory()) != null && string2.trim().length() != 0 && !string2.equals("weblogic.jndi.WLInitialContextFactory")) {
            this.jndiEnvironment.put("java.naming.factory.initial", string2);
        }
        if ((string = foreignServerBean.getConnectionURL()) != null && string.trim().length() != 0) {
            this.jndiEnvironment.put("java.naming.provider.url", string);
        }
        if ((byArray = foreignServerBean.getJNDIPropertiesCredentialEncrypted()) != null) {
            AbstractSubject abstractSubject = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
            String string3 = new String(EncryptionHelper.decrypt(byArray, (AuthenticatedSubject)abstractSubject));
            EncryptionHelper.clear(byArray);
            if (string3.trim().length() > 0) {
                this.jndiEnvironment.put("java.naming.security.credentials", string3);
            }
        }
        if (this.jndiEnvironment.size() == 0) {
            this.jndiEnvironment = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReferent(Name name, Context context) throws NamingException {
        Object object;
        Object object2;
        InitialContext initialContext;
        AbstractSubject abstractSubject = SubjectManager.getSubjectManager().getCurrentSubject(KERNEL_ID);
        if (this.jndiEnvironment == null) {
            initialContext = new InitialContext();
        } else {
            if (this.jndiEnvironment.get("java.naming.factory.initial") == null) {
                this.jndiEnvironment.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            }
            initialContext = new InitialContext(this.jndiEnvironment);
        }
        AbstractSubject abstractSubject2 = SubjectManager.getSubjectManager().getCurrentSubject(KERNEL_ID);
        if (KernelStatus.isServer()) {
            object2 = SubjectUtils.getUsername((Subject)abstractSubject2.getSubject());
            String string = SubjectUtils.getUsername((Subject)abstractSubject.getSubject());
            if (WLSPrincipals.isKernelUsername((String)object2)) {
                abstractSubject2 = WLSPrincipals.isKernelUsername((String)string) ? SubjectManager.getSubjectManager().getAnonymousSubject() : abstractSubject;
            }
            String string2 = null;
            if (this.jndiEnvironment != null && this.jndiEnvironment.get("java.naming.security.principal") == null && (string2 = (String)this.jndiEnvironment.get("java.naming.provider.url")) != null && this.jndiEnvironment.get("java.naming.factory.initial") != null && ((String)this.jndiEnvironment.get("java.naming.factory.initial")).indexOf("weblogic") != -1) {
                try {
                    if (RemoteDomainSecurityHelper.isRemoteDomain(string2)) {
                        abstractSubject2 = SubjectManager.getSubjectManager().getAnonymousSubject();
                    }
                }
                catch (IOException iOException) {
                    throw new NamingException(iOException.getMessage());
                }
            }
        }
        SubjectManager.getSubjectManager().pushSubject(KERNEL_ID, abstractSubject2);
        try {
            if (this.jndiEnvironment != null && AQJMS_ICF.equals(this.jndiEnvironment.get("java.naming.factory.initial")) && this.remoteJNDIName != null && (this.remoteJNDIName.startsWith(AQJMS_QPREFIX) || this.remoteJNDIName.startsWith(AQJMS_TPREFIX))) {
                object2 = this;
                synchronized (object2) {
                    if (this.cachedReferent == null) {
                        this.cachedReferent = initialContext.lookup(this.remoteJNDIName);
                    }
                }
                object = this.cachedReferent;
            } else {
                object = initialContext.lookup(this.remoteJNDIName);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            SubjectManager.getSubjectManager().popSubject(KERNEL_ID);
            initialContext.close();
            throw throwable;
        }
        SubjectManager.getSubjectManager().popSubject(KERNEL_ID);
        initialContext.close();
        return object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ForeignOpaqueReference: target=\"");
        stringBuffer.append(this.remoteJNDIName);
        stringBuffer.append('\"');
        if (this.jndiEnvironment != null) {
            Enumeration enumeration = this.jndiEnvironment.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.jndiEnvironment.get(string);
                stringBuffer.append(' ');
                stringBuffer.append(string);
                stringBuffer.append('=');
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isFactory() {
        return this.isFactory;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectionHealthChecking() {
        return this.connectionHealthChecking;
    }

    public Hashtable getJNDIEnvironment() {
        return this.jndiEnvironment;
    }

    public String getRemoteJNDIName() {
        return this.remoteJNDIName;
    }
}

