/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment.jms;

import java.security.AccessController;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.common.resourcepool.ResourcePool;
import weblogic.deployment.jms.ForeignOpaqueReference;
import weblogic.deployment.jms.JMSConnectionHelper;
import weblogic.deployment.jms.JMSPoolDebug;
import weblogic.deployment.jms.JMSSessionPool;
import weblogic.deployment.jms.JMSSessionPoolRuntime;
import weblogic.deployment.jms.JMSSessionPoolRuntimeImpl;
import weblogic.deployment.jms.PlatformHelper;
import weblogic.jndi.ClientEnvironmentFactory;
import weblogic.jndi.internal.ClientEnvironmentFactoryImpl;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;

public class PlatformHelperImpl
extends PlatformHelper {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ClientEnvironmentFactory environmentFactory = new ClientEnvironmentFactoryImpl();

    public JMSSessionPoolRuntime createJMSSessionPoolRuntime(String string, ResourcePool resourcePool, JMSSessionPool jMSSessionPool) throws ManagementException {
        return new JMSSessionPoolRuntimeImpl(string, resourcePool, jMSSessionPool);
    }

    String getXAResourceName(String string) {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
        String string2 = runtimeAccess.getDomainName();
        String string3 = runtimeAccess.getServerName();
        return string2 + "." + string3 + "." + "JMSXASessionPool." + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlatformHelper.ForeignRefReturn checkForeignRef(Map map) throws JMSException {
        Context context = null;
        PlatformHelper.ForeignRefReturn foreignRefReturn = new PlatformHelper.ForeignRefReturn((PlatformHelper)this);
        boolean bl = false;
        foreignRefReturn.subject = null;
        foreignRefReturn.foundCreds = false;
        foreignRefReturn.userNameBuf = new StringBuffer();
        foreignRefReturn.passwdBuf = new StringBuffer();
        foreignRefReturn.connectionHealthChecking = "enabled";
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
        if (authenticatedSubject.equals(KERNEL_ID)) {
            authenticatedSubject = SubjectManager.getSubjectManager().getAnonymousSubject();
        }
        Hashtable hashtable = JMSConnectionHelper.getJNDIEnvironment((Map)map);
        Hashtable hashtable2 = null;
        try {
            Object object;
            String string = JMSConnectionHelper.getJNDIName((Map)map);
            context = new InitialContext(hashtable);
            AuthenticatedSubject authenticatedSubject2 = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
            if (authenticatedSubject2.equals(KERNEL_ID)) {
                bl = true;
                SubjectManager.getSubjectManager().pushSubject((AbstractSubject)KERNEL_ID, (AbstractSubject)authenticatedSubject);
            }
            try {
                object = context.lookupLink(string);
            }
            finally {
                if (bl) {
                    SubjectManager.getSubjectManager().popSubject((AbstractSubject)KERNEL_ID);
                }
                context.close();
            }
            SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
            try {
                ForeignOpaqueReference foreignOpaqueReference;
                if (object instanceof ForeignOpaqueReference && (foreignOpaqueReference = (ForeignOpaqueReference)object).isFactory()) {
                    if (foreignOpaqueReference.getUsername() != null && foreignOpaqueReference.getUsername().length() > 0) {
                        foreignRefReturn.foundCreds = true;
                        foreignRefReturn.userNameBuf.append(foreignOpaqueReference.getUsername());
                        if (JMSPoolDebug.logger.isDebugEnabled()) {
                            JMSPoolDebug.logger.debug("Found credentials for connection factory with username " + foreignRefReturn.userNameBuf.toString());
                        }
                    }
                    if (foreignOpaqueReference.getPassword() != null && foreignOpaqueReference.getPassword().length() > 0) {
                        foreignRefReturn.foundCreds = true;
                        foreignRefReturn.passwdBuf.append(foreignOpaqueReference.getPassword());
                    }
                    foreignRefReturn.connectionHealthChecking = foreignOpaqueReference.getConnectionHealthChecking();
                    hashtable2 = foreignOpaqueReference.getJNDIEnvironment();
                }
            }
            finally {
                SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            }
            if (hashtable2 != null) {
                context = this.getForeignInitialContext(hashtable2, foreignRefReturn);
                context.close();
            }
            if (!foreignRefReturn.foundCreds && JMSPoolDebug.logger.isDebugEnabled()) {
                JMSPoolDebug.logger.debug("No credentials associated with connection factory");
            }
            return foreignRefReturn;
        }
        catch (NamingException namingException) {
            if (JMSPoolDebug.logger.isDebugEnabled()) {
                JMSPoolDebug.logger.debug("Can't get credentials associated with connection factory: " + namingException);
            }
            return foreignRefReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getForeignInitialContext(Hashtable hashtable, PlatformHelper.ForeignRefReturn foreignRefReturn) throws NamingException {
        if (JMSPoolDebug.logger.isDebugEnabled()) {
            JMSPoolDebug.logger.debug("JMSConnectionHelper.getForeignInitialContext() + jndiEnv ");
        }
        InitialContext initialContext = new InitialContext(hashtable);
        String string = (String)hashtable.get("java.naming.security.principal");
        String string2 = (String)hashtable.get("java.naming.security.credentials");
        if (string != null || string2 != null) {
            PlatformHelperImpl platformHelperImpl = this;
            synchronized (platformHelperImpl) {
                foreignRefReturn.subject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
                if (JMSPoolDebug.logger.isDebugEnabled()) {
                    JMSPoolDebug.logger.debug("JMSConnectionHelper.getForeignInitialContext(), subject " + foreignRefReturn.subject);
                }
            }
        }
        if (JMSPoolDebug.logger.isDebugEnabled()) {
            JMSPoolDebug.logger.debug("JMSConnectionHelper.getForeignInitialContext()  subject ****** url " + (String)hashtable.get("java.naming.provider.url"));
        }
        return initialContext;
    }
}

