/*
 * Decompiled with CFR 0.152.
 */
package weblogic.descriptor.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import weblogic.application.utils.IOUtils;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;

public class DescriptorUtils {
    private static final EditableDescriptorManager edm = new EditableDescriptorManager();

    private DescriptorUtils() {
    }

    public static void writeAsXML(DescriptorBean descriptorBean) {
        Descriptor descriptor = descriptorBean.getDescriptor();
        try {
            edm.writeDescriptorAsXML(descriptor, (OutputStream)new BufferedOutputStream(System.out){

                public void close() {
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeDescriptor(DescriptorManager descriptorManager, DescriptorBean descriptorBean, File file) throws IOException {
        OutputStream outputStream = null;
        try {
            IOUtils.checkCreateParent(file);
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            descriptorManager.writeDescriptorBeanAsXML(descriptorBean, outputStream);
            outputStream.flush();
            Object var5_4 = null;
            if (outputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static Object getOrCreateFirstChild(Object object, Object object2, String string) {
        Object object3 = DescriptorUtils.getFirstChild(object2);
        if (object3 != null) {
            return object3;
        }
        if (object == null) {
            throw new NullPointerException("Parent Bean object null");
        }
        Method method = DescriptorUtils.getMethod(object, "create" + string, new Class[0]);
        return DescriptorUtils.invokeMethod(object, method, new Object[0]);
    }

    public static Object getFirstChildOrDefaultBean(Object object, Object object2, String string) {
        Object object3 = DescriptorUtils.getFirstChild(object2);
        if (object3 != null) {
            return object3;
        }
        if (object == null) {
            throw new NullPointerException("Parent Bean object null");
        }
        Method method = DescriptorUtils.getMethod(object, "create" + string, new Class[0]);
        object3 = DescriptorUtils.invokeMethod(object, method, new Object[0]);
        if (object3 == null) {
            throw new IllegalArgumentException("Error creating bean " + string);
        }
        method = DescriptorUtils.getMethod(object, "destroy" + string, new Class[]{method.getReturnType()});
        DescriptorUtils.invokeMethod(object, method, new Object[]{object3});
        return object3;
    }

    private static Object getFirstChild(Object object) {
        if (object == null) {
            throw new NullPointerException("Array of children is null");
        }
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("childArray is not of type array");
        }
        if (Array.getLength(object) > 0) {
            return Array.get(object, 0);
        }
        return null;
    }

    private static Method getMethod(Object object, String string, Class[] classArray) {
        try {
            return object.getClass().getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(string + "() method does not exist on " + object.getClass());
        }
    }

    private static Object invokeMethod(Object object, Method method, Object[] objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(method + " method  not accessible on " + object.getClass());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(method + " method on " + object.getClass() + " threw an exception: " + invocationTargetException.getTargetException().getMessage());
        }
    }

    public static void main(String[] stringArray) throws IOException, XMLStreamException {
        if (stringArray.length > 0) {
            if (stringArray[0].equals("load") && stringArray.length > 1) {
                DescriptorManager descriptorManager = new DescriptorManager();
                Descriptor descriptor = descriptorManager.createDescriptor(XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(stringArray[1])));
                descriptorManager.writeDescriptorAsXML(descriptor, (OutputStream)System.out);
            }
        } else {
            System.out.println("Arguments: [load <descriptor_file>]");
        }
    }
}

