/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.accessor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.security.AccessController;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import weblogic.diagnostics.accessor.AccessorClientConstants;
import weblogic.diagnostics.accessor.AccessorUtils;
import weblogic.diagnostics.accessor.DiagnosticAccessRuntime;
import weblogic.diagnostics.accessor.XMLDataWriter;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.i18n.DiagnosticsTextTextFormatter;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.WLDFDataAccessRuntimeMBean;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.io.StreamUtils;

public final class AccessorServlet
extends HttpServlet
implements AccessorClientConstants {
    private static final DebugLogger ACCESSOR_DEBUG;
    private static final AuthenticatedSubject kernelId;
    private static final RuntimeAccess runtimeAccess;
    private static final String SERVLET_INFO = "Accessor Servlet";
    static final long serialVersionUID = -2951340701982146842L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Servlet_Request_Action_Around_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    public String getServletInfo() {
        return SERVLET_INFO;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        DiagnosticActionState[] diagnosticActionStateArray;
        DiagnosticAction[] diagnosticActionArray;
        boolean bl;
        block26: {
            block25: {
                block24: {
                    bl = _WLDF$INST_FLD_Servlet_Request_Action_Around_Medium.isEnabledAndNotDyeFiltered();
                    diagnosticActionArray = null;
                    diagnosticActionStateArray = null;
                    Object var16_6 = null;
                    if (bl) {
                        Object[] objectArray = null;
                        if (_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium.isArgumentsCaptureNeeded()) {
                            objectArray = new Object[]{this, httpServletRequest, httpServletResponse};
                        }
                        DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Servlet_Request_Action_Around_Medium;
                        diagnosticActionArray = delegatingMonitor.getActions();
                        diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                        InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                    }
                    try {
                        Object object;
                        httpServletRequest.setCharacterEncoding("UTF-8");
                        if (ACCESSOR_DEBUG.isDebugEnabled()) {
                            ACCESSOR_DEBUG.debug("Secure request = " + httpServletRequest.isSecure());
                        }
                        if (!httpServletRequest.isSecure() && runtimeAccess.getDomain().isProductionModeEnabled()) {
                            Loggable loggable = DiagnosticsLogger.logNonSecureAttemptToAccessDiagnosticDataLoggable();
                            loggable.log();
                            httpServletResponse.sendError(401, loggable.getMessage());
                            Object var14_12 = null;
                            if (!bl) return;
                            break block24;
                        }
                        String string = httpServletRequest.getHeader("username");
                        String string2 = httpServletRequest.getHeader("password");
                        if (string == null || string2 == null) {
                            httpServletResponse.sendError(401);
                            break block25;
                        }
                        String string3 = URLDecoder.decode(string, "UTF-8");
                        String string4 = URLDecoder.decode(string2, "UTF-8");
                        if (ACCESSOR_DEBUG.isDebugEnabled()) {
                            ACCESSOR_DEBUG.debug("User = " + string3);
                        }
                        AuthenticatedSubject authenticatedSubject = null;
                        try {
                            object = "weblogicDEFAULT";
                            PrincipalAuthenticator principalAuthenticator = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)kernelId, (String)object, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
                            authenticatedSubject = principalAuthenticator.authenticate((CallbackHandler)new SimpleCallbackHandler(string3, string4));
                        }
                        catch (LoginException loginException) {
                            httpServletResponse.sendError(401);
                            Object var14_14 = null;
                            if (!bl) return;
                            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                            return;
                        }
                        if (authenticatedSubject == null) break block26;
                        SecurityServiceManager.pushSubject((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject);
                        try {
                            AccessorUtils.ensureUserAuthorized();
                        }
                        catch (Exception exception) {
                            if (ACCESSOR_DEBUG.isDebugEnabled()) {
                                ACCESSOR_DEBUG.debug(exception.getMessage());
                            }
                            httpServletResponse.sendError(401);
                            SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
                            Object var14_15 = null;
                            if (!bl) return;
                            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                            return;
                        }
                        try {
                            object = this.getQueryType(httpServletRequest);
                            if (object == queryType.ACCESSOR) {
                                this.handleAccessorQuery(httpServletRequest, httpServletResponse);
                                break block26;
                            }
                            if (object == queryType.LISTIMAGES) {
                                this.handleListImages(httpServletRequest, httpServletResponse);
                                break block26;
                            }
                            if (object == queryType.GETIMAGE) {
                                this.handleGetImage(httpServletRequest, httpServletResponse);
                                break block26;
                            }
                            if (object == queryType.GETIMAGEENTRY) {
                                this.handleGetImageEntry(httpServletRequest, httpServletResponse);
                                break block26;
                            } else {
                                if (ACCESSOR_DEBUG.isDebugEnabled()) {
                                    ACCESSOR_DEBUG.debug("invalid query type returned");
                                }
                                httpServletResponse.sendError(500);
                            }
                            break block26;
                        }
                        catch (Exception exception) {
                            httpServletResponse.sendError(500);
                            break block26;
                        }
                        finally {
                            SecurityServiceManager.popSubject((AuthenticatedSubject)kernelId);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_17 = null;
                        if (!bl) throw throwable;
                        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, diagnosticActionArray, diagnosticActionStateArray);
                        throw throwable;
                    }
                }
                InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
                return;
            }
            Object var14_13 = null;
            if (!bl) return;
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            return;
        }
        Object var14_16 = null;
        if (!bl) return;
        InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Servlet_Request_Action_Around_Medium, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
    }

    private queryType getQueryType(HttpServletRequest httpServletRequest) {
        if (httpServletRequest.getParameter("listAvailableImages") != null) {
            return queryType.LISTIMAGES;
        }
        if (httpServletRequest.getParameter("getImage") != null) {
            if (httpServletRequest.getParameter("getImageEntry") != null) {
                return queryType.GETIMAGEENTRY;
            }
            return queryType.GETIMAGE;
        }
        return queryType.ACCESSOR;
    }

    private void handleAccessorQuery(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException, ManagementException, XMLStreamException {
        String string;
        httpServletResponse.setContentType("text/xml");
        String string2 = httpServletRequest.getParameter("logicalName");
        if (string2 == null || string2.length() == 0) {
            string2 = "ServerLog";
        }
        if (ACCESSOR_DEBUG.isDebugEnabled()) {
            ACCESSOR_DEBUG.debug("Logical name = " + string2);
        }
        if ((string = httpServletRequest.getParameter("query")) == null) {
            string = "";
        }
        if (ACCESSOR_DEBUG.isDebugEnabled()) {
            ACCESSOR_DEBUG.debug("Query = " + string);
        }
        long l = 0L;
        String string3 = httpServletRequest.getParameter("beginTimestamp");
        if (string3 != null && string3.length() >= 0) {
            l = Long.parseLong(string3);
        }
        if (ACCESSOR_DEBUG.isDebugEnabled()) {
            ACCESSOR_DEBUG.debug("Begin timestamp = " + l);
        }
        long l2 = Long.MAX_VALUE;
        string3 = httpServletRequest.getParameter("endTimestamp");
        if (string3 != null && string3.length() >= 0) {
            l2 = Long.parseLong(string3);
        }
        if (ACCESSOR_DEBUG.isDebugEnabled()) {
            ACCESSOR_DEBUG.debug("End timestamp = " + l2);
        }
        DiagnosticAccessRuntime diagnosticAccessRuntime = DiagnosticAccessRuntime.getInstance();
        WLDFDataAccessRuntimeMBean wLDFDataAccessRuntimeMBean = diagnosticAccessRuntime.lookupWLDFDataAccessRuntime(string2);
        XMLDataWriter xMLDataWriter = new XMLDataWriter(new BufferedOutputStream((OutputStream)httpServletResponse.getOutputStream()), false);
        xMLDataWriter.exportDiagnosticDataToXML(wLDFDataAccessRuntimeMBean.getColumns(), wLDFDataAccessRuntimeMBean.retrieveDataRecords(l, l2, string));
    }

    private void handleListImages(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (ACCESSOR_DEBUG.isDebugEnabled()) {
            ACCESSOR_DEBUG.debug("handleListImages");
        }
        String[] stringArray = ImageManager.getInstance().getAvailableCapturedImages();
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream((OutputStream)servletOutputStream));
        objectOutputStream.writeObject(stringArray);
        objectOutputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        if (ACCESSOR_DEBUG.isDebugEnabled()) {
            ACCESSOR_DEBUG.debug("handleGetImage");
        }
        if ((string = httpServletRequest.getParameter("getImage")) == null) {
            throw new ServletException(DiagnosticsTextTextFormatter.getInstance().getAccessorClientInvalidImageName(string));
        }
        ImageManager imageManager = ImageManager.getInstance();
        File file = imageManager.findImageFile(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        try {
            StreamUtils.writeTo((InputStream)fileInputStream, (OutputStream)servletOutputStream);
            servletOutputStream.flush();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetImageEntry(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        if (ACCESSOR_DEBUG.isDebugEnabled()) {
            ACCESSOR_DEBUG.debug("handleGetImageEntry");
        }
        if ((string = httpServletRequest.getParameter("getImage")) == null) {
            throw new ServletException(DiagnosticsTextTextFormatter.getInstance().getAccessorClientInvalidImageName(string));
        }
        String string2 = httpServletRequest.getParameter("getImageEntry");
        if (string2 == null) {
            throw new ServletException(DiagnosticsTextTextFormatter.getInstance().getAccessorClientInvalidImageEntryName(string, string2));
        }
        ImageManager imageManager = ImageManager.getInstance();
        ZipFile zipFile = null;
        ZipEntry zipEntry = null;
        InputStream inputStream = null;
        try {
            File file = imageManager.findImageFile(string);
            zipFile = new ZipFile(file);
            zipEntry = zipFile.getEntry(string2);
            if (zipEntry == null) {
                throw new ServletException(DiagnosticsTextTextFormatter.getInstance().getAccessorClientImageEntryNotFound(string, string2));
            }
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            inputStream = zipFile.getInputStream(zipEntry);
            StreamUtils.writeTo((InputStream)inputStream, (OutputStream)servletOutputStream);
            servletOutputStream.flush();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.diagnostics.accessor.AccessorServlet");
        _WLDF$INST_FLD_Servlet_Request_Action_Around_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Servlet_Request_Action_Around_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"AccessorServlet.java", (String)"weblogic.diagnostics.accessor.AccessorServlet", (String)"doGet", (String)"(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V", (int)92, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Servlet_Request_Action_Around_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"req", (String)"weblogic.diagnostics.instrumentation.gathering.ServletRequestRenderer", (boolean)false, (boolean)true), null})}), (boolean)false);
        ACCESSOR_DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticAccessor");
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum queryType {
        ACCESSOR,
        LISTIMAGES,
        GETIMAGE,
        GETIMAGEENTRY;

    }
}

