/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.accessor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import weblogic.diagnostics.accessor.AccessorClientConstants;
import weblogic.diagnostics.i18n.DiagnosticsTextTextFormatter;
import weblogic.utils.FileUtils;

public class AccessorServletClient
implements AccessorClientConstants {
    public static void exportDiagnosticData(String string, String string2, String string3, String string4, String string5, long l, long l2, String string6) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string6);
        PrintStream printStream = new PrintStream((OutputStream)fileOutputStream, false, "UTF-8");
        AccessorServletClient.exportDiagnosticData(string, string2, string3, string4, string5, l, l2, printStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportDiagnosticData(String string, String string2, String string3, String string4, String string5, long l, long l2, PrintStream printStream) throws IOException {
        try {
            String string6 = string3 + "/bea_wls_diagnostics/accessor?" + "logicalName" + "=" + URLEncoder.encode(string4, "UTF-8") + "&" + "query" + "=" + URLEncoder.encode(string5, "UTF-8") + "&" + "beginTimestamp" + "=" + l + "&" + "endTimestamp" + "=" + l2;
            URL uRL = new URL(string6);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("username", URLEncoder.encode(string, "UTF-8"));
            httpURLConnection.setRequestProperty("password", URLEncoder.encode(string2, "UTF-8"));
            httpURLConnection.connect();
            InputStream inputStream = httpURLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string7 = null;
            while ((string7 = bufferedReader.readLine()) != null) {
                printStream.println(string7);
            }
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                throw new IOException(DiagnosticsTextTextFormatter.getInstance().getAccessorClientIOException(n));
            }
        }
        finally {
            printStream.flush();
            printStream.close();
        }
    }

    public static String[] listAvailableImages(String string, String string2, String string3) throws IOException, ClassNotFoundException {
        String string4 = string3 + "/bea_wls_diagnostics/accessor?" + "listAvailableImages" + "=";
        URL uRL = new URL(string4);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("username", URLEncoder.encode(string, "UTF-8"));
        httpURLConnection.setRequestProperty("password", URLEncoder.encode(string2, "UTF-8"));
        httpURLConnection.connect();
        InputStream inputStream = httpURLConnection.getInputStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        String[] stringArray = (String[])objectInputStream.readObject();
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            throw new IOException(DiagnosticsTextTextFormatter.getInstance().getAccessorClientIOException(n));
        }
        return stringArray;
    }

    public static void saveDiagnosticImageCaptureFile(String string, String string2, String string3, String string4, String string5) throws IOException {
        String string6 = string3 + "/bea_wls_diagnostics/accessor?" + "getImage" + "=" + URLEncoder.encode(string4, "UTF-8");
        AccessorServletClient.retrieveFile(string, string2, string5, string6);
    }

    public static void saveDiagnosticImageCaptureEntryFile(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        String string7 = string3 + "/bea_wls_diagnostics/accessor?" + "getImage" + "=" + URLEncoder.encode(string4, "UTF-8") + "&" + "getImageEntry" + "=" + URLEncoder.encode(string5, "UTF-8");
        AccessorServletClient.retrieveFile(string, string2, string6, string7);
    }

    private static void retrieveFile(String string, String string2, String string3, String string4) throws MalformedURLException, IOException, UnsupportedEncodingException, FileNotFoundException {
        URL uRL = new URL(string4);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestProperty("username", URLEncoder.encode(string, "UTF-8"));
        httpURLConnection.setRequestProperty("password", URLEncoder.encode(string2, "UTF-8"));
        httpURLConnection.connect();
        InputStream inputStream = httpURLConnection.getInputStream();
        File file = new File(string3);
        FileUtils.writeToFile((InputStream)inputStream, (File)file);
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            if (file.exists()) {
                file.delete();
            }
            throw new IOException(DiagnosticsTextTextFormatter.getInstance().getAccessorClientIOException(n));
        }
    }
}

