/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.accessor;

import java.io.File;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.connector.external.RAUtil;
import weblogic.diagnostics.accessor.AccessorConstants;
import weblogic.diagnostics.accessor.UnknownLogTypeException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceParamsBean;
import weblogic.logging.Loggable;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DataSourceLogFileMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JMSMessageLogFileMBean;
import weblogic.management.configuration.JMSSAFMessageLogFileMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.LogMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.configuration.WebServerLogMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.WLDFArchiveRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.AdminResource;
import weblogic.security.service.AuthorizationManager;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.Resource;
import weblogic.servlet.utils.ServletAccessorHelper;

public final class AccessorUtils
implements AccessorConstants {
    private static final DebugLogger ACCESSOR_DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticAccessor");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static AuthorizationManager am = null;
    private static final AdminResource LOG_VIEW_RESOURCE = new AdminResource("ViewLog", null, null);
    private static final RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);

    public static void ensureUserAuthorized() throws ManagementException {
        AuthenticatedSubject authenticatedSubject;
        if (am == null) {
            am = (AuthorizationManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.AUTHORIZE);
        }
        if (!am.isAccessAllowed(authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), (Resource)LOG_VIEW_RESOURCE, null)) {
            Loggable loggable = DiagnosticsLogger.logUserNotAuthorizedToViewLogsLoggable((String)authenticatedSubject.toString());
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    public static boolean isAdminServer() {
        return runtimeAccess.isAdminServer();
    }

    public static Set getAvailableVirtualHosts() {
        VirtualHostMBean[] virtualHostMBeanArray = runtimeAccess.getDomain().getVirtualHosts();
        HashSet<VirtualHostMBean> hashSet = new HashSet<VirtualHostMBean>();
        if (virtualHostMBeanArray != null) {
            for (int i = 0; i < virtualHostMBeanArray.length; ++i) {
                if (!AccessorUtils.isDeploymentAvailableOnTarget(virtualHostMBeanArray[i])) continue;
                hashSet.add(virtualHostMBeanArray[i]);
            }
        }
        return hashSet;
    }

    public static Set getAvailableJMSServers() {
        JMSServerMBean[] jMSServerMBeanArray = runtimeAccess.getDomain().getJMSServers();
        HashSet<JMSServerMBean> hashSet = new HashSet<JMSServerMBean>();
        if (jMSServerMBeanArray != null) {
            for (int i = 0; i < jMSServerMBeanArray.length; ++i) {
                if (!AccessorUtils.isDeploymentAvailableOnTarget(jMSServerMBeanArray[i])) continue;
                hashSet.add(jMSServerMBeanArray[i]);
            }
        }
        return hashSet;
    }

    public static Set getAvailableSAFAgents() {
        SAFAgentMBean[] sAFAgentMBeanArray = runtimeAccess.getDomain().getSAFAgents();
        HashSet<SAFAgentMBean> hashSet = new HashSet<SAFAgentMBean>();
        if (sAFAgentMBeanArray != null) {
            for (int i = 0; i < sAFAgentMBeanArray.length; ++i) {
                if (!AccessorUtils.isDeploymentAvailableOnTarget(sAFAgentMBeanArray[i])) continue;
                hashSet.add(sAFAgentMBeanArray[i]);
            }
        }
        return hashSet;
    }

    public static Set getAvailableCustomArchives() {
        WLDFArchiveRuntimeMBean[] wLDFArchiveRuntimeMBeanArray = runtimeAccess.getServerRuntime().getWLDFRuntime().getWLDFArchiveRuntimes();
        HashSet<WLDFArchiveRuntimeMBean> hashSet = new HashSet<WLDFArchiveRuntimeMBean>();
        if (wLDFArchiveRuntimeMBeanArray != null) {
            for (int i = 0; i < wLDFArchiveRuntimeMBeanArray.length; ++i) {
                if (!wLDFArchiveRuntimeMBeanArray[i].getName().startsWith("CUSTOM/")) continue;
                hashSet.add(wLDFArchiveRuntimeMBeanArray[i]);
            }
        }
        return hashSet;
    }

    private static boolean isDeploymentAvailableOnTarget(DeploymentMBean deploymentMBean) {
        TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
        if (targetMBeanArray == null) {
            return false;
        }
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            ClusterMBean clusterMBean;
            TargetMBean targetMBean = targetMBeanArray[i];
            String string = targetMBeanArray[i].getName();
            if (targetMBean instanceof ServerMBean && string.equals(runtimeAccess.getServerName())) {
                return true;
            }
            if (!(targetMBean instanceof ClusterMBean) || (clusterMBean = runtimeAccess.getServer().getCluster()) == null || !clusterMBean.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean compareMaps(Map map, Map map2) {
        if (map.size() == map2.size()) {
            Set set = map.keySet();
            for (Object k : set) {
                Object v = map.get(k);
                Object v2 = map2.get(k);
                if (v != null && v2 != null) {
                    if (v.equals(v2)) continue;
                    return false;
                }
                if (v == null && v2 == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getDiagnosticStoreDirectory() {
        ServerMBean serverMBean = runtimeAccess.getServer();
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = serverMBean.getServerDiagnosticConfig();
        String string = wLDFServerDiagnosticMBean.getDiagnosticStoreDir();
        File file = new File(string);
        if (!file.isAbsolute()) {
            string = DomainDir.getPathRelativeServerDir((String)runtimeAccess.getServerName(), (String)string);
            file = new File(string);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        string = file.getAbsolutePath();
        return string;
    }

    static Map getParamsForServerLog() {
        LogMBean logMBean = runtimeAccess.getServer().getLog();
        String string = logMBean.computeLogFilePath();
        String string2 = logMBean.getLogFileRotationDir();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("logFilePath", string);
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        hashMap.put("logRotationDir", string2);
        return hashMap;
    }

    static Map getParamsForDataSourceLog() {
        DataSourceLogFileMBean dataSourceLogFileMBean = runtimeAccess.getServer().getDataSource().getDataSourceLogFile();
        String string = dataSourceLogFileMBean.computeLogFilePath();
        String string2 = dataSourceLogFileMBean.getLogFileRotationDir();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("logFilePath", string);
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        hashMap.put("logRotationDir", string2);
        return hashMap;
    }

    static Map getParamsForDomainLog() {
        LogMBean logMBean = runtimeAccess.getDomain().getLog();
        String string = logMBean.computeLogFilePath();
        String string2 = logMBean.getLogFileRotationDir();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("logFilePath", string);
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        hashMap.put("logRotationDir", string2);
        return hashMap;
    }

    static Map getParamsForHTTPAccessLog(String[] stringArray) throws UnknownLogTypeException {
        Object object3;
        String string;
        Object object2 = runtimeAccess.getServer().getWebServer();
        String string2 = string = stringArray.length == 2 ? stringArray[1] : null;
        if (string != null && string.length() > 0) {
            for (Object object3 : AccessorUtils.getAvailableVirtualHosts()) {
                if (!object3.getName().equals(string)) continue;
                object2 = object3;
                break;
            }
        }
        WebServerLogMBean webServerLogMBean = object2.getWebServerLog();
        object3 = webServerLogMBean.computeLogFilePath();
        String string3 = webServerLogMBean.getLogFileRotationDir();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("logFilePath", object3);
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        hashMap.put("logRotationDir", string3);
        if (webServerLogMBean.getLogFileFormat().equals("extended")) {
            hashMap.put("elfFields", webServerLogMBean.getELFFields());
        }
        return hashMap;
    }

    static Map getParamsForDiagnosticDataArchive() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = runtimeAccess.getServer().getServerDiagnosticConfig();
        String string = wLDFServerDiagnosticMBean.getDiagnosticDataArchiveType();
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        if (string.equals("JDBCArchive")) {
            JDBCDataSourceBean jDBCDataSourceBean;
            JDBCDataSourceParamsBean jDBCDataSourceParamsBean;
            String[] stringArray;
            JDBCSystemResourceMBean jDBCSystemResourceMBean = wLDFServerDiagnosticMBean.getDiagnosticJDBCResource();
            String string2 = null;
            if (jDBCSystemResourceMBean != null && (stringArray = (jDBCDataSourceParamsBean = (jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource()).getJDBCDataSourceParams()).getJNDINames()) != null && stringArray.length > 0) {
                string2 = stringArray[0];
            }
            if (string2 != null) {
                hashMap.put("jndiName", string2);
            } else {
                DiagnosticsLogger.logIncompleteJDBCArchiveConfiguration();
            }
        }
        return hashMap;
    }

    static Map getParamsForGenericDataArchive() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        return hashMap;
    }

    static Map getParamsForWebAppLog(String[] stringArray) throws UnknownLogTypeException {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = stringArray.length;
        String string2 = n >= 2 ? stringArray[1] : null;
        String string3 = "/";
        if (n >= 3) {
            string3 = string3 + stringArray[2];
        }
        if ((string = ServletAccessorHelper.getLogFileName(string2, string3)) == null) {
            throw new UnknownLogTypeException("Logs dont exist for the webapp");
        }
        String string4 = ServletAccessorHelper.getLogFileRotationDir(string2, string3);
        hashMap.put("logFilePath", string);
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        hashMap.put("logRotationDir", string4);
        return hashMap;
    }

    static Map getParamsForConnectorLog(String string) throws UnknownLogTypeException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = "ConnectorLog".length() + 1;
        String string2 = string.substring(n);
        String string3 = RAUtil.getLogFileName(string2);
        if (string3 == null) {
            throw new UnknownLogTypeException("Logs dont exist for the outbound connection " + string2);
        }
        String string4 = RAUtil.getLogFileRotationDir(string2);
        hashMap.put("logFilePath", string3);
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        hashMap.put("logRotationDir", string4);
        return hashMap;
    }

    static Map getParamsForJMSMessageLog(String string) throws UnknownLogTypeException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = "JMSMessageLog".length() + 1;
        String string2 = string.substring(n);
        JMSServerMBean jMSServerMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().lookupJMSServer(string2);
        if (jMSServerMBean == null) {
            throw new UnknownLogTypeException("JMS Server does not exist " + string2);
        }
        JMSMessageLogFileMBean jMSMessageLogFileMBean = jMSServerMBean.getJMSMessageLogFile();
        String string3 = jMSMessageLogFileMBean.computeLogFilePath();
        String string4 = jMSMessageLogFileMBean.getLogFileRotationDir();
        hashMap.put("logFilePath", string3);
        hashMap.put("logRotationDir", string4);
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        return hashMap;
    }

    static Map getParamsForJMSSAFMessageLog(String string) throws UnknownLogTypeException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = "JMSSAFMessageLog".length() + 1;
        String string2 = string.substring(n);
        SAFAgentMBean sAFAgentMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().lookupSAFAgent(string2);
        if (sAFAgentMBean == null) {
            throw new UnknownLogTypeException("SAF Agent does not exist " + sAFAgentMBean);
        }
        JMSSAFMessageLogFileMBean jMSSAFMessageLogFileMBean = sAFAgentMBean.getJMSSAFMessageLogFile();
        String string3 = jMSSAFMessageLogFileMBean.computeLogFilePath();
        String string4 = jMSSAFMessageLogFileMBean.getLogFileRotationDir();
        hashMap.put("logFilePath", string3);
        hashMap.put("logRotationDir", string4);
        hashMap.put("storeDir", AccessorUtils.getDiagnosticStoreDirectory());
        return hashMap;
    }
}

