/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.accessor;

import weblogic.diagnostics.accessor.AccessRuntime;
import weblogic.diagnostics.accessor.AccessorConfigurationProvider;
import weblogic.diagnostics.accessor.AccessorConstants;
import weblogic.diagnostics.accessor.AccessorMBeanFactory;
import weblogic.diagnostics.accessor.AccessorSecurityProvider;
import weblogic.diagnostics.accessor.ColumnInfo;
import weblogic.diagnostics.accessor.runtime.DataAccessRuntimeMBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WLDFAccessRuntimeMBean;
import weblogic.management.runtime.WLDFDataAccessRuntimeMBean;

public class DiagnosticAccessRuntime
extends AccessRuntime
implements WLDFAccessRuntimeMBean,
AccessorConstants {
    private static final DebugLogger ACCESSOR_DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticAccessor");

    public static DiagnosticAccessRuntime getInstance() throws ManagementException {
        try {
            return (DiagnosticAccessRuntime)AccessRuntime.getAccessorInstance();
        }
        catch (ClassCastException classCastException) {
            throw new ManagementException((Throwable)classCastException);
        }
    }

    DiagnosticAccessRuntime(AccessorMBeanFactory accessorMBeanFactory, AccessorConfigurationProvider accessorConfigurationProvider, AccessorSecurityProvider accessorSecurityProvider, RuntimeMBean runtimeMBean) throws ManagementException {
        super(accessorMBeanFactory, accessorConfigurationProvider, accessorSecurityProvider, runtimeMBean);
    }

    public WLDFDataAccessRuntimeMBean lookupWLDFDataAccessRuntime(String string) throws ManagementException {
        return this.lookupWLDFDataAccessRuntime(string, null);
    }

    public WLDFDataAccessRuntimeMBean lookupWLDFDataAccessRuntime(String string, ColumnInfo[] columnInfoArray) throws ManagementException {
        try {
            return (WLDFDataAccessRuntimeMBean)super.lookupDataAccessRuntime(string, columnInfoArray);
        }
        catch (ClassCastException classCastException) {
            throw new ManagementException((Throwable)classCastException);
        }
    }

    public WLDFDataAccessRuntimeMBean[] getWLDFDataAccessRuntimes() throws ManagementException {
        try {
            DataAccessRuntimeMBean[] dataAccessRuntimeMBeanArray = super.getDataAccessRuntimes();
            int n = dataAccessRuntimeMBeanArray != null ? dataAccessRuntimeMBeanArray.length : 0;
            WLDFDataAccessRuntimeMBean[] wLDFDataAccessRuntimeMBeanArray = new WLDFDataAccessRuntimeMBean[n];
            System.arraycopy(dataAccessRuntimeMBeanArray, 0, wLDFDataAccessRuntimeMBeanArray, 0, n);
            return wLDFDataAccessRuntimeMBeanArray;
        }
        catch (ClassCastException classCastException) {
            throw new ManagementException((Throwable)classCastException);
        }
    }
}

