/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.accessor;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.naming.NamingException;
import weblogic.diagnostics.accessor.AccessorConstants;
import weblogic.diagnostics.accessor.ColumnInfo;
import weblogic.diagnostics.accessor.DataAccessServiceCreateException;
import weblogic.diagnostics.accessor.DiagnosticDataAccessService;
import weblogic.diagnostics.accessor.UnknownLogTypeException;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.archive.dbstore.EventsJdbcDataArchive;
import weblogic.diagnostics.archive.dbstore.HarvestedJdbcDataArchive;
import weblogic.diagnostics.archive.filestore.AccessLogFileDataArchive;
import weblogic.diagnostics.archive.filestore.DataSourceLogFileDataArchive;
import weblogic.diagnostics.archive.filestore.JMSLogFileDataArchive;
import weblogic.diagnostics.archive.filestore.ServerLogFileDataArchive;
import weblogic.diagnostics.archive.filestore.UnformattedLogFileDataArchive;
import weblogic.diagnostics.archive.wlstore.EventsPersistentStoreDataArchive;
import weblogic.diagnostics.archive.wlstore.GenericPersistentStoreDataArchive;
import weblogic.diagnostics.archive.wlstore.HarvestedPersistentStoreDataArchive;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.kernel.Kernel;
import weblogic.management.ManagementException;
import weblogic.store.PersistentStoreException;

public final class DiagnosticDataAccessServiceFactory
implements AccessorConstants {
    public static DiagnosticDataAccessService createDiagnosticDataAccessService(String string, String string2, Map map) throws UnknownLogTypeException, DataAccessServiceCreateException {
        return DiagnosticDataAccessServiceFactory.createDiagnosticDataAccessService(string, string2, null, map);
    }

    public static DiagnosticDataAccessService createDiagnosticDataAccessService(String string, String string2, ColumnInfo[] columnInfoArray, Map map) throws UnknownLogTypeException, DataAccessServiceCreateException {
        try {
            if (string2.equals("ServerLog")) {
                return DiagnosticDataAccessServiceFactory.createServerLogDataAccessService(string, map);
            }
            if (string2.equals("DomainLog")) {
                return DiagnosticDataAccessServiceFactory.createDomainLogDataAccessService(string, map);
            }
            if (string2.equals("DataSourceLog")) {
                return DiagnosticDataAccessServiceFactory.createDataSourceLogDataAccessService(string, map);
            }
            if (string2.equals("HarvestedDataArchive")) {
                return DiagnosticDataAccessServiceFactory.createHarvestedDataAccessService(string, map);
            }
            if (string2.equals("EventsDataArchive")) {
                return DiagnosticDataAccessServiceFactory.createEventsDataAccessService(string, map);
            }
            if (string2.equals("HTTPAccessLog")) {
                return DiagnosticDataAccessServiceFactory.createHTTPAccessLogDataAccessService(string, map);
            }
            if (string2.equals("WebAppLog")) {
                return DiagnosticDataAccessServiceFactory.createWebAppLogDataAccessService(string, map);
            }
            if (string2.equals("ConnectorLog")) {
                return DiagnosticDataAccessServiceFactory.createConnectorLogDataAccessService(string, map);
            }
            if (string2.equals("JMSMessageLog") || string2.equals("JMSSAFMessageLog")) {
                return DiagnosticDataAccessServiceFactory.createJMSMessageLogDataAccessService(string, map);
            }
            if (string2.equals("CUSTOM")) {
                return DiagnosticDataAccessServiceFactory.createGenericDataAccessService(string, columnInfoArray, map);
            }
            throw new UnknownLogTypeException(string2);
        }
        catch (Exception exception) {
            throw new DataAccessServiceCreateException((Throwable)exception);
        }
    }

    private static DiagnosticDataAccessService createServerLogDataAccessService(String string, Map map) throws IOException, ManagementException {
        String string2 = (String)map.get("logFilePath");
        File file = new File(string2);
        String string3 = (String)map.get("storeDir");
        File file2 = string3 != null ? new File(string3) : null;
        File file3 = file.getParentFile();
        String string4 = (String)map.get("logRotationDir");
        if (string4 != null && string4.length() > 0) {
            file3 = new File(string4);
        }
        return new ServerLogFileDataArchive(string, new File(string2), file3, file2, false);
    }

    private static DiagnosticDataAccessService createDomainLogDataAccessService(String string, Map map) throws IOException, ManagementException {
        String string2 = (String)map.get("logFilePath");
        File file = new File(string2);
        String string3 = (String)map.get("storeDir");
        File file2 = string3 != null ? new File(string3) : null;
        File file3 = file.getParentFile();
        String string4 = (String)map.get("logRotationDir");
        if (string4 != null && string4.length() > 0) {
            file3 = new File(string4);
        }
        return new ServerLogFileDataArchive(string, new File(string2), file3, file2, !Kernel.isServer());
    }

    private static DiagnosticDataAccessService createDataSourceLogDataAccessService(String string, Map map) throws IOException, ManagementException {
        String string2 = (String)map.get("logFilePath");
        File file = new File(string2);
        String string3 = (String)map.get("storeDir");
        File file2 = string3 != null ? new File(string3) : null;
        File file3 = file.getParentFile();
        String string4 = (String)map.get("logRotationDir");
        if (string4 != null && string4.length() > 0) {
            file3 = new File(string4);
        }
        return new DataSourceLogFileDataArchive(string, new File(string2), file3, file2, !Kernel.isServer());
    }

    private static DiagnosticDataAccessService createHTTPAccessLogDataAccessService(String string, Map map) throws IOException, ManagementException {
        String string2 = (String)map.get("logFilePath");
        File file = new File(string2);
        String string3 = (String)map.get("storeDir");
        File file2 = string3 != null ? new File(string3) : null;
        File file3 = file.getParentFile();
        String string4 = (String)map.get("logRotationDir");
        if (string4 != null && string4.length() > 0) {
            file3 = new File(string4);
        }
        ColumnInfo[] columnInfoArray = ArchiveConstants.getColumns(4);
        int n = -1;
        int n2 = 4;
        int n3 = 5;
        if (map.containsKey("elfFields")) {
            n2 = -1;
            String string5 = (String)map.get("elfFields");
            String[] stringArray = string5.trim().split("\\s+");
            return new AccessLogFileDataArchive(string, new File(string2), file3, file2, stringArray, !Kernel.isServer());
        }
        return new AccessLogFileDataArchive(string, new File(string2), file3, file2, "dd/MMM/yyyy:HH:mm:ss Z", columnInfoArray, n, n2, !Kernel.isServer());
    }

    private static DiagnosticDataAccessService createHarvestedDataAccessService(String string, Map map) throws PersistentStoreException, NamingException, ManagementException {
        String string2;
        if (map.containsKey("jndiName")) {
            string2 = (String)map.get("jndiName");
            try {
                return new HarvestedJdbcDataArchive(string, string2);
            }
            catch (Exception exception) {
                DiagnosticsLogger.logErrorInitializingJDBCArchive((String)string, (Throwable)exception);
            }
        }
        string2 = (String)map.get("storeDir");
        return new HarvestedPersistentStoreDataArchive(string, string2, !Kernel.isServer());
    }

    private static DiagnosticDataAccessService createEventsDataAccessService(String string, Map map) throws PersistentStoreException, NamingException, ManagementException {
        String string2;
        if (map.containsKey("jndiName")) {
            string2 = (String)map.get("jndiName");
            try {
                return new EventsJdbcDataArchive(string, string2);
            }
            catch (Exception exception) {
                DiagnosticsLogger.logErrorInitializingJDBCArchive((String)string, (Throwable)exception);
            }
        }
        string2 = (String)map.get("storeDir");
        return new EventsPersistentStoreDataArchive(string, string2, !Kernel.isServer());
    }

    private static DiagnosticDataAccessService createGenericDataAccessService(String string, ColumnInfo[] columnInfoArray, Map map) throws PersistentStoreException, ManagementException {
        int n;
        String string2 = (String)map.get("storeDir");
        if (string2 == null) {
            throw new PersistentStoreException("Missing diagnostic store directory");
        }
        int n2 = n = columnInfoArray != null ? columnInfoArray.length : 0;
        if (n > 0) {
            ColumnInfo columnInfo = columnInfoArray[0];
            if (!columnInfo.getColumnName().equals("RECORDID") || columnInfo.getColumnType() != 2) {
                throw new PersistentStoreException("Missing first column RECORDID of type COLTYPE_LONG");
            }
            ColumnInfo columnInfo2 = columnInfo = n > 1 ? columnInfoArray[1] : null;
            if (columnInfo == null || !columnInfo.getColumnName().equals("TIMESTAMP") || columnInfo.getColumnType() != 2) {
                throw new PersistentStoreException("Missing second column TIMESTAMP of type COLTYPE_LONG");
            }
        } else {
            columnInfoArray = null;
        }
        return new GenericPersistentStoreDataArchive(string, columnInfoArray, string2, !Kernel.isServer());
    }

    private static DiagnosticDataAccessService createWebAppLogDataAccessService(String string, Map map) throws IOException, ManagementException {
        String string2 = (String)map.get("logFilePath");
        File file = new File(string2);
        String string3 = (String)map.get("storeDir");
        File file2 = string3 != null ? new File(string3) : null;
        File file3 = file.getParentFile();
        String string4 = (String)map.get("logRotationDir");
        if (string4 != null && string4.length() > 0) {
            file3 = new File(string4);
        }
        return new ServerLogFileDataArchive(string, new File(string2), file3, file2, !Kernel.isServer());
    }

    private static DiagnosticDataAccessService createConnectorLogDataAccessService(String string, Map map) throws IOException, ManagementException {
        String string2 = (String)map.get("logFilePath");
        File file = new File(string2);
        String string3 = (String)map.get("storeDir");
        File file2 = string3 != null ? new File(string3) : null;
        File file3 = file.getParentFile();
        String string4 = (String)map.get("logRotationDir");
        if (string4 != null && string4.length() > 0) {
            file3 = new File(string4);
        }
        return new UnformattedLogFileDataArchive(string, new File(string2), file3, file2, !Kernel.isServer());
    }

    private static DiagnosticDataAccessService createJMSMessageLogDataAccessService(String string, Map map) throws IOException, ManagementException {
        String string2;
        String string3 = (String)map.get("logFilePath");
        File file = new File(string3);
        File file2 = file.getParentFile();
        String string4 = (String)map.get("logRotationDir");
        if (string4 != null && string4.length() > 0) {
            file2 = new File(string4);
        }
        File file3 = (string2 = (String)map.get("storeDir")) != null ? new File(string2) : null;
        return new JMSLogFileDataArchive(string, new File(string3), file3, !Kernel.isServer());
    }
}

