/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.accessor;

import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import weblogic.diagnostics.accessor.AccessorConfiguration;
import weblogic.diagnostics.accessor.AccessorConfigurationProvider;
import weblogic.diagnostics.accessor.AccessorConstants;
import weblogic.diagnostics.accessor.AccessorMBeanFactory;
import weblogic.diagnostics.accessor.AccessorUtils;
import weblogic.diagnostics.accessor.ColumnInfo;
import weblogic.diagnostics.accessor.EditableAccessorConfiguration;
import weblogic.diagnostics.accessor.LogAccessorConfiguration;
import weblogic.diagnostics.accessor.UnknownLogTypeException;
import weblogic.diagnostics.accessor.parser.LogRecordParser;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WLDFDataRetirementByAgeMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class WLSAccessorConfigurationProviderImpl
implements AccessorConfigurationProvider,
AccessorConstants {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticAccessor");
    private static final AuthenticatedSubject KERNELID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNELID);
    private AccessorMBeanFactory accessorMBeanFactory;
    private Map accessorMap = new HashMap();
    private static final String[] EDITABLE_ACCESSOR_TYPES = new String[]{"CUSTOM", "EventsDataArchive", "HarvestedDataArchive"};
    private static final String[] SIZE_BASED_RETIREMENT_PARTICIPANTS = new String[]{"EventsDataArchive", "HarvestedDataArchive"};

    private static WLDFServerDiagnosticMBean getWLDFConfiguration() {
        ServerMBean serverMBean = runtimeAccess.getServer();
        return serverMBean.getServerDiagnosticConfig();
    }

    public WLSAccessorConfigurationProviderImpl(AccessorMBeanFactory accessorMBeanFactory) {
        this.accessorMBeanFactory = accessorMBeanFactory;
    }

    public boolean isDataRetirementTestModeEnabled() {
        return WLSAccessorConfigurationProviderImpl.getWLDFConfiguration().isDataRetirementTestModeEnabled();
    }

    public String getStoreDirectory() {
        return AccessorUtils.getDiagnosticStoreDirectory();
    }

    public boolean isDataRetirementEnabled() {
        return WLSAccessorConfigurationProviderImpl.getWLDFConfiguration().isDataRetirementEnabled();
    }

    public int getPreferredStoreSizeLimit() {
        return WLSAccessorConfigurationProviderImpl.getWLDFConfiguration().getPreferredStoreSizeLimit();
    }

    public int getStoreSizeCheckPeriod() {
        return WLSAccessorConfigurationProviderImpl.getWLDFConfiguration().getStoreSizeCheckPeriod();
    }

    public AccessorConfiguration getAccessorConfiguration(String string) throws UnknownLogTypeException {
        Map map = this.getAccessorProperties(string);
        if (map.get("logFilePath") != null) {
            return new LogAccessorConfigurationImpl(string, map);
        }
        if (WLSAccessorConfigurationProviderImpl.isEditableAccessor(string)) {
            return new EditableAccessorConfigurationImpl(string, map);
        }
        return new AccessorConfigurationImpl(string, map);
    }

    public synchronized String[] getAccessorNames() {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        try {
            stringArray = this.accessorMBeanFactory.getAvailableDiagnosticDataAccessorNames();
            int n = stringArray != null ? stringArray.length : 0;
            for (int i = 0; i < n; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        catch (ManagementException managementException) {
            UnexpectedExceptionHandler.handle(managementException.getMessage(), managementException);
        }
        hashSet.addAll(this.accessorMap.keySet());
        stringArray = new String[hashSet.size()];
        stringArray = hashSet.toArray(stringArray);
        return stringArray;
    }

    public synchronized void addAccessor(AccessorConfiguration accessorConfiguration) {
        String string = accessorConfiguration.getName();
        if (this.accessorMap.get(string) == null) {
            this.accessorMap.put(string, accessorConfiguration);
        }
    }

    public synchronized void removeAccessor(AccessorConfiguration accessorConfiguration) {
        String string = accessorConfiguration.getName();
        if (this.accessorMap.get(string) != null) {
            this.accessorMap.remove(string);
        }
    }

    private static String getAccessorType(String string) {
        String[] stringArray = string.split("/");
        return stringArray[0];
    }

    private static boolean isEditableAccessor(String string) {
        String string2 = WLSAccessorConfigurationProviderImpl.getAccessorType(string);
        for (int i = 0; i < EDITABLE_ACCESSOR_TYPES.length; ++i) {
            if (!string2.equals(EDITABLE_ACCESSOR_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    private Map getAccessorProperties(String string) throws UnknownLogTypeException {
        String[] stringArray = string.split("/");
        String string2 = stringArray[0];
        Map map = null;
        boolean bl = false;
        boolean bl2 = AccessorUtils.isAdminServer();
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Admin server = " + bl2);
        }
        if (string2.equals("ServerLog")) {
            map = AccessorUtils.getParamsForServerLog();
        } else if (string2.equals("DomainLog") && bl2) {
            map = AccessorUtils.getParamsForDomainLog();
        } else if (string2.equals("HarvestedDataArchive")) {
            map = AccessorUtils.getParamsForDiagnosticDataArchive();
        } else if (string2.equals("EventsDataArchive")) {
            map = AccessorUtils.getParamsForDiagnosticDataArchive();
        } else if (string2.equals("DataSourceLog")) {
            map = AccessorUtils.getParamsForDataSourceLog();
        } else if (string2.equals("HTTPAccessLog")) {
            map = AccessorUtils.getParamsForHTTPAccessLog(stringArray);
        } else if (string2.equals("WebAppLog")) {
            map = AccessorUtils.getParamsForWebAppLog(stringArray);
        } else if (string2.equals("ConnectorLog")) {
            map = AccessorUtils.getParamsForConnectorLog(string);
        } else if (string2.equals("JMSMessageLog")) {
            map = AccessorUtils.getParamsForJMSMessageLog(string);
        } else if (string2.equals("JMSSAFMessageLog")) {
            map = AccessorUtils.getParamsForJMSSAFMessageLog(string);
        } else if (string2.equals("CUSTOM")) {
            bl = true;
            map = AccessorUtils.getParamsForGenericDataArchive();
        } else {
            Loggable loggable = DiagnosticsLogger.logUnknownLogTypeLoggable((String)string2);
            throw new UnknownLogTypeException(loggable.getMessageBody());
        }
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Config parameters for accessor " + string + ":" + this.getConfigurationParamString(map));
        }
        return map;
    }

    private String getConfigurationParamString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object k : map.keySet()) {
            Object v = map.get(k);
            stringBuffer.append("\n   " + k + "=" + v);
        }
        return stringBuffer.toString();
    }

    private static class EditableAccessorConfigurationImpl
    extends AccessorConfigurationImpl
    implements EditableAccessorConfiguration {
        EditableAccessorConfigurationImpl(String string, Map map) {
            super(string, map);
        }

        private WLDFDataRetirementByAgeMBean lookupWLDFDataRetirementByAge() {
            WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = WLSAccessorConfigurationProviderImpl.getWLDFConfiguration();
            String string = this.getName();
            WLDFDataRetirementByAgeMBean[] wLDFDataRetirementByAgeMBeanArray = wLDFServerDiagnosticMBean.getWLDFDataRetirementByAges();
            int n = wLDFDataRetirementByAgeMBeanArray != null ? wLDFDataRetirementByAgeMBeanArray.length : 0;
            for (int i = 0; i < n; ++i) {
                WLDFDataRetirementByAgeMBean wLDFDataRetirementByAgeMBean = wLDFDataRetirementByAgeMBeanArray[i];
                if (!string.equals(wLDFDataRetirementByAgeMBean.getArchiveName())) continue;
                return wLDFDataRetirementByAgeMBean;
            }
            return null;
        }

        public int getRetirementAge() {
            WLDFDataRetirementByAgeMBean wLDFDataRetirementByAgeMBean = this.lookupWLDFDataRetirementByAge();
            if (wLDFDataRetirementByAgeMBean != null) {
                return wLDFDataRetirementByAgeMBean.getRetirementAge();
            }
            return 72;
        }

        public int getRetirementPeriod() {
            WLDFDataRetirementByAgeMBean wLDFDataRetirementByAgeMBean = this.lookupWLDFDataRetirementByAge();
            if (wLDFDataRetirementByAgeMBean != null) {
                return wLDFDataRetirementByAgeMBean.getRetirementPeriod();
            }
            return 24;
        }

        public int getRetirementTime() {
            WLDFDataRetirementByAgeMBean wLDFDataRetirementByAgeMBean = this.lookupWLDFDataRetirementByAge();
            if (wLDFDataRetirementByAgeMBean != null) {
                return wLDFDataRetirementByAgeMBean.getRetirementTime();
            }
            return 0;
        }

        public boolean isAgeBasedDataRetirementEnabled() {
            WLDFDataRetirementByAgeMBean wLDFDataRetirementByAgeMBean = this.lookupWLDFDataRetirementByAge();
            return wLDFDataRetirementByAgeMBean != null && wLDFDataRetirementByAgeMBean.isEnabled();
        }

        public boolean isParticipantInSizeBasedDataRetirement() {
            WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = WLSAccessorConfigurationProviderImpl.getWLDFConfiguration();
            String string = wLDFServerDiagnosticMBean.getDiagnosticDataArchiveType();
            if ("FileStoreArchive".equals(string)) {
                for (int i = 0; i < SIZE_BASED_RETIREMENT_PARTICIPANTS.length; ++i) {
                    if (!SIZE_BASED_RETIREMENT_PARTICIPANTS[i].equals(this.getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class LogAccessorConfigurationImpl
    extends AccessorConfigurationImpl
    implements LogAccessorConfiguration {
        private String logFile;
        private String rotationDir;

        LogAccessorConfigurationImpl(String string, Map map) {
            super(string, map);
            this.logFile = (String)map.get("logFilePath");
            this.rotationDir = (String)map.get("logRotationDir");
        }

        public LogRecordParser getRecordParser() {
            return null;
        }

        public String getLogFilePath() {
            return this.logFile;
        }

        public String getLogFileRotationDirectory() {
            return this.rotationDir;
        }
    }

    private static class AccessorConfigurationImpl
    implements AccessorConfiguration {
        private String accessorName;
        private Map params;
        private boolean isModifiable;

        AccessorConfigurationImpl(String string, Map map) {
            this.accessorName = string;
            this.params = map;
            String string2 = WLSAccessorConfigurationProviderImpl.getAccessorType(string);
            if (string2.equals("WebAppLog")) {
                this.isModifiable = true;
            } else if (string2.equals("ConnectorLog")) {
                this.isModifiable = true;
            } else if (string2.equals("JMSMessageLog") || string2.equals("JMSSAFMessageLog")) {
                this.isModifiable = true;
            }
        }

        public String getName() {
            return this.accessorName;
        }

        public boolean isModifiableConfiguration() {
            return this.isModifiable;
        }

        public ColumnInfo[] getColumns() {
            return null;
        }

        public Map getAccessorParameters() {
            return this.params;
        }
    }
}

