/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.accessor;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.connector.external.RAUtil;
import weblogic.diagnostics.accessor.AccessorConfigurationProvider;
import weblogic.diagnostics.accessor.AccessorConstants;
import weblogic.diagnostics.accessor.AccessorMBeanFactory;
import weblogic.diagnostics.accessor.AccessorSecurityProvider;
import weblogic.diagnostics.accessor.AccessorUtils;
import weblogic.diagnostics.accessor.ColumnInfo;
import weblogic.diagnostics.accessor.DataAccessRuntime;
import weblogic.diagnostics.accessor.DataAccessServiceCreateException;
import weblogic.diagnostics.accessor.DiagnosticAccessRuntime;
import weblogic.diagnostics.accessor.DiagnosticDataAccessRuntime;
import weblogic.diagnostics.accessor.DiagnosticDataAccessService;
import weblogic.diagnostics.accessor.DiagnosticDataAccessServiceFactory;
import weblogic.diagnostics.accessor.UnknownLogTypeException;
import weblogic.diagnostics.accessor.runtime.AccessRuntimeMBean;
import weblogic.diagnostics.accessor.runtime.ArchiveRuntimeMBean;
import weblogic.diagnostics.accessor.runtime.DataAccessRuntimeMBean;
import weblogic.diagnostics.accessor.runtime.DataRetirementTaskRuntimeMBean;
import weblogic.diagnostics.archive.DiagnosticArchiveRuntime;
import weblogic.diagnostics.archive.EditableDataArchive;
import weblogic.diagnostics.archive.WLDFDataRetirementByAgeTaskImpl;
import weblogic.diagnostics.archive.WLDFDiagnosticDbstoreArchiveRuntime;
import weblogic.diagnostics.archive.WLDFDiagnosticFileArchiveRuntime;
import weblogic.diagnostics.archive.WLDFDiagnosticWlstoreArchiveRuntime;
import weblogic.diagnostics.archive.dbstore.JdbcDataArchive;
import weblogic.diagnostics.archive.filestore.FileDataArchive;
import weblogic.diagnostics.archive.wlstore.PersistentStoreDataArchive;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.WLDFAccessRuntimeMBean;
import weblogic.management.runtime.WLDFArchiveRuntimeMBean;
import weblogic.management.runtime.WLDFDataAccessRuntimeMBean;
import weblogic.management.runtime.WLDFRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.servlet.utils.ServletAccessorHelper;

public class WLSAccessorMBeanFactoryImpl
implements AccessorMBeanFactory,
AccessorConstants {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticAccessor");
    private static AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);

    public String[] getAvailableDiagnosticDataAccessorNames() throws ManagementException {
        String[] stringArray2;
        Set set;
        Object object2;
        AccessorUtils.ensureUserAuthorized();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("ServerLog");
        if (runtimeAccess.isAdminServer()) {
            hashSet.add("DomainLog");
        }
        hashSet.add("HarvestedDataArchive");
        hashSet.add("EventsDataArchive");
        hashSet.add("HTTPAccessLog");
        hashSet.add("DataSourceLog");
        for (Object object2 : AccessorUtils.getAvailableVirtualHosts()) {
            hashSet.add("HTTPAccessLog/" + object2.getName());
        }
        object2 = this.getLogicalNamesForAvailableWebAppLogs();
        if (object2.size() > 0) {
            hashSet.addAll((Collection<String>)object2);
        }
        if ((set = RAUtil.getAvailableConnectorLogNames()).size() > 0) {
            hashSet.addAll(set);
        }
        for (Object object3 : AccessorUtils.getAvailableJMSServers()) {
            hashSet.add("JMSMessageLog/" + object3.getName());
        }
        for (Object object4 : AccessorUtils.getAvailableSAFAgents()) {
            hashSet.add("JMSSAFMessageLog/" + object4.getName());
        }
        for (String[] stringArray2 : AccessorUtils.getAvailableCustomArchives()) {
            hashSet.add(stringArray2.getName());
        }
        stringArray2 = new String[hashSet.size()];
        hashSet.toArray(stringArray2);
        return stringArray2;
    }

    private Set getLogicalNamesForAvailableWebAppLogs() {
        HashSet hashSet = new HashSet();
        Set set = AccessorUtils.getAvailableVirtualHosts();
        set.add(runtimeAccess.getServer().getWebServer());
        for (WebServerMBean webServerMBean : set) {
            Set set2 = ServletAccessorHelper.getLogicalNamesForWebApps(webServerMBean);
            if (set2.isEmpty()) continue;
            hashSet.addAll(set2);
        }
        return hashSet;
    }

    public AccessRuntimeMBean createDiagnosticAccessRuntime(AccessorConfigurationProvider accessorConfigurationProvider, AccessorSecurityProvider accessorSecurityProvider, RuntimeMBean runtimeMBean) throws ManagementException {
        return new DiagnosticAccessRuntime(this, accessorConfigurationProvider, accessorSecurityProvider, runtimeMBean);
    }

    public DataAccessRuntimeMBean createDiagnosticDataAccessRuntime(final String string, final ColumnInfo[] columnInfoArray, final AccessRuntimeMBean accessRuntimeMBean) throws ManagementException {
        try {
            WLDFDataAccessRuntimeMBean wLDFDataAccessRuntimeMBean = (WLDFDataAccessRuntimeMBean)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WLSAccessorMBeanFactoryImpl.this.createDataAccessRuntime(string, columnInfoArray, (WLDFAccessRuntimeMBean)accessRuntimeMBean);
                }
            });
            return wLDFDataAccessRuntimeMBean;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ManagementException(privilegedActionException.getCause() == null ? privilegedActionException : privilegedActionException.getCause());
        }
    }

    private WLDFDataAccessRuntimeMBean createDataAccessRuntime(String string, ColumnInfo[] columnInfoArray, WLDFAccessRuntimeMBean wLDFAccessRuntimeMBean) throws ManagementException {
        try {
            DataAccessRuntime.DiagnosticDataAccessServiceStruct diagnosticDataAccessServiceStruct = DataAccessRuntime.createDiagnosticDataAccessService((String)string, (ColumnInfo[])columnInfoArray);
            DiagnosticDataAccessService diagnosticDataAccessService = diagnosticDataAccessServiceStruct.getDiagnosticDataAccessService();
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Creating DiagnosticDataAccessRuntime with Name=" + string);
            }
            DiagnosticDataAccessRuntime diagnosticDataAccessRuntime = new DiagnosticDataAccessRuntime(string, wLDFAccessRuntimeMBean, diagnosticDataAccessService);
            diagnosticDataAccessRuntime.setDataArchiveParameters(diagnosticDataAccessServiceStruct.getCreateParams());
            return diagnosticDataAccessRuntime;
        }
        catch (Exception exception) {
            Loggable loggable = DiagnosticsLogger.logErrorCreatingDiagnosticDataRuntimeLoggable((String)string, (Throwable)exception);
            loggable.log();
            throw new ManagementException(loggable.getMessageBody());
        }
    }

    public DiagnosticDataAccessService createDiagnosticDataAccessService(String string, String string2, ColumnInfo[] columnInfoArray, Map map) throws UnknownLogTypeException, DataAccessServiceCreateException {
        if (!string2.equals("CUSTOM")) {
            columnInfoArray = null;
        }
        DiagnosticDataAccessService diagnosticDataAccessService = DiagnosticDataAccessServiceFactory.createDiagnosticDataAccessService(string, string2, columnInfoArray, map);
        return diagnosticDataAccessService;
    }

    public ArchiveRuntimeMBean createDiagnosticArchiveRuntime(DiagnosticDataAccessService diagnosticDataAccessService) throws ManagementException {
        WLDFRuntimeMBean wLDFRuntimeMBean = runtimeAccess.getServerRuntime().getWLDFRuntime();
        WLDFArchiveRuntimeMBean wLDFArchiveRuntimeMBean = null;
        if (diagnosticDataAccessService instanceof FileDataArchive) {
            wLDFArchiveRuntimeMBean = new WLDFDiagnosticFileArchiveRuntime((FileDataArchive)diagnosticDataAccessService, wLDFRuntimeMBean);
        } else if (diagnosticDataAccessService instanceof JdbcDataArchive) {
            wLDFArchiveRuntimeMBean = new WLDFDiagnosticDbstoreArchiveRuntime((JdbcDataArchive)diagnosticDataAccessService, wLDFRuntimeMBean);
        } else if (diagnosticDataAccessService instanceof PersistentStoreDataArchive) {
            wLDFArchiveRuntimeMBean = new WLDFDiagnosticWlstoreArchiveRuntime((PersistentStoreDataArchive)diagnosticDataAccessService, wLDFRuntimeMBean);
        } else {
            throw new ManagementException("Unknown archive type: " + diagnosticDataAccessService);
        }
        wLDFRuntimeMBean.addWLDFArchiveRuntime(wLDFArchiveRuntimeMBean);
        return wLDFArchiveRuntimeMBean;
    }

    public void destroyDiagnosticArchiveRuntime(ArchiveRuntimeMBean archiveRuntimeMBean) throws ManagementException {
        Object object;
        if (archiveRuntimeMBean instanceof WLDFArchiveRuntimeMBean) {
            object = runtimeAccess.getServerRuntime().getWLDFRuntime();
            object.removeWLDFArchiveRuntime((WLDFArchiveRuntimeMBean)archiveRuntimeMBean);
        }
        object = (DiagnosticArchiveRuntime)archiveRuntimeMBean;
        object.unregister();
    }

    public DataRetirementTaskRuntimeMBean createRetirementByAgeTask(DiagnosticDataAccessService diagnosticDataAccessService, long l) throws ManagementException {
        WLDFDataRetirementByAgeTaskImpl wLDFDataRetirementByAgeTaskImpl = null;
        if (!(diagnosticDataAccessService instanceof EditableDataArchive)) {
            throw new ManagementException("Can not create retirement task for non-editable archive " + diagnosticDataAccessService.getName());
        }
        wLDFDataRetirementByAgeTaskImpl = new WLDFDataRetirementByAgeTaskImpl((EditableDataArchive)diagnosticDataAccessService, l);
        return wLDFDataRetirementByAgeTaskImpl;
    }
}

