/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.accessor;

import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.diagnostics.accessor.ColumnInfo;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.utils.PlatformConstants;
import weblogic.xml.stax.XMLStreamOutputFactory;

public final class XMLDataWriter {
    private static final XMLOutputFactory xmlOutputFactory = XMLStreamOutputFactory.newInstance();
    private static final String DIAG_DATA = "DiagnosticData";
    private static final String DATA_INFO = "DataInfo";
    private static final String COLUMN_INFO = "ColumnInfo";
    private static final String COL_NAME = "Name";
    private static final String COL_TYPE = "Type";
    private static final String DATA_REC = "DataRecord";
    private static final String COL_DATA = "ColumnData";
    private static final String INDENT = "  ";
    static final String EXPORT_SCHEMA_NAME_SPACE = "http://www.bea.com/ns/weblogic/90/diagnostics/accessor/Export";
    static final String EXPORT_SCHEMA_URL = "http://www.bea.com/ns/weblogic/90/diagnostics/accessor/export.xsd export.xsd";
    private XMLStreamWriter writer;
    private boolean autoFlush;

    public XMLDataWriter(OutputStream outputStream) throws XMLStreamException {
        this(outputStream, true);
    }

    public XMLDataWriter(OutputStream outputStream, boolean bl) throws XMLStreamException {
        this.writer = xmlOutputFactory.createXMLStreamWriter(outputStream, "UTF-8");
        this.autoFlush = bl;
    }

    public void exportDiagnosticDataToXML(ColumnInfo[] columnInfoArray, Iterator iterator) throws XMLStreamException {
        this.writer.writeStartDocument();
        this.writer.writeCharacters(PlatformConstants.EOL);
        this.writer.writeStartElement(DIAG_DATA);
        this.writer.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.writer.writeAttribute("xsi:schemaLocation", EXPORT_SCHEMA_URL);
        this.writer.writeAttribute("xmlns", EXPORT_SCHEMA_NAME_SPACE);
        this.writer.writeCharacters(PlatformConstants.EOL);
        this.writeColumnInfo(columnInfoArray);
        this.writeData(columnInfoArray.length, iterator);
        this.writer.writeEndElement();
        this.writer.writeCharacters(PlatformConstants.EOL);
        this.writer.writeEndDocument();
        if (this.autoFlush) {
            this.writer.flush();
        }
        this.writer.close();
    }

    private void writeColumnInfo(ColumnInfo[] columnInfoArray) throws XMLStreamException {
        if (columnInfoArray == null) {
            return;
        }
        this.writer.writeCharacters(INDENT);
        this.writer.writeStartElement(DATA_INFO);
        this.writer.writeCharacters(PlatformConstants.EOL);
        for (int i = 0; i < columnInfoArray.length; ++i) {
            ColumnInfo columnInfo = columnInfoArray[i];
            this.writer.writeCharacters("    ");
            this.writer.writeStartElement(COLUMN_INFO);
            this.writeElement(COL_NAME, columnInfo.getColumnName());
            this.writeElement(COL_TYPE, columnInfo.getColumnTypeName());
            this.writer.writeEndElement();
            this.writer.writeCharacters(PlatformConstants.EOL);
            if (!this.autoFlush) continue;
            this.writer.flush();
        }
        this.writer.writeCharacters(INDENT);
        this.writer.writeEndElement();
        this.writer.writeCharacters(PlatformConstants.EOL);
    }

    private void writeData(int n, Iterator iterator) throws XMLStreamException {
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            this.writer.writeCharacters(INDENT);
            this.writer.writeStartElement(DATA_REC);
            DataRecord dataRecord = (DataRecord)iterator.next();
            for (int i = 0; i < n; ++i) {
                this.writer.writeStartElement(COL_DATA);
                Object object = dataRecord.get(i);
                this.writer.writeCharacters(object == null ? "" : object.toString());
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeCharacters(PlatformConstants.EOL);
            if (!this.autoFlush) continue;
            this.writer.flush();
        }
    }

    private void writeElement(String string, String string2) throws XMLStreamException {
        this.writer.writeStartElement(string);
        this.writer.writeCharacters(string2);
        this.writer.writeEndElement();
    }
}

