/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.accessor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import weblogic.diagnostics.accessor.AccessorConstants;
import weblogic.diagnostics.accessor.ColumnInfo;
import weblogic.diagnostics.accessor.DataAccessServiceCreateException;
import weblogic.diagnostics.accessor.DiagnosticDataAccessException;
import weblogic.diagnostics.accessor.DiagnosticDataAccessService;
import weblogic.diagnostics.accessor.DiagnosticDataAccessServiceFactory;
import weblogic.diagnostics.accessor.UnknownLogTypeException;
import weblogic.diagnostics.accessor.XMLDataWriter;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.query.QueryException;

public final class XMLExporter
implements AccessorConstants {
    private static final DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticAccessor");
    private static final String SEP = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportDiagnosticData(String string, String string2, String string3, String string4, String string5, String string6, String string7, long l, long l2) throws DiagnosticDataAccessException {
        String[] stringArray = string.split(SEP);
        String string8 = stringArray[0];
        debugLogger.debug("LogType = " + string8);
        debugLogger.debug("LogName = " + string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string8.equals("ServerLog") || string8.equals("DomainLog") || string8.equals("HTTPAccessLog") || string8.equals("WebAppLog") || string8.equals("ConnectorLog") || string8.equals("JMSMessageLog") || string8.equals("JMSSAFMessageLog")) {
            hashMap.put("logFilePath", string2);
            hashMap.put("logRotationDir", string3);
        }
        hashMap.put("storeDir", string4);
        if (string7 != null && string7.length() > 0) {
            hashMap.put("elfFields", string7);
        }
        DiagnosticDataAccessService diagnosticDataAccessService = null;
        try {
            diagnosticDataAccessService = DiagnosticDataAccessServiceFactory.createDiagnosticDataAccessService(string, string8, hashMap);
        }
        catch (UnknownLogTypeException unknownLogTypeException) {
            throw new DiagnosticDataAccessException((Throwable)unknownLogTypeException);
        }
        catch (DataAccessServiceCreateException dataAccessServiceCreateException) {
            throw new DiagnosticDataAccessException((Throwable)dataAccessServiceCreateException);
        }
        try {
            Object object;
            ColumnInfo[] columnInfoArray = diagnosticDataAccessService.getColumns();
            Iterator iterator = null;
            try {
                iterator = diagnosticDataAccessService.getDataRecords(l, l2, string5);
            }
            catch (QueryException queryException) {
                throw new DiagnosticDataAccessException((Throwable)queryException);
            }
            FileOutputStream fileOutputStream = null;
            try {
                object = new File(string6);
                fileOutputStream = new FileOutputStream(((File)object).getCanonicalFile());
            }
            catch (IOException iOException) {
                throw new DiagnosticDataAccessException((Throwable)iOException);
            }
            try {
                object = new XMLDataWriter(fileOutputStream);
                ((XMLDataWriter)object).exportDiagnosticDataToXML(columnInfoArray, iterator);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new DiagnosticDataAccessException((Throwable)xMLStreamException);
            }
        }
        finally {
            block20: {
                try {
                    if (diagnosticDataAccessService != null) {
                        diagnosticDataAccessService.close();
                    }
                }
                catch (Exception exception) {
                    if (!debugLogger.isDebugEnabled()) break block20;
                    exception.printStackTrace();
                }
            }
        }
    }
}

