/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.archive.dbstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import javax.naming.NamingException;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.archive.DataWriter;
import weblogic.diagnostics.archive.dbstore.JdbcDataArchive;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.management.ManagementException;

public class EventsJdbcDataArchive
extends JdbcDataArchive
implements DataWriter {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticArchive");

    public EventsJdbcDataArchive(String string, String string2) throws NamingException, ManagementException, SQLException {
        this(string, string2, null, null, null);
    }

    public EventsJdbcDataArchive(String string, String string2, String string3, String string4, String string5) throws NamingException, ManagementException, SQLException {
        super(string, string2, "WLS_EVENTS", ArchiveConstants.getColumns(1), string3, string4, string5);
    }

    public String getDescription() {
        return "Diagnostic Events";
    }

    protected DataRecord getDataRecord(ResultSet resultSet) throws SQLException {
        int n = ArchiveConstants.EVENTS_ARCHIVE_COLUMNS_COUNT;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        objectArray[n2] = new Long(resultSet.getLong(n2 + 1));
        objectArray[++n2] = new Long(resultSet.getLong(n2 + 1));
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = new Integer(resultSet.getInt(n2 + 1));
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = this.getPayloadObject(resultSet.getBytes(n2 + 1));
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = new Long(resultSet.getLong(n2 + 1));
        objectArray[++n2] = resultSet.getString(n2 + 1);
        ++n2;
        return new DataRecord(objectArray);
    }

    protected void insertDataRecord(PreparedStatement preparedStatement, Object object) throws SQLException {
        DataRecord dataRecord = (DataRecord)object;
        int n = 1;
        preparedStatement.setLong(n, (Long)dataRecord.get(n));
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setInt(++n, (Integer)dataRecord.get(n));
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setBytes(++n, this.getPayloadBytes(dataRecord.get(n)));
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setLong(++n, (Long)dataRecord.get(n));
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        ++n;
        preparedStatement.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPayloadBytes(Object object) {
        byte[] byArray = new byte[]{};
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            UnexpectedExceptionHandler.handle("Could not persist payload", exception);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPayloadObject(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            if (byArray != null && byArray.length > 0) {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
        }
        catch (Exception exception) {
            UnexpectedExceptionHandler.handle("Could not reconstruct payload", exception);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return object;
    }

    public static void main(String[] stringArray) throws Exception {
        EventsJdbcDataArchive eventsJdbcDataArchive = new EventsJdbcDataArchive("EventsDataArchive", stringArray[0]);
        String string = stringArray.length > 1 ? stringArray[1] : null;
        int n = 0;
        long l = System.currentTimeMillis();
        Iterator iterator = eventsJdbcDataArchive.getDataRecords(string);
        while (iterator.hasNext()) {
            DataRecord dataRecord = (DataRecord)iterator.next();
            ++n;
            System.out.println(dataRecord.toString());
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Found " + n + " record(s) in " + (l2 - l) + " ms");
    }
}

