/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.archive.dbstore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import javax.naming.NamingException;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.archive.DataWriter;
import weblogic.diagnostics.archive.dbstore.JdbcDataArchive;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;

public class HarvestedJdbcDataArchive
extends JdbcDataArchive
implements DataWriter {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticArchive");

    public HarvestedJdbcDataArchive(String string, String string2) throws NamingException, ManagementException, SQLException {
        this(string, string2, null, null, null);
    }

    public HarvestedJdbcDataArchive(String string, String string2, String string3, String string4, String string5) throws NamingException, ManagementException, SQLException {
        super(string, string2, "WLS_HVST", ArchiveConstants.getColumns(2), string3, string4, string5);
    }

    public String getDescription() {
        return "Harvested diagnostic data";
    }

    protected DataRecord getDataRecord(ResultSet resultSet) throws SQLException {
        int n = ArchiveConstants.HARVESTER_ARCHIVE_COLUMNS_COUNT;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        objectArray[n2] = new Long(resultSet.getLong(n2 + 1));
        objectArray[++n2] = new Long(resultSet.getLong(n2 + 1));
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = resultSet.getString(n2 + 1);
        objectArray[++n2] = new Integer(resultSet.getString(n2 + 1));
        objectArray[++n2] = resultSet.getString(n2 + 1);
        ++n2;
        return new DataRecord(objectArray);
    }

    protected void insertDataRecord(PreparedStatement preparedStatement, Object object) throws SQLException {
        DataRecord dataRecord = (DataRecord)object;
        int n = 1;
        preparedStatement.setLong(n, (Long)dataRecord.get(n));
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        preparedStatement.setInt(++n, (Integer)dataRecord.get(n));
        preparedStatement.setString(++n, dataRecord.get(n).toString());
        ++n;
        preparedStatement.executeUpdate();
    }

    public static void main(String[] stringArray) throws Exception {
        HarvestedJdbcDataArchive harvestedJdbcDataArchive = new HarvestedJdbcDataArchive("HarvestedDataArchive", stringArray[0]);
        String string = stringArray.length > 1 ? stringArray[1] : null;
        int n = 0;
        long l = System.currentTimeMillis();
        Iterator iterator = harvestedJdbcDataArchive.getDataRecords(string);
        while (iterator.hasNext()) {
            DataRecord dataRecord = (DataRecord)iterator.next();
            ++n;
            System.out.println(dataRecord.toString());
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Found " + n + " record(s) in " + (l2 - l) + " ms");
    }
}

