/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.archive.filestore;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import weblogic.diagnostics.accessor.ColumnInfo;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.archive.filestore.AccessLogRecordParser;
import weblogic.diagnostics.archive.filestore.FileDataArchive;
import weblogic.diagnostics.archive.filestore.RecordParser;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;

public final class AccessLogFileDataArchive
extends FileDataArchive {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticArchive");
    private int timestampColumnIndex = 4;
    private static final byte[] RECORD_MARKER = "".getBytes();

    public AccessLogFileDataArchive(String string, File file, File file2, File file3, String string2, ColumnInfo[] columnInfoArray, int n, int n2, boolean bl) throws IOException, ManagementException {
        super(string, columnInfoArray, file, file2, file3, (RecordParser)new AccessLogRecordParser(string2, n2), RECORD_MARKER, true, bl);
        this.timestampColumnIndex = n2;
    }

    public AccessLogFileDataArchive(String string, File file, File file2, File file3, String string2, ColumnInfo[] columnInfoArray, int n, boolean bl) throws IOException, ManagementException {
        this(string, file, file2, file3, string2, columnInfoArray, -1, n, bl);
    }

    public AccessLogFileDataArchive(String string, File file, File file2, File file3, String string2, boolean bl) throws IOException, ManagementException {
        this(string, file, file2, file3, string2, ArchiveConstants.getColumns(4), 4, bl);
    }

    public AccessLogFileDataArchive(String string, File file, File file2, File file3, boolean bl) throws IOException, ManagementException {
        this(string, file, file2, file3, "dd/MMM/yyyy:HH:mm:ss Z", bl);
    }

    public AccessLogFileDataArchive(String string, File file, File file2, File file3, String[] stringArray, boolean bl) throws IOException, ManagementException {
        super(string, AccessLogFileDataArchive.getCols(stringArray), file, file2, file3, (RecordParser)new AccessLogRecordParser(), RECORD_MARKER, false, bl);
    }

    private static ColumnInfo[] getCols(String[] stringArray) {
        int n = (stringArray != null ? stringArray.length : 0) + 1;
        ColumnInfo[] columnInfoArray = new ColumnInfo[n];
        columnInfoArray[0] = new ColumnInfo("RECORDID", 2);
        for (int i = 1; i < n; ++i) {
            columnInfoArray[i] = new ColumnInfo(stringArray[i - 1], 5);
        }
        return columnInfoArray;
    }

    public String getDescription() {
        return "HTTP Access Log";
    }

    private static void usage() {
        System.out.println("java [-Dverbose=true] " + AccessLogFileDataArchive.class.getName() + " logFile indexStoreDirectory lowTimestamp highTimestamp dateDormat [queryString]");
        System.out.println("For example:");
        System.out.println("java [-Dverbose=true] " + AccessLogFileDataArchive.class.getName() + " c:/mydomain/myserver/access.log" + " c:/mydomain/servers/myserver/data/store/diagnostics 0 99999999999999" + " \"dd/MMM/yyyy:HH:mm:ss Z\"" + " \"STATUS = 200\"");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 5) {
            AccessLogFileDataArchive.usage();
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        long l = Long.parseLong(stringArray[2]);
        long l2 = Long.parseLong(stringArray[3]);
        String string = stringArray[4];
        String string2 = stringArray.length > 5 ? stringArray[5] : null;
        boolean bl = Boolean.getBoolean("verbose");
        AccessLogFileDataArchive accessLogFileDataArchive = new AccessLogFileDataArchive("HTTPAccessLog", file, file.getParentFile(), file2, string, true);
        int n = 0;
        long l3 = System.currentTimeMillis();
        Iterator iterator = accessLogFileDataArchive.getDataRecords(l, l2, string2);
        while (iterator.hasNext()) {
            DataRecord dataRecord = (DataRecord)iterator.next();
            ++n;
            if (!bl) continue;
            System.out.println(dataRecord.toString());
        }
        long l4 = System.currentTimeMillis();
        System.out.println("Found " + n + " record(s) in " + (l4 - l3) + " ms");
        accessLogFileDataArchive.close();
    }
}

