/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.archive.filestore;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.filestore.AccessLogFileParser;
import weblogic.diagnostics.archive.filestore.AccessLogLexer;
import weblogic.diagnostics.archive.filestore.RecordParser;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;

final class AccessLogRecordParser
implements RecordParser {
    private int timestampColumnIndex;
    private String dateFormatString;

    AccessLogRecordParser() {
    }

    AccessLogRecordParser(String string, int n) {
        this.timestampColumnIndex = n;
        this.dateFormatString = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRecord parseRecord(byte[] byArray, int n, int n2) {
        DataRecord dataRecord = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray, n, n2));
            AccessLogLexer accessLogLexer = new AccessLogLexer(inputStreamReader);
            AccessLogFileParser accessLogFileParser = new AccessLogFileParser(accessLogLexer);
            dataRecord = accessLogFileParser.getNextAccessLogEntry();
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {
                    UnexpectedExceptionHandler.handle("Could not close stream", exception);
                }
            }
        }
        return dataRecord;
    }

    public long getTimestamp(DataRecord dataRecord) {
        long l = 0L;
        if (dataRecord == null || this.dateFormatString == null) {
            return 0L;
        }
        try {
            ParsePosition parsePosition = new ParsePosition(0);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.dateFormatString);
            String string = dataRecord.get(this.timestampColumnIndex).toString();
            Date date = simpleDateFormat.parse(string, parsePosition);
            if (date != null) {
                l = date.getTime();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return l;
    }
}

