/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.archive.filestore;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.archive.filestore.DataSourceLogRecordParser;
import weblogic.diagnostics.archive.filestore.FileDataArchive;
import weblogic.diagnostics.archive.filestore.RecordParser;
import weblogic.management.ManagementException;

public class DataSourceLogFileDataArchive
extends FileDataArchive {
    private static final byte[] RECORD_MARKER = "####".getBytes();
    private static final RecordParser RECORD_PARSER = new DataSourceLogRecordParser();

    public DataSourceLogFileDataArchive(String string, File file, File file2, File file3, boolean bl) throws IOException, ManagementException {
        super(string, ArchiveConstants.getColumns(7), file, file2, file3, RECORD_PARSER, RECORD_MARKER, true, bl);
    }

    public DataSourceLogFileDataArchive(String string, File file, File file2, boolean bl) throws IOException, ManagementException {
        this(string, file, file.getParentFile(), file2, bl);
    }

    public String getDescription() {
        return "DATASOURCE Log";
    }

    private static void usage() {
        System.out.println("java [-Dverbose=true] " + DataSourceLogFileDataArchive.class.getName() + " logFile indexStoreDirectory lowTimestamp highTimestamp [queryString]");
        System.out.println("For example:");
        System.out.println("java [-Dverbose=true] " + DataSourceLogFileDataArchive.class.getName() + " c:/mydomain/myserver/datasource.log" + " c:/mydomain/servers/myserver/data/store/diagnostics 0 99999999999999" + " \"DESTINATION = 'myDestonation'\"");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 4) {
            DataSourceLogFileDataArchive.usage();
            return;
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        DataSourceLogFileDataArchive dataSourceLogFileDataArchive = new DataSourceLogFileDataArchive("DataSourceLog", file, file2, true);
        long l = Long.parseLong(stringArray[2]);
        long l2 = Long.parseLong(stringArray[3]);
        String string = stringArray.length > 4 ? stringArray[4] : null;
        boolean bl = Boolean.getBoolean("verbose");
        int n = 0;
        long l3 = System.currentTimeMillis();
        Iterator iterator = dataSourceLogFileDataArchive.getDataRecords(l, l2, string);
        while (iterator.hasNext()) {
            DataRecord dataRecord = (DataRecord)iterator.next();
            ++n;
            if (!bl) continue;
            System.out.println(dataRecord.toString());
        }
        long l4 = System.currentTimeMillis();
        System.out.println("Found " + n + " record(s) in " + (l4 - l3) + " ms");
        dataSourceLogFileDataArchive.close();
    }
}

