/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.archive.filestore;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.archive.filestore.FileDataArchive;
import weblogic.diagnostics.archive.filestore.RecordParser;
import weblogic.diagnostics.archive.filestore.ServerLogRecordParser;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;

public class ServerLogFileDataArchive
extends FileDataArchive {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticArchive");
    private static final byte[] RECORD_MARKER = "####".getBytes();
    private static final RecordParser RECORD_PARSER = new ServerLogRecordParser();

    public ServerLogFileDataArchive(String string, File file, File file2, File file3, boolean bl) throws IOException, ManagementException {
        super(string, ArchiveConstants.getColumns(3), file, file2, file3, RECORD_PARSER, RECORD_MARKER, true, bl);
    }

    public ServerLogFileDataArchive(String string, File file, File file2, boolean bl) throws IOException, ManagementException {
        this(string, file, file.getParentFile(), file2, bl);
    }

    public String getDescription() {
        return "Server Log";
    }

    private static void usage() {
        System.out.println("java [-Dverbose=true] " + ServerLogFileDataArchive.class.getName() + " logFile indexStoreDirectory lowTimestamp highTimestamp [queryString]");
        System.out.println("For example:");
        System.out.println("java [-Dverbose=true] " + ServerLogFileDataArchive.class.getName() + " c:/mydomain/myserver/myserver.log" + " c:/mydomain/servers/myserver/data/store/diagnostics 0 99999999999999" + " \"SUBSYSTEM LIKE '%Diagnostics%'\"");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 4) {
            ServerLogFileDataArchive.usage();
            return;
        }
        boolean bl = Boolean.getBoolean("verbose");
        boolean bl2 = Boolean.getBoolean("buildIndex");
        boolean bl3 = Boolean.getBoolean("byID");
        boolean bl4 = Boolean.getBoolean("printIndex");
        System.setProperty("_Offline_FileDataArchive", "true");
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        ServerLogFileDataArchive serverLogFileDataArchive = new ServerLogFileDataArchive("ServerLog", file, file2, !bl2);
        long l = Long.parseLong(stringArray[2]);
        long l2 = Long.parseLong(stringArray[3]);
        String string = stringArray.length > 4 ? stringArray[4] : null;
        int n = 0;
        long l3 = System.currentTimeMillis();
        Iterator iterator = bl3 ? serverLogFileDataArchive.getDataRecords(l, l2, Long.MAX_VALUE, string) : serverLogFileDataArchive.getDataRecords(l, l2, string);
        while (iterator.hasNext()) {
            DataRecord dataRecord = (DataRecord)iterator.next();
            ++n;
            if (!bl) continue;
            System.out.println(dataRecord.toString());
        }
        long l4 = System.currentTimeMillis();
        System.out.println("Found " + n + " record(s) in " + (l4 - l3) + " ms");
        if (bl4) {
            serverLogFileDataArchive.printIndex();
        }
        serverLogFileDataArchive.close();
    }
}

