/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.archive.filestore;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.filestore.LogLexer;
import weblogic.diagnostics.archive.filestore.RecordParser;
import weblogic.diagnostics.archive.filestore.ServerLogFileParser;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;

public class ServerLogRecordParser
implements RecordParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRecord parseRecord(byte[] byArray, int n, int n2) {
        DataRecord dataRecord = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(new ByteArrayInputStream(byArray, n, n2));
            LogLexer logLexer = new LogLexer(inputStreamReader);
            ServerLogFileParser serverLogFileParser = new ServerLogFileParser(logLexer);
            dataRecord = serverLogFileParser.getNextServerLogEntry();
        }
        catch (Exception exception) {
            DiagnosticsLogger.logLogRecordParseError((String)new String(byArray, n, n2));
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {
                    UnexpectedExceptionHandler.handle("Could not close stream", exception);
                }
            }
        }
        return dataRecord;
    }

    public long getTimestamp(DataRecord dataRecord) {
        long l = 0L;
        if (dataRecord == null) {
            return 0L;
        }
        try {
            l = Long.parseLong(dataRecord.get(10).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }
}

