/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.archive.filestore;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.archive.filestore.FileDataArchive;
import weblogic.diagnostics.archive.filestore.RecordParser;
import weblogic.diagnostics.archive.filestore.UnformattedLogRecordParser;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.ManagementException;

public class UnformattedLogFileDataArchive
extends FileDataArchive {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticArchive");
    private static final byte[] RECORD_MARKER = "".getBytes();
    private static final RecordParser RECORD_PARSER = new UnformattedLogRecordParser();

    public UnformattedLogFileDataArchive(String string, File file, File file2, File file3, boolean bl) throws IOException, ManagementException {
        super(string, ArchiveConstants.getColumns(5), file, file2, file3, RECORD_PARSER, RECORD_MARKER, false, bl);
    }

    public UnformattedLogFileDataArchive(String string, File file, File file2, boolean bl) throws IOException, ManagementException {
        this(string, file, file.getParentFile(), file2, bl);
    }

    public String getDescription() {
        return "Unformatted Log";
    }

    private static void usage() {
        System.out.println("java [-Dverbose=true] " + UnformattedLogFileDataArchive.class.getName() + " logName logFile indexStoreDirectory lowRecordId highRecordId [queryString]");
        System.out.println("For example:");
        System.out.println("java [-Dverbose=true] " + UnformattedLogFileDataArchive.class.getName() + " WebAppLog c:/mydomain/myserver/webapp.log" + " c:/mydomain/servers/myserver/data/store/diagnostics 0 99999999999999" + " \"LINE LIKE '%Diagnostics%'\"");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 5) {
            UnformattedLogFileDataArchive.usage();
            return;
        }
        boolean bl = Boolean.getBoolean("verbose");
        String string = stringArray[0];
        File file = new File(stringArray[1]);
        File file2 = new File(stringArray[2]);
        long l = Long.parseLong(stringArray[3]);
        long l2 = Long.parseLong(stringArray[4]);
        String string2 = stringArray.length > 5 ? stringArray[5] : null;
        UnformattedLogFileDataArchive unformattedLogFileDataArchive = new UnformattedLogFileDataArchive(string, file, file.getParentFile(), file2, true);
        int n = 0;
        long l3 = System.currentTimeMillis();
        Iterator iterator = unformattedLogFileDataArchive.getDataRecords(l, l2, Long.MAX_VALUE, string2);
        while (iterator.hasNext()) {
            DataRecord dataRecord = (DataRecord)iterator.next();
            ++n;
            if (!bl) continue;
            System.out.println(dataRecord.toString());
        }
        long l4 = System.currentTimeMillis();
        System.out.println("Found " + n + " record(s) in " + (l4 - l3) + " ms");
        unformattedLogFileDataArchive.close();
    }
}

