/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.archive.wlstore;

import java.util.Iterator;
import weblogic.diagnostics.accessor.DiagnosticDataAccessException;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.archive.DiagnosticStoreRepository;
import weblogic.diagnostics.archive.wlstore.HarvesterPersistentRecordIterator;
import weblogic.diagnostics.archive.wlstore.PersistentStoreDataArchive;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.query.QueryException;
import weblogic.management.ManagementException;
import weblogic.store.PersistentStoreException;

public final class HarvestedPersistentStoreDataArchive
extends PersistentStoreDataArchive {
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticArchive");

    public HarvestedPersistentStoreDataArchive(String string, String string2, boolean bl) throws PersistentStoreException, ManagementException {
        super(string, ArchiveConstants.getColumns(2), "WLS_HVST", string2, bl);
    }

    public String getDescription() {
        return "Harvested diagnostic data";
    }

    public Iterator getDataRecords(String string) throws QueryException, DiagnosticDataAccessException {
        return this.getDataRecords(0L, Long.MAX_VALUE, string);
    }

    public Iterator getDataRecords(long l, long l2, String string) throws QueryException, DiagnosticDataAccessException, UnsupportedOperationException {
        return new HarvesterPersistentRecordIterator(this, l, l2, string);
    }

    public Iterator getDataRecords(long l, long l2, long l3, String string) throws QueryException, DiagnosticDataAccessException, UnsupportedOperationException {
        return new HarvesterPersistentRecordIterator(this, l, l2, l3, string);
    }

    private static void usage() {
        System.out.println("java [-Dverbose=true] " + HarvestedPersistentStoreDataArchive.class.getName() + "storeDirectory lowTimestamp highTimestamp [queryString]");
        System.out.println("For example:");
        System.out.println("java [-Dverbose=true] " + HarvestedPersistentStoreDataArchive.class.getName() + " c:/mydomain/servers/myserver/data/store/diagnostics 0 99999999999999" + " \"TYPE LIKE '%JDBC%'\"");
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        if (stringArray.length < 3) {
            HarvestedPersistentStoreDataArchive.usage();
            return;
        }
        String string2 = stringArray[0];
        long l = Long.parseLong(stringArray[1]);
        long l2 = Long.parseLong(stringArray[2]);
        String string3 = string = stringArray.length > 3 ? stringArray[3] : null;
        if (!DiagnosticStoreRepository.storeFileExists((String)string2)) {
            System.out.println("Specified store directory " + string2 + " does not exist or does not contain the diagnostic store file.");
            return;
        }
        boolean bl = Boolean.getBoolean("verbose");
        boolean bl2 = Boolean.getBoolean("doDelete");
        boolean bl3 = Boolean.getBoolean("byID");
        HarvestedPersistentStoreDataArchive harvestedPersistentStoreDataArchive = new HarvestedPersistentStoreDataArchive("HarvestedDataArchive", string2, !bl2);
        int n = 0;
        long l3 = System.currentTimeMillis();
        if (bl2) {
            n = harvestedPersistentStoreDataArchive.deleteDataRecords(l, l2, string);
        } else {
            Iterator iterator = bl3 ? harvestedPersistentStoreDataArchive.getDataRecords(l, l2, Long.MAX_VALUE, string) : harvestedPersistentStoreDataArchive.getDataRecords(l, l2, string);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (bl) {
                    System.out.println("RECORD>>>> " + e);
                }
                ++n;
            }
        }
        long l4 = System.currentTimeMillis();
        if (bl2) {
            System.out.println("Deleted " + n + " matching records in " + (l4 - l3) + " ms");
        } else {
            System.out.println("Found " + n + " matches in " + (l4 - l3) + " ms");
        }
        harvestedPersistentStoreDataArchive.close();
    }
}

