/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.kernel.KernelStatus;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public final class DiagnosticContextFactory {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugDiagnosticContext");
    private static final Factory DEFAULT_FACTORY;
    private static Factory SINGLETON;
    private static boolean contextEnabled;
    private static int propagationMode;

    static synchronized void setFactory(Factory factory) {
        if (!KernelStatus.isServer() || SINGLETON != DEFAULT_FACTORY || factory == null) {
            return;
        }
        SINGLETON = factory;
    }

    static boolean isEnabled() {
        return contextEnabled;
    }

    static void setEnabled(boolean bl) {
        contextEnabled = bl;
    }

    static int getPropagationMode() {
        return propagationMode;
    }

    static void setPropagationMode(int n) {
        propagationMode = n;
    }

    public static DiagnosticContext getDiagnosticContext() {
        WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
        return (DiagnosticContext)workContextMap.get("weblogic.diagnostics.DiagnosticContext");
    }

    public static DiagnosticContext findOrCreateDiagnosticContext() {
        return DiagnosticContextFactory.findOrCreateDiagnosticContext(contextEnabled);
    }

    public static DiagnosticContext findOrCreateDiagnosticContext(boolean bl) {
        if (!KernelStatus.isServer()) {
            bl = true;
        }
        return SINGLETON.findOrCreateDiagnosticContext(bl);
    }

    public static void invalidateCache() {
        SINGLETON.invalidateCache();
    }

    public static void setJFRThrottled(DiagnosticContext diagnosticContext) {
        SINGLETON.setJFRThrottled(diagnosticContext);
    }

    static void setDiagnosticContext(DiagnosticContext diagnosticContext) {
        SINGLETON.setDiagnosticContext(diagnosticContext);
    }

    static {
        SINGLETON = DEFAULT_FACTORY = new DefaultFactoryImpl();
        propagationMode = 383;
    }

    private static class DefaultFactoryImpl
    implements Factory {
        private DefaultFactoryImpl() {
        }

        public DiagnosticContext findOrCreateDiagnosticContext(boolean bl) {
            DiagnosticContext diagnosticContext;
            block3: {
                diagnosticContext = null;
                WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                diagnosticContext = (DiagnosticContext)workContextMap.get("weblogic.diagnostics.DiagnosticContext");
                if (diagnosticContext == null && bl) {
                    diagnosticContext = new DiagnosticContextImpl();
                    try {
                        workContextMap.put("weblogic.diagnostics.DiagnosticContext", (WorkContext)diagnosticContext, propagationMode);
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG_LOGGER.isDebugEnabled()) break block3;
                        throwable.printStackTrace();
                    }
                }
            }
            return diagnosticContext;
        }

        public void invalidateCache() {
        }

        public void setJFRThrottled(DiagnosticContext diagnosticContext) {
        }

        public void setDiagnosticContext(DiagnosticContext diagnosticContext) {
            block5: {
                WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                try {
                    if (diagnosticContext != null) {
                        workContextMap.put("weblogic.diagnostics.DiagnosticContext", (WorkContext)diagnosticContext, propagationMode);
                    } else if (workContextMap.get("weblogic.diagnostics.DiagnosticContext") != null) {
                        workContextMap.remove("weblogic.diagnostics.DiagnosticContext");
                        this.invalidateCache();
                    }
                }
                catch (Throwable throwable) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block5;
                    throwable.printStackTrace();
                }
            }
        }
    }

    public static interface Factory {
        public DiagnosticContext findOrCreateDiagnosticContext(boolean var1);

        public void invalidateCache();

        public void setJFRThrottled(DiagnosticContext var1);

        public void setDiagnosticContext(DiagnosticContext var1);
    }
}

