/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import java.util.HashSet;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextConstants;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.InvalidDyeException;

public final class DiagnosticContextHelper
implements DiagnosticContextConstants {
    private static DyeInfo[] dyeInfos = new DyeInfo[]{new DyeInfo("ADDR1", 1L), new DyeInfo("ADDR2", 2L), new DyeInfo("ADDR3", 4L), new DyeInfo("ADDR4", 8L), new DyeInfo("USER1", 16L), new DyeInfo("USER2", 32L), new DyeInfo("USER3", 64L), new DyeInfo("USER4", 128L), new DyeInfo("COOKIE1", 256L), new DyeInfo("COOKIE2", 512L), new DyeInfo("COOKIE3", 1024L), new DyeInfo("COOKIE4", 2048L), new DyeInfo("EXECQ1", 4096L), new DyeInfo("EXECQ2", 8192L), new DyeInfo("EXECQ3", 16384L), new DyeInfo("EXECQ4", 32768L), new DyeInfo("THREADGROUP1", 65536L), new DyeInfo("THREADGROUP2", 131072L), new DyeInfo("THREADGROUP3", 262144L), new DyeInfo("THREADGROUP4", 524288L), new DyeInfo("PROTOCOL_T3", 0x100000L), new DyeInfo("PROTOCOL_HTTP", 0x200000L), new DyeInfo("PROTOCOL_RMI", 0x400000L), new DyeInfo("PROTOCOL_SOAP", 0x800000L), new DyeInfo("PROTOCOL_IIOP", 0x1000000L), new DyeInfo("PROTOCOL_JRMP", 0x2000000L), new DyeInfo("PROTOCOL_SSL", 0x4000000L), new DyeInfo("CONNECTOR1", 0x8000000L), new DyeInfo("CONNECTOR2", 0x10000000L), new DyeInfo("CONNECTOR3", 0x20000000L), new DyeInfo("CONNECTOR4", 0x40000000L), new DyeInfo("THROTTLE", 0x100000000L), new DyeInfo("JFR_THROTTLE", 0x200000000L), new DyeInfo("DYE_0", 0x100000000000000L), new DyeInfo("DYE_1", 0x200000000000000L), new DyeInfo("DYE_2", 0x400000000000000L), new DyeInfo("DYE_3", 0x800000000000000L), new DyeInfo("DYE_4", 0x1000000000000000L), new DyeInfo("DYE_5", 0x2000000000000000L), new DyeInfo("DYE_6", 0x4000000000000000L), new DyeInfo("DYE_7", Long.MIN_VALUE)};

    public static String getContextId() {
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        return diagnosticContext != null ? diagnosticContext.getContextId() : null;
    }

    public static void setDye(byte by, boolean bl) throws InvalidDyeException {
        if (by < 56 || by > 63) {
            throw new InvalidDyeException("Invalid dye index " + by);
        }
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        if (diagnosticContext != null) {
            diagnosticContext.setDye(by, bl);
        }
    }

    public static boolean isDyedWith(byte by) throws InvalidDyeException {
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        return diagnosticContext != null ? diagnosticContext.isDyedWith(by) : false;
    }

    public static String getPayload() {
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        return diagnosticContext != null ? diagnosticContext.getPayload() : null;
    }

    public static void setPayload(String string) {
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        if (diagnosticContext != null) {
            diagnosticContext.setPayload(string);
        }
    }

    public static long parseDyeMask(String string) {
        if (string == null) {
            return 0L;
        }
        String[] stringArray = string.split(",");
        return DiagnosticContextHelper.parseDyeMask(stringArray);
    }

    public static long parseDyeMask(String[] stringArray) {
        long l = 0L;
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i].trim();
            l |= DiagnosticContextHelper.getDyeValue(string);
        }
        return l;
    }

    public static String[] getDyeFlagNames() {
        String[] stringArray = new String[dyeInfos.length];
        for (int i = 0; i < dyeInfos.length; ++i) {
            stringArray[i] = DiagnosticContextHelper.dyeInfos[i].dyeName;
        }
        return stringArray;
    }

    public static void validateDyeFlagNames(String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < dyeInfos.length; ++n) {
            hashSet.add(DiagnosticContextHelper.dyeInfos[n].dyeName);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (hashSet.contains(stringArray[n])) continue;
            throw new IllegalArgumentException("Dye name is invalid " + stringArray[n]);
        }
    }

    private static long getDyeValue(String string) {
        for (int i = 0; i < dyeInfos.length; ++i) {
            if (!string.equals(DiagnosticContextHelper.dyeInfos[i].dyeName)) continue;
            return DiagnosticContextHelper.dyeInfos[i].dyeValue;
        }
        return 0L;
    }

    public static synchronized void registerDye(String string, int n) throws InvalidDyeException {
        if (n < 0 || n > 63) {
            throw new InvalidDyeException("Invalid dye index " + n);
        }
        long l = 1L << n;
        int n2 = dyeInfos.length;
        for (int i = 0; i < n2; ++i) {
            DyeInfo dyeInfo = dyeInfos[i];
            if (string.equals(dyeInfo.dyeName)) {
                throw new InvalidDyeException("Dye " + string + " is already defined");
            }
            if (dyeInfo.dyeValue != l) continue;
            throw new InvalidDyeException("Dye " + dyeInfo.dyeName + " is already defined as dye " + n);
        }
        DyeInfo[] dyeInfoArray = new DyeInfo[n2 + 1];
        System.arraycopy(dyeInfos, 0, dyeInfoArray, 0, n2);
        dyeInfoArray[n2] = new DyeInfo(string, l);
        dyeInfos = dyeInfoArray;
    }

    private static class DyeInfo {
        String dyeName;
        long dyeValue;

        DyeInfo(String string, long l) {
            this.dyeName = string;
            this.dyeValue = l;
        }
    }
}

