/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.DiagnosticContextImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.flightrecorder.event.ThrottleInformationEventInfo;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.kernel.AuditableThreadLocal;
import weblogic.kernel.AuditableThreadLocalFactory;
import weblogic.kernel.ThreadLocalInitialValue;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public final class DiagnosticContextManager
implements TimerListener,
PropertyChangeListener {
    private static final DebugLogger DEBUG_LOGGER;
    private static final DiagnosticContextManager singleton;
    private static final AuthenticatedSubject kernelId;
    private boolean enabled;
    private boolean initialized;
    private static WLSDiagnosticContextFactoryImpl contextFactory;
    private static final String THROTTLE_RATE_REFRESH_PERIOD_PROPERTY = "weblogic.diagnostics.context.throttlerate_refresh_period";
    private static final String THROTTLING_MAX_EVENT_PER_SECOND_GOAL_PROPERTY = "weblogic.diagnostics.context.throttle_max_event_per_second_goal";
    private static final String THROTTLING_MAX_SELECTED_REQUESTS_PER_SECOND_GOAL_PROPERTY = "weblogic.diagnostics.context.throttle_max_selected_requests_per_second_goal";
    private static final int THROTTLE_RATE_REFRESH_PERIOD;
    private static final int THROTTLE_RATE_REFRESH_SECS;
    private static final int THROTTLING_MAX_EVENT_PER_SECOND_GOAL;
    private static final int THROTTLING_MAX_SELECTED_REQUESTS_PER_SECOND_GOAL;
    private static AtomicInteger requestSeqId;
    private static int ctxThrottleRate;
    private static AtomicInteger ctxJFREventsInTimerWindow;
    private static long lastRefreshTime;
    private TimerManager timerManager;
    private static AtomicLong runningEventCount;
    private static long previousEventCount;
    private static volatile int requestTotalInPeriod;
    private static volatile int requestSelectedInPeriod;
    private static int previousRequestTotal;
    private static int previousSelectedTotal;
    private static int periodsSinceThrottleChanged;
    private static Map<Long, WeakReference<DiagnosticContextWrapper>> diagnosticContextWrappers;
    private ThrottleInfoImpl throttleInfo = new ThrottleInfoImpl();
    private static AuditableThreadLocal localDiagnosticContext;
    static final long serialVersionUID = 3954498904932759198L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Throttleinfo_Diagnostic_Volume_After_Low;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    public static DiagnosticContextManager getDiagnosticContextManager() {
        return singleton;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        DiagnosticContextFactory.setEnabled(bl);
    }

    public int getPropagationMode() {
        return DiagnosticContextFactory.getPropagationMode();
    }

    public void setPropagationMode(int n) {
        DiagnosticContextFactory.setPropagationMode(n);
    }

    public void initialize() {
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean;
        if (this.initialized) {
            return;
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ServerMBean serverMBean = runtimeAccess.getServer();
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean2 = wLDFServerDiagnosticMBean = serverMBean != null ? serverMBean.getServerDiagnosticConfig() : null;
        if (wLDFServerDiagnosticMBean == null) {
            return;
        }
        this.setEnabled(wLDFServerDiagnosticMBean.isDiagnosticContextEnabled());
        wLDFServerDiagnosticMBean.addPropertyChangeListener(this);
        contextFactory = new WLSDiagnosticContextFactoryImpl();
        DiagnosticContextFactory.setFactory(contextFactory);
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        this.timerManager = timerManagerFactory.getDefaultTimerManager();
        this.timerManager.scheduleAtFixedRate((TimerListener)this, 0L, (long)THROTTLE_RATE_REFRESH_PERIOD);
        this.initialized = true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.attributesChanged(propertyChangeEvent.getSource());
    }

    private void attributesChanged(Object object) {
        if (object instanceof WLDFServerDiagnosticMBean) {
            WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = (WLDFServerDiagnosticMBean)object;
            this.setEnabled(wLDFServerDiagnosticMBean.isDiagnosticContextEnabled());
        }
    }

    public static boolean isJFRThrottled() {
        int n = ctxThrottleRate;
        if (localDiagnosticContext == null || n <= 1) {
            return true;
        }
        DiagnosticContextWrapper diagnosticContextWrapper = (DiagnosticContextWrapper)localDiagnosticContext.get();
        return diagnosticContextWrapper.isSelected();
    }

    public static String getDiagnosticContextId(long l) {
        WeakReference<DiagnosticContextWrapper> weakReference = diagnosticContextWrappers.get(l);
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug("Found DiagnosticContextWrapper ref = " + weakReference + " for thread id = " + l);
        }
        if (weakReference != null) {
            DiagnosticContextWrapper diagnosticContextWrapper = (DiagnosticContextWrapper)weakReference.get();
            if (DEBUG_LOGGER.isDebugEnabled()) {
                DEBUG_LOGGER.debug("Found DiagnosticContextWrapper wrapper = " + diagnosticContextWrapper + " for thread id = " + l);
            }
            if (diagnosticContextWrapper != null) {
                DiagnosticContext diagnosticContext = diagnosticContextWrapper.getDiagnosticContext();
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("DiagnosticContextWrapper context = " + diagnosticContext);
                }
                if (diagnosticContext != null) {
                    if (DEBUG_LOGGER.isDebugEnabled()) {
                        DEBUG_LOGGER.debug("DiagnosticContext id = " + diagnosticContext.getContextId() + " for thread id = " + l);
                    }
                    return diagnosticContext.getContextId();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        long l = System.currentTimeMillis();
        long l2 = l - lastRefreshTime;
        int n = requestTotalInPeriod;
        int n2 = requestSelectedInPeriod;
        int n3 = ctxJFREventsInTimerWindow.get();
        if (DEBUG_LOGGER.isDebugEnabled()) {
            long l3 = runningEventCount.get();
            DEBUG_LOGGER.debug("Event counts period (running, period) = " + (l3 - previousEventCount) + ", " + n3);
            previousEventCount = l3;
        }
        int n4 = 1;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        f = n / THROTTLE_RATE_REFRESH_SECS;
        if (n2 > 0 && n3 > 0) {
            f2 = (float)n3 / (float)n2;
            f3 = (float)THROTTLING_MAX_EVENT_PER_SECOND_GOAL / f2;
            n4 = Math.round(f / f3);
        }
        if (n4 < 1) {
            n4 = 1;
        }
        if ((f4 = f / (float)n4) > (float)THROTTLING_MAX_SELECTED_REQUESTS_PER_SECOND_GOAL) {
            n4 = Math.round(f / (float)THROTTLING_MAX_SELECTED_REQUESTS_PER_SECOND_GOAL);
        }
        if (n4 < 1) {
            n4 = 1;
        }
        if (DEBUG_LOGGER.isDebugEnabled()) {
            DEBUG_LOGGER.debug(" Last period Elapsed time: " + l2 + "   requests/sec: " + f + "   selected reqs: " + n2 + "   total reqs: " + n + "   events: " + n3 + "   events per request: " + f2 + "   projected selected requests: " + f4 + "   old throttle rate: " + ctxThrottleRate + "   new throttle rate: " + n4 + "   timer ECID: " + new DiagnosticContextImpl().getContextId());
        }
        ThrottleInfoImpl throttleInfoImpl = this.throttleInfo;
        synchronized (throttleInfoImpl) {
            this.throttleInfo.setLastPeriodDuration(l2);
            this.throttleInfo.setRequestsSelectedLastPeriod(n2);
            this.throttleInfo.setRequestsSeenLastPeriod(n);
            this.throttleInfo.setEventsGeneratedLastPeriod(n3);
            this.throttleInfo.setAverageEventsPerRequestLastPeriod(f2);
            this.throttleInfo.setProjectedSelectedRequestsPerSecBeforeCapCheck(Math.round(f4));
            this.throttleInfo.setPreviousThrottleRate(ctxThrottleRate);
            this.throttleInfo.setCurrentThrottleRate(n4);
            this.throttleInfo.setPeriodsSinceLastThrottleChange(periodsSinceThrottleChanged);
        }
        if (ctxThrottleRate != n4) {
            this.triggerThrottleInformationEvent();
            periodsSinceThrottleChanged = 1;
        } else {
            ++periodsSinceThrottleChanged;
        }
        ctxThrottleRate = n4;
        previousRequestTotal = n;
        previousSelectedTotal = n2;
        requestSelectedInPeriod = 0;
        requestTotalInPeriod = 0;
        lastRefreshTime = l;
        ctxJFREventsInTimerWindow.set(0);
    }

    public static void incrementJFREventCounter() {
        ctxJFREventsInTimerWindow.incrementAndGet();
        runningEventCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ThrottleInformationEventInfo triggerThrottleInformationEvent() {
        try {
            ThrottleInfoImpl throttleInfoImpl;
            ThrottleInfoImpl throttleInfoImpl2 = this.throttleInfo;
            // MONITORENTER : throttleInfoImpl2
            // MONITOREXIT : throttleInfoImpl2
            Object var6_2 = null;
            ThrottleInfoImpl throttleInfoImpl3 = throttleInfoImpl;
            if (!_WLDF$INST_FLD_Throttleinfo_Diagnostic_Volume_After_Low.isEnabledAndNotDyeFiltered()) return this.throttleInfo;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Throttleinfo_Diagnostic_Volume_After_Low;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)throttleInfoImpl3), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            return this.throttleInfo;
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            Object var5_5 = null;
            if (!_WLDF$INST_FLD_Throttleinfo_Diagnostic_Volume_After_Low.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Throttleinfo_Diagnostic_Volume_After_Low;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, var5_5), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.diagnostics.context.DiagnosticContextManager");
        _WLDF$INST_FLD_Throttleinfo_Diagnostic_Volume_After_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Throttleinfo_Diagnostic_Volume_After_Low");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"DiagnosticContextManager.java", (String)"weblogic.diagnostics.context.DiagnosticContextManager", (String)"triggerThrottleInformationEvent", (String)"()Lweblogic/diagnostics/flightrecorder/event/ThrottleInformationEventInfo;", (int)577, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Throttleinfo_Diagnostic_Volume_After_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo(null, (ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"return", null, (boolean)false, (boolean)true), null)}), (boolean)false);
        DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugDiagnosticContext");
        singleton = new DiagnosticContextManager();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        THROTTLE_RATE_REFRESH_PERIOD = Integer.getInteger(THROTTLE_RATE_REFRESH_PERIOD_PROPERTY, 2000);
        THROTTLE_RATE_REFRESH_SECS = THROTTLE_RATE_REFRESH_PERIOD / 1000;
        THROTTLING_MAX_EVENT_PER_SECOND_GOAL = Integer.getInteger(THROTTLING_MAX_EVENT_PER_SECOND_GOAL_PROPERTY, 800);
        THROTTLING_MAX_SELECTED_REQUESTS_PER_SECOND_GOAL = Integer.getInteger(THROTTLING_MAX_SELECTED_REQUESTS_PER_SECOND_GOAL_PROPERTY, 128);
        requestSeqId = new AtomicInteger();
        ctxThrottleRate = 1;
        ctxJFREventsInTimerWindow = new AtomicInteger(0);
        lastRefreshTime = System.currentTimeMillis();
        runningEventCount = new AtomicLong(0L);
        previousEventCount = 0L;
        requestTotalInPeriod = 0;
        requestSelectedInPeriod = 0;
        previousRequestTotal = 0;
        previousSelectedTotal = 0;
        periodsSinceThrottleChanged = 1;
        diagnosticContextWrappers = new ConcurrentHashMap<Long, WeakReference<DiagnosticContextWrapper>>();
        localDiagnosticContext = AuditableThreadLocalFactory.createThreadLocal((ThreadLocalInitialValue)new ThreadLocalInitialValue(){

            protected Object initialValue() {
                if (DEBUG_LOGGER.isDebugEnabled()) {
                    DEBUG_LOGGER.debug("Invoked DCM.initialValue() for thread id=" + Thread.currentThread().getId() + ", name=" + Thread.currentThread().getName(), (Throwable)new Exception());
                }
                return this.initialValue(null);
            }

            private Object initialValue(DiagnosticContextWrapper diagnosticContextWrapper) {
                boolean bl = false;
                if (diagnosticContextWrapper == null) {
                    diagnosticContextWrapper = new DiagnosticContextWrapper();
                    bl = true;
                }
                long l = Thread.currentThread().getId();
                if (!diagnosticContextWrappers.containsKey(l)) {
                    if (DEBUG_LOGGER.isDebugEnabled()) {
                        DEBUG_LOGGER.debug("Populating DC Wrapper map for thread id=" + Thread.currentThread().getId() + ", name=" + Thread.currentThread().getName() + ", wrapper=" + diagnosticContextWrapper);
                    }
                    diagnosticContextWrappers.put(l, new WeakReference<DiagnosticContextWrapper>(diagnosticContextWrapper));
                } else if (DEBUG_LOGGER.isDebugEnabled() & bl) {
                    DEBUG_LOGGER.debug("DC Wrapper already exists for thread id=" + Thread.currentThread().getId() + ", name=" + Thread.currentThread().getName() + ", Wrapper for child thread=" + diagnosticContextWrapper, (Throwable)new Exception());
                }
                diagnosticContextWrapper.reset();
                return diagnosticContextWrapper;
            }

            protected Object resetValue(Object object) {
                return this.initialValue((DiagnosticContextWrapper)object);
            }
        });
    }

    private static class ThrottleInfoImpl
    implements ThrottleInformationEventInfo {
        private float averageEventsPerRequestLastPeriod;
        private int currentThrottleRate;
        private int eventsGeneratedLastPeriod;
        private long lastPeriodDuration;
        private int previousThrottleRate;
        private int projectedSelectedRequestsPerSecBeforeCapCheck;
        private int requestsSeenLastPeriod;
        private int requestsSelectedLastPeriod;
        private int periodsSinceLastThrottleChange;

        private ThrottleInfoImpl() {
        }

        public float getAverageEventsPerRequestLastPeriod() {
            return this.averageEventsPerRequestLastPeriod;
        }

        public int getCurrentThrottleRate() {
            return this.currentThrottleRate;
        }

        public int getEventsGeneratedLastPeriod() {
            return this.eventsGeneratedLastPeriod;
        }

        public long getLastPeriodDuration() {
            return this.lastPeriodDuration;
        }

        public int getPeriodsSinceLastThrottleChange() {
            return this.periodsSinceLastThrottleChange;
        }

        public int getPreviousThrottleRate() {
            return this.previousThrottleRate;
        }

        public int getProjectedSelectedRequestsPerSecBeforeCapCheck() {
            return this.projectedSelectedRequestsPerSecBeforeCapCheck;
        }

        public int getRequestsSeenLastPeriod() {
            return this.requestsSeenLastPeriod;
        }

        public int getRequestsSelectedLastPeriod() {
            return this.requestsSelectedLastPeriod;
        }

        public void setAverageEventsPerRequestLastPeriod(float f) {
            this.averageEventsPerRequestLastPeriod = f;
        }

        public void setCurrentThrottleRate(int n) {
            this.currentThrottleRate = n;
        }

        public void setEventsGeneratedLastPeriod(int n) {
            this.eventsGeneratedLastPeriod = n;
        }

        public void setLastPeriodDuration(long l) {
            this.lastPeriodDuration = l;
        }

        public void setPeriodsSinceLastThrottleChange(int n) {
            this.periodsSinceLastThrottleChange = n;
        }

        public void setPreviousThrottleRate(int n) {
            this.previousThrottleRate = n;
        }

        public void setProjectedSelectedRequestsPerSecBeforeCapCheck(int n) {
            this.projectedSelectedRequestsPerSecBeforeCapCheck = n;
        }

        public void setRequestsSeenLastPeriod(int n) {
            this.requestsSeenLastPeriod = n;
        }

        public void setRequestsSelectedLastPeriod(int n) {
            this.requestsSelectedLastPeriod = n;
        }
    }

    private static final class WLSDiagnosticContextFactoryImpl
    implements DiagnosticContextFactory.Factory {
        private WLSDiagnosticContextFactoryImpl() {
        }

        public DiagnosticContext findOrCreateDiagnosticContext(final boolean bl) {
            DiagnosticContext diagnosticContext;
            block3: {
                diagnosticContext = null;
                final DiagnosticContextWrapper diagnosticContextWrapper = (DiagnosticContextWrapper)localDiagnosticContext.get();
                diagnosticContext = diagnosticContextWrapper.getDiagnosticContext();
                if (diagnosticContext != null) {
                    return diagnosticContext;
                }
                try {
                    diagnosticContext = (DiagnosticContext)SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                            DiagnosticContext diagnosticContext = (DiagnosticContext)workContextMap.get("weblogic.diagnostics.DiagnosticContext");
                            if (diagnosticContext == null && bl) {
                                diagnosticContext = new DiagnosticContextImpl();
                                int n = DiagnosticContextFactory.getPropagationMode();
                                workContextMap.put("weblogic.diagnostics.DiagnosticContext", (WorkContext)diagnosticContext, n);
                            }
                            diagnosticContextWrapper.setDiagnosticContext(diagnosticContext);
                            if (diagnosticContext != null && diagnosticContextWrapper.isSelected()) {
                                long l = diagnosticContext.getDyeVector();
                                diagnosticContext.setDyeVector(l | 0x200000000L);
                            }
                            return diagnosticContext;
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block3;
                    throwable.printStackTrace();
                }
            }
            return diagnosticContext;
        }

        public void invalidateCache() {
            DiagnosticContextWrapper diagnosticContextWrapper = (DiagnosticContextWrapper)localDiagnosticContext.get();
            diagnosticContextWrapper.setDiagnosticContext(null);
        }

        public void setJFRThrottled(DiagnosticContext diagnosticContext) {
            long l;
            if (diagnosticContext != null && ((l = diagnosticContext.getDyeVector()) & 0x200000000L) != 0L) {
                DiagnosticContextWrapper diagnosticContextWrapper = (DiagnosticContextWrapper)localDiagnosticContext.get();
                diagnosticContextWrapper.setSelected(true);
            }
        }

        public void setDiagnosticContext(final DiagnosticContext diagnosticContext) {
            block2: {
                final DiagnosticContextWrapper diagnosticContextWrapper = (DiagnosticContextWrapper)localDiagnosticContext.get();
                try {
                    SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                            int n = DiagnosticContextFactory.getPropagationMode();
                            if (diagnosticContext == null) {
                                if (workContextMap.get("weblogic.diagnostics.DiagnosticContext") != null) {
                                    workContextMap.remove("weblogic.diagnostics.DiagnosticContext");
                                    WLSDiagnosticContextFactoryImpl.this.invalidateCache();
                                }
                            } else {
                                workContextMap.put("weblogic.diagnostics.DiagnosticContext", (WorkContext)diagnosticContext, n);
                            }
                            diagnosticContextWrapper.setDiagnosticContext(diagnosticContext);
                            return null;
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (!DEBUG_LOGGER.isDebugEnabled()) break block2;
                    throwable.printStackTrace();
                }
            }
        }
    }

    private static final class DiagnosticContextWrapper {
        private boolean selected;
        private DiagnosticContext ctx;

        private DiagnosticContextWrapper() {
        }

        DiagnosticContext getDiagnosticContext() {
            return this.ctx;
        }

        void setDiagnosticContext(DiagnosticContext diagnosticContext) {
            this.ctx = diagnosticContext;
        }

        boolean isSelected() {
            return this.selected;
        }

        void setSelected(boolean bl) {
            if (bl) {
                requestSeqId.set(0);
                requestSelectedInPeriod++;
            }
            this.selected = bl;
        }

        void reset() {
            this.ctx = null;
            int n = ctxThrottleRate;
            if (n <= 1) {
                this.selected = true;
                requestTotalInPeriod++;
                requestSelectedInPeriod++;
                return;
            }
            this.selected = false;
            int n2 = requestSeqId.incrementAndGet();
            requestTotalInPeriod++;
            if (n2 >= n) {
                if (n2 == n) {
                    this.setSelected(true);
                } else {
                    requestSeqId.set(0);
                }
            }
        }
    }
}

