/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.context;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.DiagnosticContextImpl;
import weblogic.diagnostics.context.DiagnosticContextModifier;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.workarea.WorkContextInput;
import weblogic.workarea.WorkContextOutput;
import weblogic.workarea.utils.WorkContextInputAdapter;
import weblogic.workarea.utils.WorkContextOutputAdapter;

class DiagnosticContextModifierImpl
implements DiagnosticContextModifier {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static DiagnosticContextModifier SINGLETON = null;

    private DiagnosticContextModifierImpl() {
    }

    static synchronized DiagnosticContextModifier getInstance() {
        if (!SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID))) {
            return null;
        }
        if (SINGLETON == null) {
            SINGLETON = new DiagnosticContextModifierImpl();
        }
        return SINGLETON;
    }

    public byte[] getContext() throws IOException {
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        if (diagnosticContext == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        WorkContextOutputAdapter workContextOutputAdapter = new WorkContextOutputAdapter((ObjectOutput)objectOutputStream);
        diagnosticContext.writeContext((WorkContextOutput)workContextOutputAdapter);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public void setContext(byte[] byArray) throws IOException {
        if (byArray == null) {
            DiagnosticContextFactory.setDiagnosticContext(null);
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        WorkContextInputAdapter workContextInputAdapter = new WorkContextInputAdapter((ObjectInput)objectInputStream);
        DiagnosticContextImpl diagnosticContextImpl = new DiagnosticContextImpl();
        diagnosticContextImpl.readContext((WorkContextInput)workContextInputAdapter);
        DiagnosticContextFactory.setDiagnosticContext(diagnosticContextImpl);
    }

    public void setContextId(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        DiagnosticContextImpl diagnosticContextImpl = new DiagnosticContextImpl();
        diagnosticContextImpl.setContextId(string);
        DiagnosticContextFactory.setDiagnosticContext(diagnosticContextImpl);
    }
}

