/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.debug;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class DebugCategoryParser {
    private static final String TAG_NAME = "oldDebugCategory";
    private static final String OUTPUT_FILE_OPTION = "-outputFile";
    private static final String BOOLEAN_TYPE_NAME = "boolean";
    private static boolean verbose = false;
    private static Properties props = new Properties();

    public static boolean start(RootDoc rootDoc) throws IOException {
        int n;
        ClassDoc[] classDocArray = rootDoc.classes();
        if (classDocArray == null) {
            return false;
        }
        String[][] stringArray = rootDoc.options();
        String string = null;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n][0].equals(OUTPUT_FILE_OPTION)) {
                    string = stringArray[n][1];
                    continue;
                }
                if (!stringArray[n][0].equals("-verbose")) continue;
                verbose = true;
            }
        }
        rootDoc.printNotice("Started building the DebugCategory mapping...");
        for (n = 0; n < classDocArray.length; ++n) {
            if (DebugCategoryParser.processClass(rootDoc, classDocArray[n])) continue;
            return false;
        }
        rootDoc.printNotice("The DebugCategory mapping will be written to " + string);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        props.store(fileOutputStream, "Map of DebugLogger to DebugCategory names");
        rootDoc.printNotice("DebugCategory mapping generated successfully");
        return true;
    }

    public static int optionLength(String string) {
        if (string.equals(OUTPUT_FILE_OPTION)) {
            return 2;
        }
        return 0;
    }

    private static boolean processClass(RootDoc rootDoc, ClassDoc classDoc) {
        rootDoc.printNotice("DebugScopesParser will process class " + classDoc.qualifiedTypeName());
        MethodDoc[] methodDocArray = classDoc.methods();
        if (methodDocArray == null) {
            return false;
        }
        for (int i = 0; i < methodDocArray.length; ++i) {
            Parameter[] parameterArray;
            String string;
            String string2;
            MethodDoc methodDoc = methodDocArray[i];
            String string3 = methodDoc.name();
            if (verbose) {
                rootDoc.printNotice("Processing method " + string3);
            }
            if (string3.startsWith("get")) {
                string2 = string3.substring(3);
                string = methodDoc.returnType().typeName();
            } else if (string3.startsWith("is")) {
                string2 = string3.substring(2);
                string = methodDoc.returnType().typeName();
            } else if (string3.startsWith("set")) {
                Parameter parameter;
                string2 = string3.substring(3);
                parameterArray = methodDoc.parameters();
                if (parameterArray == null || parameterArray.length == 0 || (parameter = parameterArray[0]) == null) continue;
                string = parameter.typeName();
            } else {
                if (!verbose) continue;
                rootDoc.printNotice("The method " + string3 + " does not define an MBean attribute");
                continue;
            }
            if (!string.equals(BOOLEAN_TYPE_NAME)) continue;
            if (verbose) {
                rootDoc.printNotice("Processing attribute name " + string2 + " of type " + string);
            }
            if ((parameterArray = methodDoc.tags(TAG_NAME)) == null || parameterArray.length == 0) continue;
            for (int j = 0; j < parameterArray.length; ++j) {
                Parameter parameter = parameterArray[j];
                StringTokenizer stringTokenizer = new StringTokenizer(parameter.text().trim());
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string4 = stringTokenizer.nextToken();
                String string5 = props.getProperty(string2);
                if (string5 == null) {
                    props.put(string2, string4);
                } else {
                    props.put(string2, string5 + "," + string4);
                }
                if (!verbose) continue;
                rootDoc.printNotice("Mapping attribute " + string2 + " to the Category " + string4);
            }
        }
        return true;
    }
}

