/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.debug;

import com.bea.logging.LoggingService;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.util.logging.Logger;
import weblogic.diagnostics.debug.DebugBeanConfigurationException;
import weblogic.diagnostics.debug.DebugProvider;
import weblogic.diagnostics.debug.DebugScopeInitializationException;
import weblogic.diagnostics.debug.DebugScopeTree;
import weblogic.kernel.KernelLogManager;
import weblogic.management.configuration.ServerDebugMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ServerDebugProvider
implements DebugProvider {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private DebugScopeTree debugTree = null;
    private ServerDebugMBean myDebugBean = null;

    public String getName() {
        return this.getClass().getName();
    }

    public String getCommandLineOverridePrefix() {
        return "weblogic.debug.";
    }

    public void intializeDebugScopes() throws DebugScopeInitializationException {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("DebugScopeTree.ser");
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            this.debugTree = (DebugScopeTree)objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new DebugScopeInitializationException(exception.getMessage(), (Throwable)exception);
        }
    }

    public DebugScopeTree getDebugScopeTree() throws DebugScopeInitializationException {
        if (this.debugTree == null) {
            this.intializeDebugScopes();
        }
        return this.debugTree;
    }

    public Object getDebugConfiguration() throws DebugBeanConfigurationException {
        if (this.myDebugBean == null) {
            this.myDebugBean = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getServerDebug();
        }
        return this.myDebugBean;
    }

    public Logger getLogger() {
        Logger logger = KernelLogManager.getLogger();
        String string = logger.getClass().getName();
        if (string.equals("weblogic.logging.log4j.JDKLog4jAdapter")) {
            return logger;
        }
        return LoggingService.getInstance().getDebugDelegateLogger();
    }
}

