/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.debug;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import weblogic.diagnostics.context.DiagnosticContextHelper;
import weblogic.diagnostics.debug.DebugContext;
import weblogic.diagnostics.debug.DebugContextImpl;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.debug.DebugLoggerRepository;
import weblogic.diagnostics.debug.DebugProvider;
import weblogic.diagnostics.debug.DebugProviderRegistration;
import weblogic.diagnostics.debug.DebugProviderRegistrationException;
import weblogic.diagnostics.debug.DebugScopeNode;
import weblogic.diagnostics.debug.DebugScopeTree;
import weblogic.diagnostics.debug.DebugScopeUtil;
import weblogic.diagnostics.debug.InvalidDebugScopeException;
import weblogic.diagnostics.debug.KernelDebugService;
import weblogic.diagnostics.debug.ServerDebugProvider;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.ServerDebugMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;

public class ServerDebugService
extends KernelDebugService
implements PropertyChangeListener,
DebugScopeUtil {
    private static ServerDebugService singleton = null;
    private static final boolean DEBUG = false;
    private ServerDebugMBean serverDebug = null;
    private DebugScopeTree debugScopeTree = null;
    private boolean initialized = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static ServerDebugService getInstance() {
        if (singleton == null) {
            singleton = new ServerDebugService();
        }
        return singleton;
    }

    private ServerDebugService() {
        try {
            this.debugScopeTree = DebugScopeTree.initializeFromPersistence();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized String[] getChildDebugScopes(String string) throws InvalidDebugScopeException {
        String[] stringArray;
        DebugScopeNode debugScopeNode = this.debugScopeTree.findDebugScopeNode(string);
        Iterator iterator = debugScopeNode.getChildDebugScopeNodes().iterator();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (iterator.hasNext()) {
            stringArray = ((DebugScopeNode)iterator.next()).getNodeName();
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public synchronized String[] getChildDebugAttributes(String string) throws InvalidDebugScopeException {
        String[] stringArray;
        DebugScopeNode debugScopeNode = this.debugScopeTree.findDebugScopeNode(string);
        Iterator iterator = debugScopeNode.getDebugAttributes().iterator();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public void initializeServerDebug(Logger logger) throws DebugProviderRegistrationException {
        if (this.initialized) {
            return;
        }
        this.serverDebug = ManagementService.getRuntimeAccess(kernelId).getServer().getServerDebug();
        ServerDebugProvider serverDebugProvider = new ServerDebugProvider();
        DebugProviderRegistration.registerDebugProvider((DebugProvider)serverDebugProvider, (DebugLoggerRepository)DebugLogger.getDefaultDebugLoggerRepository());
        this.serverDebug.addPropertyChangeListener(this);
        this.initDebugContextMode();
        DebugLogger.setDebugContext((DebugContext)new DebugContextImpl());
        this.initializeDebugLogging(logger);
        this.initializeDebugLoggersFromOldDebugCategoryCommandLineProperties();
        this.initialized = true;
    }

    public void initializeDebugLogging(Logger logger) {
    }

    private void initDebugContextMode() {
        if (this.serverDebug.getDiagnosticContextDebugMode().equals("And")) {
            DebugLogger.setContextMode((int)1);
        } else if (this.serverDebug.getDiagnosticContextDebugMode().equals("Or")) {
            DebugLogger.setContextMode((int)2);
        } else {
            DebugLogger.setContextMode((int)0);
        }
        DebugLogger.setDebugMask((long)DiagnosticContextHelper.parseDyeMask(this.serverDebug.getDebugMaskCriterias()));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = ((WebLogicMBean)propertyChangeEvent.getSource()).getName();
        String string2 = ((WebLogicMBean)propertyChangeEvent.getSource()).getType();
        this.attributeValueChanged(string, string2, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    private void attributeValueChanged(String string, String string2, String string3, Object object, Object object2) {
        if (string3.equals("DiagnosticContextDebugMode")) {
            this.initDebugContextMode();
        } else if (string3.equals("DebugMaskCriterias")) {
            this.initDebugContextMode();
        }
    }

    private void initializeDebugLoggersFromOldDebugCategoryCommandLineProperties() {
        try {
            Properties properties = new Properties();
            properties.load(ServerDebugService.class.getResourceAsStream("OldDebugCategory.props"));
            Set<Object> set = properties.keySet();
            for (String string : set) {
                String string2 = properties.getProperty(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!Debug.getCategory((String)string3).isEnabled()) continue;
                    DebugLogger.getDebugLogger((String)string).setDebugEnabled(true);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error initializing from debug category properties");
        }
    }

    void testDebugScopeName(String string) throws InvalidDebugScopeException {
        this.debugScopeTree.findDebugScopeNode(string);
    }
}

