/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.descriptor;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.diagnostics.descriptor.WLDFNotificationBeanImpl;
import weblogic.diagnostics.descriptor.WLDFSMTPNotificationBean;
import weblogic.diagnostics.watch.WatchValidator;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class WLDFSMTPNotificationBeanImpl
extends WLDFNotificationBeanImpl
implements WLDFSMTPNotificationBean,
Serializable {
    private String _Body;
    private String _MailSessionJNDIName;
    private String[] _Recipients;
    private String _Subject;
    private static SchemaHelper2 _schemaHelper;

    public WLDFSMTPNotificationBeanImpl() {
        this._initializeProperty(-1);
    }

    public WLDFSMTPNotificationBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getMailSessionJNDIName() {
        return this._MailSessionJNDIName;
    }

    public boolean isMailSessionJNDINameSet() {
        return this._isSet(2);
    }

    public void setMailSessionJNDIName(String string) {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"MailSessionJNDIName", (String)string);
        LegalChecks.checkNonNull((String)"MailSessionJNDIName", (Object)string);
        String string2 = this._MailSessionJNDIName;
        this._MailSessionJNDIName = string;
        this._postSet(2, string2, string);
    }

    public String getSubject() {
        return this._Subject;
    }

    public boolean isSubjectSet() {
        return this._isSet(3);
    }

    public void setSubject(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._Subject;
        this._Subject = string;
        this._postSet(3, string2, string);
    }

    public String getBody() {
        return this._Body;
    }

    public boolean isBodySet() {
        return this._isSet(4);
    }

    public void setBody(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._Body;
        this._Body = string;
        this._postSet(4, string2, string);
    }

    public String[] getRecipients() {
        return this._Recipients;
    }

    public boolean isRecipientsSet() {
        return this._isSet(5);
    }

    public void setRecipients(String[] stringArray) {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        WatchValidator.validateRecipients(stringArray);
        String[] stringArray2 = this._Recipients;
        this._Recipients = stringArray;
        this._postSet(5, stringArray2, stringArray);
    }

    public void addRecipient(String string) {
        this._getHelper()._ensureNonNull((Object)string);
        String[] stringArray = this._isSet(5) ? (String[])this._getHelper()._extendArray((Object)this.getRecipients(), String.class, (Object)string) : new String[]{string};
        try {
            this.setRecipients(stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void removeRecipient(String string) {
        String[] stringArray = this.getRecipients();
        String[] stringArray2 = (String[])this._getHelper()._removeElement((Object)stringArray, String.class, (Object)string);
        if (stringArray2.length != stringArray.length) {
            try {
                this.setRecipients(stringArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        LegalChecks.checkIsSet((String)"MailSessionJNDIName", (boolean)this.isMailSessionJNDINameSet());
        LegalChecks.checkIsSet((String)"Recipients", (boolean)this.isRecipientsSet());
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 4;
        }
        try {
            switch (n) {
                case 4: {
                    this._Body = null;
                    if (bl) break;
                }
                case 2: {
                    this._MailSessionJNDIName = null;
                    if (bl) break;
                }
                case 5: {
                    this._Recipients = new String[0];
                    if (bl) break;
                }
                case 3: {
                    this._Subject = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/weblogic-diagnostics/1.0/weblogic-diagnostics.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/weblogic-diagnostics";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public static class SchemaHelper2
    extends WLDFNotificationBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 4: {
                    if (!string.equals("body")) break;
                    return 4;
                }
                case 22: {
                    if (!string.equals("mail-session-jndi-name")) break;
                    return 2;
                }
                case 9: {
                    if (!string.equals("recipient")) break;
                    return 5;
                }
                case 7: {
                    if (!string.equals("subject")) break;
                    return 3;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 4: {
                    return "body";
                }
                case 2: {
                    return "mail-session-jndi-name";
                }
                case 5: {
                    return "recipient";
                }
                case 3: {
                    return "subject";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 5: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 0: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends WLDFNotificationBeanImpl.Helper {
        private WLDFSMTPNotificationBeanImpl bean;

        protected Helper(WLDFSMTPNotificationBeanImpl wLDFSMTPNotificationBeanImpl) {
            super(wLDFSMTPNotificationBeanImpl);
            this.bean = wLDFSMTPNotificationBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 4: {
                    return "Body";
                }
                case 2: {
                    return "MailSessionJNDIName";
                }
                case 5: {
                    return "Recipients";
                }
                case 3: {
                    return "Subject";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Body")) {
                return 4;
            }
            if (string.equals("MailSessionJNDIName")) {
                return 2;
            }
            if (string.equals("Recipients")) {
                return 5;
            }
            if (string.equals("Subject")) {
                return 3;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBodySet()) {
                    stringBuffer.append("Body");
                    stringBuffer.append(String.valueOf(this.bean.getBody()));
                }
                if (this.bean.isMailSessionJNDINameSet()) {
                    stringBuffer.append("MailSessionJNDIName");
                    stringBuffer.append(String.valueOf(this.bean.getMailSessionJNDIName()));
                }
                if (this.bean.isRecipientsSet()) {
                    stringBuffer.append("Recipients");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getRecipients())));
                }
                if (this.bean.isSubjectSet()) {
                    stringBuffer.append("Subject");
                    stringBuffer.append(String.valueOf(this.bean.getSubject()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WLDFSMTPNotificationBeanImpl wLDFSMTPNotificationBeanImpl = (WLDFSMTPNotificationBeanImpl)abstractDescriptorBean;
                this.computeDiff("Body", this.bean.getBody(), wLDFSMTPNotificationBeanImpl.getBody(), true);
                this.computeDiff("MailSessionJNDIName", this.bean.getMailSessionJNDIName(), wLDFSMTPNotificationBeanImpl.getMailSessionJNDIName(), true);
                this.computeDiff("Recipients", this.bean.getRecipients(), wLDFSMTPNotificationBeanImpl.getRecipients(), true);
                this.computeDiff("Subject", this.bean.getSubject(), wLDFSMTPNotificationBeanImpl.getSubject(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WLDFSMTPNotificationBeanImpl wLDFSMTPNotificationBeanImpl = (WLDFSMTPNotificationBeanImpl)beanUpdateEvent.getSourceBean();
                WLDFSMTPNotificationBeanImpl wLDFSMTPNotificationBeanImpl2 = (WLDFSMTPNotificationBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("Body")) {
                    wLDFSMTPNotificationBeanImpl.setBody(wLDFSMTPNotificationBeanImpl2.getBody());
                    wLDFSMTPNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 4);
                } else if (string.equals("MailSessionJNDIName")) {
                    wLDFSMTPNotificationBeanImpl.setMailSessionJNDIName(wLDFSMTPNotificationBeanImpl2.getMailSessionJNDIName());
                    wLDFSMTPNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("Recipients")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject(propertyUpdate.getAddedObject());
                        wLDFSMTPNotificationBeanImpl.addRecipient((String)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        wLDFSMTPNotificationBeanImpl.removeRecipient((String)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (wLDFSMTPNotificationBeanImpl.getRecipients() == null || wLDFSMTPNotificationBeanImpl.getRecipients().length == 0) {
                        wLDFSMTPNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 5);
                    }
                } else if (string.equals("Subject")) {
                    wLDFSMTPNotificationBeanImpl.setSubject(wLDFSMTPNotificationBeanImpl2.getSubject());
                    wLDFSMTPNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WLDFSMTPNotificationBeanImpl wLDFSMTPNotificationBeanImpl = (WLDFSMTPNotificationBeanImpl)abstractDescriptorBean;
                super.finishCopy(wLDFSMTPNotificationBeanImpl, bl, list);
                if ((list == null || !list.contains("Body")) && this.bean.isBodySet()) {
                    wLDFSMTPNotificationBeanImpl.setBody(this.bean.getBody());
                }
                if ((list == null || !list.contains("MailSessionJNDIName")) && this.bean.isMailSessionJNDINameSet()) {
                    wLDFSMTPNotificationBeanImpl.setMailSessionJNDIName(this.bean.getMailSessionJNDIName());
                }
                if ((list == null || !list.contains("Recipients")) && this.bean.isRecipientsSet()) {
                    String[] stringArray = this.bean.getRecipients();
                    wLDFSMTPNotificationBeanImpl.setRecipients(stringArray == null ? null : (String[])stringArray.clone());
                }
                if ((list == null || !list.contains("Subject")) && this.bean.isSubjectSet()) {
                    wLDFSMTPNotificationBeanImpl.setSubject(this.bean.getSubject());
                }
                return wLDFSMTPNotificationBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

