/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.descriptor;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.diagnostics.descriptor.WLDFBeanImpl;
import weblogic.diagnostics.descriptor.WLDFNotificationBean;
import weblogic.diagnostics.descriptor.WLDFNotificationBeanImpl;
import weblogic.diagnostics.descriptor.WLDFWatchBean;
import weblogic.diagnostics.descriptor.WLDFWatchCustomizer;
import weblogic.diagnostics.watch.WatchValidator;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class WLDFWatchBeanImpl
extends WLDFBeanImpl
implements WLDFWatchBean,
Serializable {
    private int _AlarmResetPeriod;
    private String _AlarmType;
    private boolean _Enabled;
    private WLDFNotificationBean[] _Notifications;
    private String _RuleExpression;
    private String _RuleType;
    private String _Severity;
    private WLDFWatchCustomizer _customizer;
    private static SchemaHelper2 _schemaHelper;

    public WLDFWatchBeanImpl() {
        try {
            this._customizer = new WLDFWatchCustomizer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public WLDFWatchBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new WLDFWatchCustomizer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public boolean isEnabled() {
        return this._Enabled;
    }

    public boolean isEnabledSet() {
        return this._isSet(1);
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this._Enabled;
        this._Enabled = bl;
        this._postSet(1, bl2, bl);
    }

    public String getRuleType() {
        return this._RuleType;
    }

    public boolean isRuleTypeSet() {
        return this._isSet(2);
    }

    public void setRuleType(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Harvester", "Log", "EventData"};
        string = LegalChecks.checkInEnum((String)"RuleType", (String)string, (String[])stringArray);
        String string2 = this._RuleType;
        this._RuleType = string;
        this._postSet(2, string2, string);
    }

    public String getRuleExpression() {
        return this._RuleExpression;
    }

    public boolean isRuleExpressionSet() {
        return this._isSet(3);
    }

    public void setRuleExpression(String string) {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"RuleExpression", (String)string);
        LegalChecks.checkNonNull((String)"RuleExpression", (Object)string);
        String string2 = this._RuleExpression;
        this._RuleExpression = string;
        this._postSet(3, string2, string);
    }

    public String getSeverity() {
        return this._customizer.getSeverity();
    }

    public boolean isSeveritySet() {
        return this._isSet(4);
    }

    public void setSeverity(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Info", "Warning", "Error", "Notice", "Critical", "Alert", "Emergency"};
        string = LegalChecks.checkInEnum((String)"Severity", (String)string, (String[])stringArray);
        String string2 = this.getSeverity();
        this._customizer.setSeverity(string);
        this._postSet(4, string2, string);
    }

    public String getAlarmType() {
        return this._AlarmType;
    }

    public boolean isAlarmTypeSet() {
        return this._isSet(5);
    }

    public void setAlarmType(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"None", "ManualReset", "AutomaticReset"};
        string = LegalChecks.checkInEnum((String)"AlarmType", (String)string, (String[])stringArray);
        String string2 = this._AlarmType;
        this._AlarmType = string;
        this._postSet(5, string2, string);
    }

    public int getAlarmResetPeriod() {
        return this._AlarmResetPeriod;
    }

    public boolean isAlarmResetPeriodSet() {
        return this._isSet(6);
    }

    public void setAlarmResetPeriod(int n) {
        LegalChecks.checkMin((String)"AlarmResetPeriod", (int)n, (int)1000);
        int n2 = this._AlarmResetPeriod;
        this._AlarmResetPeriod = n;
        this._postSet(6, n2, n);
    }

    public WLDFNotificationBean[] getNotifications() {
        return this._Notifications;
    }

    public String getNotificationsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getNotifications());
    }

    public boolean isNotificationsSet() {
        return this._isSet(7);
    }

    public void setNotificationsAsString(String string) {
        if (string == null || string.length() == 0) {
            WLDFNotificationBean[] wLDFNotificationBeanArray = this._Notifications;
            this._initializeProperty(7);
            this._postSet(7, wLDFNotificationBeanArray, this._Notifications);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Notifications);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, WLDFNotificationBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            WLDFWatchBeanImpl.this.addNotification((WLDFNotificationBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (WLDFNotificationBean wLDFNotificationBean : this._Notifications) {
                    if (!string2.equals(wLDFNotificationBean.getName())) continue;
                    try {
                        this.removeNotification(wLDFNotificationBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setNotifications(WLDFNotificationBean[] wLDFNotificationBeanArray) {
        wLDFNotificationBeanArray = wLDFNotificationBeanArray == null ? new WLDFNotificationBeanImpl[]{} : wLDFNotificationBeanArray;
        wLDFNotificationBeanArray = (WLDFNotificationBean[])this._getHelper()._cleanAndValidateArray((Object)wLDFNotificationBeanArray, WLDFNotificationBean.class);
        for (int i = 0; i < wLDFNotificationBeanArray.length; ++i) {
            if (wLDFNotificationBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)wLDFNotificationBeanArray[i]){

                protected Object getPropertyValue() {
                    return WLDFWatchBeanImpl.this.getNotifications();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)wLDFNotificationBeanArray[i], resolvedReference);
        }
        WLDFNotificationBean[] wLDFNotificationBeanArray2 = this._Notifications;
        this._Notifications = wLDFNotificationBeanArray;
        this._postSet(7, wLDFNotificationBeanArray2, wLDFNotificationBeanArray);
    }

    public boolean addNotification(WLDFNotificationBean wLDFNotificationBean) {
        this._getHelper()._ensureNonNull((Object)wLDFNotificationBean);
        if (!((AbstractDescriptorBean)wLDFNotificationBean).isChildProperty((DescriptorBean)this, 7)) {
            WLDFNotificationBean[] wLDFNotificationBeanArray = this._isSet(7) ? (WLDFNotificationBean[])this._getHelper()._extendArray((Object)this.getNotifications(), WLDFNotificationBean.class, (Object)wLDFNotificationBean) : new WLDFNotificationBean[]{wLDFNotificationBean};
            try {
                this.setNotifications(wLDFNotificationBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeNotification(WLDFNotificationBean wLDFNotificationBean) {
        WLDFNotificationBean[] wLDFNotificationBeanArray = this.getNotifications();
        WLDFNotificationBean[] wLDFNotificationBeanArray2 = (WLDFNotificationBean[])this._getHelper()._removeElement((Object)wLDFNotificationBeanArray, WLDFNotificationBean.class, (Object)wLDFNotificationBean);
        if (wLDFNotificationBeanArray2.length != wLDFNotificationBeanArray.length) {
            try {
                this.setNotifications(wLDFNotificationBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        WatchValidator.validateWatch(this);
        LegalChecks.checkIsSet((String)"RuleExpression", (boolean)this.isRuleExpressionSet());
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 6;
        }
        try {
            switch (n) {
                case 6: {
                    this._AlarmResetPeriod = 60000;
                    if (bl) break;
                }
                case 5: {
                    this._AlarmType = "None";
                    if (bl) break;
                }
                case 7: {
                    this._Notifications = new WLDFNotificationBean[0];
                    if (bl) break;
                }
                case 3: {
                    this._RuleExpression = null;
                    if (bl) break;
                }
                case 2: {
                    this._RuleType = "Harvester";
                    if (bl) break;
                }
                case 4: {
                    this._customizer.setSeverity("Notice");
                    if (bl) break;
                }
                case 1: {
                    this._Enabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/weblogic-diagnostics/1.0/weblogic-diagnostics.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/weblogic-diagnostics";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public static class SchemaHelper2
    extends WLDFBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 18: {
                    if (!string.equals("alarm-reset-period")) break;
                    return 6;
                }
                case 10: {
                    if (!string.equals("alarm-type")) break;
                    return 5;
                }
                case 12: {
                    if (!string.equals("notification")) break;
                    return 7;
                }
                case 15: {
                    if (!string.equals("rule-expression")) break;
                    return 3;
                }
                case 9: {
                    if (!string.equals("rule-type")) break;
                    return 2;
                }
                case 8: {
                    if (!string.equals("severity")) break;
                    return 4;
                }
                case 7: {
                    if (!string.equals("enabled")) break;
                    return 1;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 6: {
                    return "alarm-reset-period";
                }
                case 5: {
                    return "alarm-type";
                }
                case 7: {
                    return "notification";
                }
                case 3: {
                    return "rule-expression";
                }
                case 2: {
                    return "rule-type";
                }
                case 4: {
                    return "severity";
                }
                case 1: {
                    return "enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 0: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends WLDFBeanImpl.Helper {
        private WLDFWatchBeanImpl bean;

        protected Helper(WLDFWatchBeanImpl wLDFWatchBeanImpl) {
            super(wLDFWatchBeanImpl);
            this.bean = wLDFWatchBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 6: {
                    return "AlarmResetPeriod";
                }
                case 5: {
                    return "AlarmType";
                }
                case 7: {
                    return "Notifications";
                }
                case 3: {
                    return "RuleExpression";
                }
                case 2: {
                    return "RuleType";
                }
                case 4: {
                    return "Severity";
                }
                case 1: {
                    return "Enabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AlarmResetPeriod")) {
                return 6;
            }
            if (string.equals("AlarmType")) {
                return 5;
            }
            if (string.equals("Notifications")) {
                return 7;
            }
            if (string.equals("RuleExpression")) {
                return 3;
            }
            if (string.equals("RuleType")) {
                return 2;
            }
            if (string.equals("Severity")) {
                return 4;
            }
            if (string.equals("Enabled")) {
                return 1;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAlarmResetPeriodSet()) {
                    stringBuffer.append("AlarmResetPeriod");
                    stringBuffer.append(String.valueOf(this.bean.getAlarmResetPeriod()));
                }
                if (this.bean.isAlarmTypeSet()) {
                    stringBuffer.append("AlarmType");
                    stringBuffer.append(String.valueOf(this.bean.getAlarmType()));
                }
                if (this.bean.isNotificationsSet()) {
                    stringBuffer.append("Notifications");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getNotifications())));
                }
                if (this.bean.isRuleExpressionSet()) {
                    stringBuffer.append("RuleExpression");
                    stringBuffer.append(String.valueOf(this.bean.getRuleExpression()));
                }
                if (this.bean.isRuleTypeSet()) {
                    stringBuffer.append("RuleType");
                    stringBuffer.append(String.valueOf(this.bean.getRuleType()));
                }
                if (this.bean.isSeveritySet()) {
                    stringBuffer.append("Severity");
                    stringBuffer.append(String.valueOf(this.bean.getSeverity()));
                }
                if (this.bean.isEnabledSet()) {
                    stringBuffer.append("Enabled");
                    stringBuffer.append(String.valueOf(this.bean.isEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WLDFWatchBeanImpl wLDFWatchBeanImpl = (WLDFWatchBeanImpl)abstractDescriptorBean;
                this.computeDiff("AlarmResetPeriod", this.bean.getAlarmResetPeriod(), wLDFWatchBeanImpl.getAlarmResetPeriod(), true);
                this.computeDiff("AlarmType", this.bean.getAlarmType(), wLDFWatchBeanImpl.getAlarmType(), true);
                this.computeDiff("Notifications", this.bean.getNotifications(), wLDFWatchBeanImpl.getNotifications(), true);
                this.computeDiff("RuleExpression", this.bean.getRuleExpression(), wLDFWatchBeanImpl.getRuleExpression(), true);
                this.computeDiff("RuleType", this.bean.getRuleType(), wLDFWatchBeanImpl.getRuleType(), true);
                this.computeDiff("Severity", this.bean.getSeverity(), wLDFWatchBeanImpl.getSeverity(), true);
                this.computeDiff("Enabled", this.bean.isEnabled(), wLDFWatchBeanImpl.isEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WLDFWatchBeanImpl wLDFWatchBeanImpl = (WLDFWatchBeanImpl)beanUpdateEvent.getSourceBean();
                WLDFWatchBeanImpl wLDFWatchBeanImpl2 = (WLDFWatchBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AlarmResetPeriod")) {
                    wLDFWatchBeanImpl.setAlarmResetPeriod(wLDFWatchBeanImpl2.getAlarmResetPeriod());
                    wLDFWatchBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 6);
                } else if (string.equals("AlarmType")) {
                    wLDFWatchBeanImpl.setAlarmType(wLDFWatchBeanImpl2.getAlarmType());
                    wLDFWatchBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 5);
                } else if (string.equals("Notifications")) {
                    wLDFWatchBeanImpl.setNotificationsAsString(wLDFWatchBeanImpl2.getNotificationsAsString());
                    wLDFWatchBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("RuleExpression")) {
                    wLDFWatchBeanImpl.setRuleExpression(wLDFWatchBeanImpl2.getRuleExpression());
                    wLDFWatchBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                } else if (string.equals("RuleType")) {
                    wLDFWatchBeanImpl.setRuleType(wLDFWatchBeanImpl2.getRuleType());
                    wLDFWatchBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("Severity")) {
                    wLDFWatchBeanImpl.setSeverity(wLDFWatchBeanImpl2.getSeverity());
                    wLDFWatchBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 4);
                } else if (string.equals("Enabled")) {
                    wLDFWatchBeanImpl.setEnabled(wLDFWatchBeanImpl2.isEnabled());
                    wLDFWatchBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 1);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WLDFWatchBeanImpl wLDFWatchBeanImpl = (WLDFWatchBeanImpl)abstractDescriptorBean;
                super.finishCopy(wLDFWatchBeanImpl, bl, list);
                if ((list == null || !list.contains("AlarmResetPeriod")) && this.bean.isAlarmResetPeriodSet()) {
                    wLDFWatchBeanImpl.setAlarmResetPeriod(this.bean.getAlarmResetPeriod());
                }
                if ((list == null || !list.contains("AlarmType")) && this.bean.isAlarmTypeSet()) {
                    wLDFWatchBeanImpl.setAlarmType(this.bean.getAlarmType());
                }
                if ((list == null || !list.contains("Notifications")) && this.bean.isNotificationsSet()) {
                    wLDFWatchBeanImpl._unSet(wLDFWatchBeanImpl, 7);
                    wLDFWatchBeanImpl.setNotificationsAsString(this.bean.getNotificationsAsString());
                }
                if ((list == null || !list.contains("RuleExpression")) && this.bean.isRuleExpressionSet()) {
                    wLDFWatchBeanImpl.setRuleExpression(this.bean.getRuleExpression());
                }
                if ((list == null || !list.contains("RuleType")) && this.bean.isRuleTypeSet()) {
                    wLDFWatchBeanImpl.setRuleType(this.bean.getRuleType());
                }
                if ((list == null || !list.contains("Severity")) && this.bean.isSeveritySet()) {
                    wLDFWatchBeanImpl.setSeverity(this.bean.getSeverity());
                }
                if ((list == null || !list.contains("Enabled")) && this.bean.isEnabledSet()) {
                    wLDFWatchBeanImpl.setEnabled(this.bean.isEnabled());
                }
                return wLDFWatchBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getNotifications(), clazz, object);
        }
    }
}

