/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.descriptor;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.diagnostics.descriptor.WLDFBean;
import weblogic.diagnostics.descriptor.WLDFBeanImpl;
import weblogic.diagnostics.descriptor.WLDFImageNotificationBean;
import weblogic.diagnostics.descriptor.WLDFImageNotificationBeanImpl;
import weblogic.diagnostics.descriptor.WLDFJMSNotificationBean;
import weblogic.diagnostics.descriptor.WLDFJMSNotificationBeanImpl;
import weblogic.diagnostics.descriptor.WLDFJMXNotificationBean;
import weblogic.diagnostics.descriptor.WLDFJMXNotificationBeanImpl;
import weblogic.diagnostics.descriptor.WLDFNotificationBean;
import weblogic.diagnostics.descriptor.WLDFNotificationBeanImpl;
import weblogic.diagnostics.descriptor.WLDFSMTPNotificationBean;
import weblogic.diagnostics.descriptor.WLDFSMTPNotificationBeanImpl;
import weblogic.diagnostics.descriptor.WLDFSNMPNotificationBean;
import weblogic.diagnostics.descriptor.WLDFSNMPNotificationBeanImpl;
import weblogic.diagnostics.descriptor.WLDFWatchBean;
import weblogic.diagnostics.descriptor.WLDFWatchBeanImpl;
import weblogic.diagnostics.descriptor.WLDFWatchNotificationBean;
import weblogic.diagnostics.descriptor.WLDFWatchNotificationCustomizer;
import weblogic.diagnostics.watch.WatchValidator;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class WLDFWatchNotificationBeanImpl
extends WLDFBeanImpl
implements WLDFWatchNotificationBean,
Serializable {
    private boolean _Enabled;
    private WLDFImageNotificationBean[] _ImageNotifications;
    private WLDFJMSNotificationBean[] _JMSNotifications;
    private WLDFJMXNotificationBean[] _JMXNotifications;
    private String _LogWatchSeverity;
    private WLDFNotificationBean[] _Notifications;
    private WLDFSMTPNotificationBean[] _SMTPNotifications;
    private WLDFSNMPNotificationBean[] _SNMPNotifications;
    private String _Severity;
    private WLDFWatchBean[] _Watches;
    private WLDFWatchNotificationCustomizer _customizer;
    private static SchemaHelper2 _schemaHelper;

    public WLDFWatchNotificationBeanImpl() {
        try {
            this._customizer = new WLDFWatchNotificationCustomizer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public WLDFWatchNotificationBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new WLDFWatchNotificationCustomizer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public boolean isEnabled() {
        return this._Enabled;
    }

    public boolean isEnabledSet() {
        return this._isSet(1);
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this._Enabled;
        this._Enabled = bl;
        this._postSet(1, bl2, bl);
    }

    public String getSeverity() {
        return this._Severity;
    }

    public boolean isSeveritySet() {
        return this._isSet(2);
    }

    public void setSeverity(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Info", "Warning", "Error", "Notice", "Critical", "Alert", "Emergency"};
        string = LegalChecks.checkInEnum((String)"Severity", (String)string, (String[])stringArray);
        String string2 = this._Severity;
        this._Severity = string;
        this._postSet(2, string2, string);
    }

    public String getLogWatchSeverity() {
        return this._LogWatchSeverity;
    }

    public boolean isLogWatchSeveritySet() {
        return this._isSet(3);
    }

    public void setLogWatchSeverity(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Info", "Warning", "Error", "Notice", "Critical", "Alert", "Emergency"};
        string = LegalChecks.checkInEnum((String)"LogWatchSeverity", (String)string, (String[])stringArray);
        String string2 = this._LogWatchSeverity;
        this._LogWatchSeverity = string;
        this._postSet(3, string2, string);
    }

    public void addWatch(WLDFWatchBean wLDFWatchBean) {
        this._getHelper()._ensureNonNull((Object)wLDFWatchBean);
        if (!((AbstractDescriptorBean)wLDFWatchBean).isChildProperty((DescriptorBean)this, 4)) {
            WLDFWatchBean[] wLDFWatchBeanArray = this._isSet(4) ? (WLDFWatchBean[])this._getHelper()._extendArray((Object)this.getWatches(), WLDFWatchBean.class, (Object)wLDFWatchBean) : new WLDFWatchBean[]{wLDFWatchBean};
            try {
                this.setWatches(wLDFWatchBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFWatchBean[] getWatches() {
        return this._Watches;
    }

    public boolean isWatchesSet() {
        return this._isSet(4);
    }

    public void removeWatch(WLDFWatchBean wLDFWatchBean) {
        this.destroyWatch(wLDFWatchBean);
    }

    public void setWatches(WLDFWatchBean[] wLDFWatchBeanArray) throws InvalidAttributeValueException {
        wLDFWatchBeanArray = wLDFWatchBeanArray == null ? new WLDFWatchBeanImpl[]{} : wLDFWatchBeanArray;
        for (int i = 0; i < wLDFWatchBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFWatchBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, (DescriptorBean)this, 4)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        WLDFWatchBean[] wLDFWatchBeanArray2 = this._Watches;
        this._Watches = wLDFWatchBeanArray;
        this._postSet(4, wLDFWatchBeanArray2, wLDFWatchBeanArray);
    }

    public WLDFWatchBean createWatch(String string) {
        WLDFWatchBeanImpl wLDFWatchBeanImpl = new WLDFWatchBeanImpl((DescriptorBean)this, -1);
        try {
            wLDFWatchBeanImpl.setName(string);
            this.addWatch(wLDFWatchBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return wLDFWatchBeanImpl;
    }

    public void destroyWatch(WLDFWatchBean wLDFWatchBean) {
        block8: {
            try {
                this._checkIsPotentialChild(wLDFWatchBean, 4);
                WLDFWatchBean[] wLDFWatchBeanArray = this.getWatches();
                WLDFWatchBean[] wLDFWatchBeanArray2 = (WLDFWatchBean[])this._getHelper()._removeElement((Object)wLDFWatchBeanArray, WLDFWatchBean.class, (Object)wLDFWatchBean);
                if (wLDFWatchBeanArray.length == wLDFWatchBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)wLDFWatchBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFWatchBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setWatches(wLDFWatchBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void addNotification(WLDFNotificationBean wLDFNotificationBean) {
        this._getHelper()._ensureNonNull((Object)wLDFNotificationBean);
        if (!((AbstractDescriptorBean)wLDFNotificationBean).isChildProperty((DescriptorBean)this, 5)) {
            WLDFNotificationBean[] wLDFNotificationBeanArray = (WLDFNotificationBean[])this._getHelper()._extendArray((Object)this.getNotifications(), WLDFNotificationBean.class, (Object)wLDFNotificationBean);
            try {
                this.setNotifications(wLDFNotificationBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFNotificationBean[] getNotifications() {
        return this._customizer.getNotifications();
    }

    public boolean isNotificationsSet() {
        return this._isSet(5);
    }

    public void removeNotification(WLDFNotificationBean wLDFNotificationBean) {
        WLDFNotificationBean[] wLDFNotificationBeanArray = this.getNotifications();
        WLDFNotificationBean[] wLDFNotificationBeanArray2 = (WLDFNotificationBean[])this._getHelper()._removeElement((Object)wLDFNotificationBeanArray, WLDFNotificationBean.class, (Object)wLDFNotificationBean);
        if (wLDFNotificationBeanArray2.length != wLDFNotificationBeanArray.length) {
            try {
                this.setNotifications(wLDFNotificationBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setNotifications(WLDFNotificationBean[] wLDFNotificationBeanArray) throws InvalidAttributeValueException {
        wLDFNotificationBeanArray = wLDFNotificationBeanArray == null ? new WLDFNotificationBeanImpl[]{} : wLDFNotificationBeanArray;
        this._Notifications = wLDFNotificationBeanArray;
    }

    public WLDFNotificationBean lookupNotification(String string) {
        return this._customizer.lookupNotification(string);
    }

    public void addImageNotification(WLDFImageNotificationBean wLDFImageNotificationBean) {
        this._getHelper()._ensureNonNull((Object)wLDFImageNotificationBean);
        if (!((AbstractDescriptorBean)wLDFImageNotificationBean).isChildProperty((DescriptorBean)this, 6)) {
            WLDFImageNotificationBean[] wLDFImageNotificationBeanArray = this._isSet(6) ? (WLDFImageNotificationBean[])this._getHelper()._extendArray((Object)this.getImageNotifications(), WLDFImageNotificationBean.class, (Object)wLDFImageNotificationBean) : new WLDFImageNotificationBean[]{wLDFImageNotificationBean};
            try {
                this.setImageNotifications(wLDFImageNotificationBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFImageNotificationBean[] getImageNotifications() {
        return this._ImageNotifications;
    }

    public boolean isImageNotificationsSet() {
        return this._isSet(6);
    }

    public void removeImageNotification(WLDFImageNotificationBean wLDFImageNotificationBean) {
        this.destroyImageNotification(wLDFImageNotificationBean);
    }

    public void setImageNotifications(WLDFImageNotificationBean[] wLDFImageNotificationBeanArray) throws InvalidAttributeValueException {
        wLDFImageNotificationBeanArray = wLDFImageNotificationBeanArray == null ? new WLDFImageNotificationBeanImpl[]{} : wLDFImageNotificationBeanArray;
        for (int i = 0; i < wLDFImageNotificationBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFImageNotificationBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, (DescriptorBean)this, 6)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        WLDFImageNotificationBean[] wLDFImageNotificationBeanArray2 = this._ImageNotifications;
        this._ImageNotifications = wLDFImageNotificationBeanArray;
        this._postSet(6, wLDFImageNotificationBeanArray2, wLDFImageNotificationBeanArray);
    }

    public WLDFImageNotificationBean createImageNotification(String string) {
        WLDFImageNotificationBeanImpl wLDFImageNotificationBeanImpl = new WLDFImageNotificationBeanImpl((DescriptorBean)this, -1);
        try {
            wLDFImageNotificationBeanImpl.setName(string);
            this.addImageNotification(wLDFImageNotificationBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return wLDFImageNotificationBeanImpl;
    }

    public void destroyImageNotification(WLDFImageNotificationBean wLDFImageNotificationBean) {
        block8: {
            try {
                this._checkIsPotentialChild(wLDFImageNotificationBean, 6);
                WLDFImageNotificationBean[] wLDFImageNotificationBeanArray = this.getImageNotifications();
                WLDFImageNotificationBean[] wLDFImageNotificationBeanArray2 = (WLDFImageNotificationBean[])this._getHelper()._removeElement((Object)wLDFImageNotificationBeanArray, WLDFImageNotificationBean.class, (Object)wLDFImageNotificationBean);
                if (wLDFImageNotificationBeanArray.length == wLDFImageNotificationBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)wLDFImageNotificationBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFImageNotificationBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setImageNotifications(wLDFImageNotificationBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFImageNotificationBean lookupImageNotification(String string) {
        for (WLDFImageNotificationBeanImpl wLDFImageNotificationBeanImpl : Arrays.asList((Object[])this._ImageNotifications)) {
            String string2 = string;
            if (!wLDFImageNotificationBeanImpl.getName().equals(string2)) continue;
            return wLDFImageNotificationBeanImpl;
        }
        return null;
    }

    public void addJMSNotification(WLDFJMSNotificationBean wLDFJMSNotificationBean) {
        this._getHelper()._ensureNonNull((Object)wLDFJMSNotificationBean);
        if (!((AbstractDescriptorBean)wLDFJMSNotificationBean).isChildProperty((DescriptorBean)this, 7)) {
            WLDFJMSNotificationBean[] wLDFJMSNotificationBeanArray = this._isSet(7) ? (WLDFJMSNotificationBean[])this._getHelper()._extendArray((Object)this.getJMSNotifications(), WLDFJMSNotificationBean.class, (Object)wLDFJMSNotificationBean) : new WLDFJMSNotificationBean[]{wLDFJMSNotificationBean};
            try {
                this.setJMSNotifications(wLDFJMSNotificationBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFJMSNotificationBean[] getJMSNotifications() {
        return this._JMSNotifications;
    }

    public boolean isJMSNotificationsSet() {
        return this._isSet(7);
    }

    public void removeJMSNotification(WLDFJMSNotificationBean wLDFJMSNotificationBean) {
        this.destroyJMSNotification(wLDFJMSNotificationBean);
    }

    public void setJMSNotifications(WLDFJMSNotificationBean[] wLDFJMSNotificationBeanArray) throws InvalidAttributeValueException {
        wLDFJMSNotificationBeanArray = wLDFJMSNotificationBeanArray == null ? new WLDFJMSNotificationBeanImpl[]{} : wLDFJMSNotificationBeanArray;
        for (int i = 0; i < wLDFJMSNotificationBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFJMSNotificationBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, (DescriptorBean)this, 7)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        WLDFJMSNotificationBean[] wLDFJMSNotificationBeanArray2 = this._JMSNotifications;
        this._JMSNotifications = wLDFJMSNotificationBeanArray;
        this._postSet(7, wLDFJMSNotificationBeanArray2, wLDFJMSNotificationBeanArray);
    }

    public WLDFJMSNotificationBean createJMSNotification(String string) {
        WLDFJMSNotificationBeanImpl wLDFJMSNotificationBeanImpl = new WLDFJMSNotificationBeanImpl((DescriptorBean)this, -1);
        try {
            wLDFJMSNotificationBeanImpl.setName(string);
            this.addJMSNotification(wLDFJMSNotificationBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return wLDFJMSNotificationBeanImpl;
    }

    public void destroyJMSNotification(WLDFJMSNotificationBean wLDFJMSNotificationBean) {
        block8: {
            try {
                this._checkIsPotentialChild(wLDFJMSNotificationBean, 7);
                WLDFJMSNotificationBean[] wLDFJMSNotificationBeanArray = this.getJMSNotifications();
                WLDFJMSNotificationBean[] wLDFJMSNotificationBeanArray2 = (WLDFJMSNotificationBean[])this._getHelper()._removeElement((Object)wLDFJMSNotificationBeanArray, WLDFJMSNotificationBean.class, (Object)wLDFJMSNotificationBean);
                if (wLDFJMSNotificationBeanArray.length == wLDFJMSNotificationBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)wLDFJMSNotificationBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFJMSNotificationBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setJMSNotifications(wLDFJMSNotificationBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFJMSNotificationBean lookupJMSNotification(String string) {
        for (WLDFJMSNotificationBeanImpl wLDFJMSNotificationBeanImpl : Arrays.asList((Object[])this._JMSNotifications)) {
            String string2 = string;
            if (!wLDFJMSNotificationBeanImpl.getName().equals(string2)) continue;
            return wLDFJMSNotificationBeanImpl;
        }
        return null;
    }

    public void addJMXNotification(WLDFJMXNotificationBean wLDFJMXNotificationBean) {
        this._getHelper()._ensureNonNull((Object)wLDFJMXNotificationBean);
        if (!((AbstractDescriptorBean)wLDFJMXNotificationBean).isChildProperty((DescriptorBean)this, 8)) {
            WLDFJMXNotificationBean[] wLDFJMXNotificationBeanArray = this._isSet(8) ? (WLDFJMXNotificationBean[])this._getHelper()._extendArray((Object)this.getJMXNotifications(), WLDFJMXNotificationBean.class, (Object)wLDFJMXNotificationBean) : new WLDFJMXNotificationBean[]{wLDFJMXNotificationBean};
            try {
                this.setJMXNotifications(wLDFJMXNotificationBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFJMXNotificationBean[] getJMXNotifications() {
        return this._JMXNotifications;
    }

    public boolean isJMXNotificationsSet() {
        return this._isSet(8);
    }

    public void removeJMXNotification(WLDFJMXNotificationBean wLDFJMXNotificationBean) {
        this.destroyJMXNotification(wLDFJMXNotificationBean);
    }

    public void setJMXNotifications(WLDFJMXNotificationBean[] wLDFJMXNotificationBeanArray) throws InvalidAttributeValueException {
        wLDFJMXNotificationBeanArray = wLDFJMXNotificationBeanArray == null ? new WLDFJMXNotificationBeanImpl[]{} : wLDFJMXNotificationBeanArray;
        for (int i = 0; i < wLDFJMXNotificationBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFJMXNotificationBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, (DescriptorBean)this, 8)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        WLDFJMXNotificationBean[] wLDFJMXNotificationBeanArray2 = this._JMXNotifications;
        this._JMXNotifications = wLDFJMXNotificationBeanArray;
        this._postSet(8, wLDFJMXNotificationBeanArray2, wLDFJMXNotificationBeanArray);
    }

    public WLDFJMXNotificationBean createJMXNotification(String string) {
        WLDFJMXNotificationBeanImpl wLDFJMXNotificationBeanImpl = new WLDFJMXNotificationBeanImpl((DescriptorBean)this, -1);
        try {
            wLDFJMXNotificationBeanImpl.setName(string);
            this.addJMXNotification(wLDFJMXNotificationBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return wLDFJMXNotificationBeanImpl;
    }

    public void destroyJMXNotification(WLDFJMXNotificationBean wLDFJMXNotificationBean) {
        block8: {
            try {
                this._checkIsPotentialChild(wLDFJMXNotificationBean, 8);
                WLDFJMXNotificationBean[] wLDFJMXNotificationBeanArray = this.getJMXNotifications();
                WLDFJMXNotificationBean[] wLDFJMXNotificationBeanArray2 = (WLDFJMXNotificationBean[])this._getHelper()._removeElement((Object)wLDFJMXNotificationBeanArray, WLDFJMXNotificationBean.class, (Object)wLDFJMXNotificationBean);
                if (wLDFJMXNotificationBeanArray.length == wLDFJMXNotificationBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)wLDFJMXNotificationBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFJMXNotificationBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setJMXNotifications(wLDFJMXNotificationBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFJMXNotificationBean lookupJMXNotification(String string) {
        for (WLDFJMXNotificationBeanImpl wLDFJMXNotificationBeanImpl : Arrays.asList((Object[])this._JMXNotifications)) {
            String string2 = string;
            if (!wLDFJMXNotificationBeanImpl.getName().equals(string2)) continue;
            return wLDFJMXNotificationBeanImpl;
        }
        return null;
    }

    public void addSMTPNotification(WLDFSMTPNotificationBean wLDFSMTPNotificationBean) {
        this._getHelper()._ensureNonNull((Object)wLDFSMTPNotificationBean);
        if (!((AbstractDescriptorBean)wLDFSMTPNotificationBean).isChildProperty((DescriptorBean)this, 9)) {
            WLDFSMTPNotificationBean[] wLDFSMTPNotificationBeanArray = this._isSet(9) ? (WLDFSMTPNotificationBean[])this._getHelper()._extendArray((Object)this.getSMTPNotifications(), WLDFSMTPNotificationBean.class, (Object)wLDFSMTPNotificationBean) : new WLDFSMTPNotificationBean[]{wLDFSMTPNotificationBean};
            try {
                this.setSMTPNotifications(wLDFSMTPNotificationBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFSMTPNotificationBean[] getSMTPNotifications() {
        return this._SMTPNotifications;
    }

    public boolean isSMTPNotificationsSet() {
        return this._isSet(9);
    }

    public void removeSMTPNotification(WLDFSMTPNotificationBean wLDFSMTPNotificationBean) {
        this.destroySMTPNotification(wLDFSMTPNotificationBean);
    }

    public void setSMTPNotifications(WLDFSMTPNotificationBean[] wLDFSMTPNotificationBeanArray) throws InvalidAttributeValueException {
        wLDFSMTPNotificationBeanArray = wLDFSMTPNotificationBeanArray == null ? new WLDFSMTPNotificationBeanImpl[]{} : wLDFSMTPNotificationBeanArray;
        for (int i = 0; i < wLDFSMTPNotificationBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFSMTPNotificationBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, (DescriptorBean)this, 9)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        WLDFSMTPNotificationBean[] wLDFSMTPNotificationBeanArray2 = this._SMTPNotifications;
        this._SMTPNotifications = wLDFSMTPNotificationBeanArray;
        this._postSet(9, wLDFSMTPNotificationBeanArray2, wLDFSMTPNotificationBeanArray);
    }

    public WLDFSMTPNotificationBean createSMTPNotification(String string) {
        WLDFSMTPNotificationBeanImpl wLDFSMTPNotificationBeanImpl = new WLDFSMTPNotificationBeanImpl((DescriptorBean)this, -1);
        try {
            wLDFSMTPNotificationBeanImpl.setName(string);
            this.addSMTPNotification(wLDFSMTPNotificationBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return wLDFSMTPNotificationBeanImpl;
    }

    public void destroySMTPNotification(WLDFSMTPNotificationBean wLDFSMTPNotificationBean) {
        block8: {
            try {
                this._checkIsPotentialChild(wLDFSMTPNotificationBean, 9);
                WLDFSMTPNotificationBean[] wLDFSMTPNotificationBeanArray = this.getSMTPNotifications();
                WLDFSMTPNotificationBean[] wLDFSMTPNotificationBeanArray2 = (WLDFSMTPNotificationBean[])this._getHelper()._removeElement((Object)wLDFSMTPNotificationBeanArray, WLDFSMTPNotificationBean.class, (Object)wLDFSMTPNotificationBean);
                if (wLDFSMTPNotificationBeanArray.length == wLDFSMTPNotificationBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)wLDFSMTPNotificationBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFSMTPNotificationBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setSMTPNotifications(wLDFSMTPNotificationBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFSMTPNotificationBean lookupSMTPNotification(String string) {
        for (WLDFSMTPNotificationBeanImpl wLDFSMTPNotificationBeanImpl : Arrays.asList((Object[])this._SMTPNotifications)) {
            String string2 = string;
            if (!wLDFSMTPNotificationBeanImpl.getName().equals(string2)) continue;
            return wLDFSMTPNotificationBeanImpl;
        }
        return null;
    }

    public void addSNMPNotification(WLDFSNMPNotificationBean wLDFSNMPNotificationBean) {
        this._getHelper()._ensureNonNull((Object)wLDFSNMPNotificationBean);
        if (!((AbstractDescriptorBean)wLDFSNMPNotificationBean).isChildProperty((DescriptorBean)this, 10)) {
            WLDFSNMPNotificationBean[] wLDFSNMPNotificationBeanArray = this._isSet(10) ? (WLDFSNMPNotificationBean[])this._getHelper()._extendArray((Object)this.getSNMPNotifications(), WLDFSNMPNotificationBean.class, (Object)wLDFSNMPNotificationBean) : new WLDFSNMPNotificationBean[]{wLDFSNMPNotificationBean};
            try {
                this.setSNMPNotifications(wLDFSNMPNotificationBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFSNMPNotificationBean[] getSNMPNotifications() {
        return this._SNMPNotifications;
    }

    public boolean isSNMPNotificationsSet() {
        return this._isSet(10);
    }

    public void removeSNMPNotification(WLDFSNMPNotificationBean wLDFSNMPNotificationBean) {
        this.destroySNMPNotification(wLDFSNMPNotificationBean);
    }

    public void setSNMPNotifications(WLDFSNMPNotificationBean[] wLDFSNMPNotificationBeanArray) throws InvalidAttributeValueException {
        wLDFSNMPNotificationBeanArray = wLDFSNMPNotificationBeanArray == null ? new WLDFSNMPNotificationBeanImpl[]{} : wLDFSNMPNotificationBeanArray;
        for (int i = 0; i < wLDFSNMPNotificationBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFSNMPNotificationBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, (DescriptorBean)this, 10)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, true);
            this._postCreate(abstractDescriptorBean);
        }
        WLDFSNMPNotificationBean[] wLDFSNMPNotificationBeanArray2 = this._SNMPNotifications;
        this._SNMPNotifications = wLDFSNMPNotificationBeanArray;
        this._postSet(10, wLDFSNMPNotificationBeanArray2, wLDFSNMPNotificationBeanArray);
    }

    public WLDFSNMPNotificationBean createSNMPNotification(String string) {
        WLDFSNMPNotificationBeanImpl wLDFSNMPNotificationBeanImpl = new WLDFSNMPNotificationBeanImpl((DescriptorBean)this, -1);
        try {
            wLDFSNMPNotificationBeanImpl.setName(string);
            this.addSNMPNotification(wLDFSNMPNotificationBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return wLDFSNMPNotificationBeanImpl;
    }

    public void destroySNMPNotification(WLDFSNMPNotificationBean wLDFSNMPNotificationBean) {
        block8: {
            try {
                this._checkIsPotentialChild(wLDFSNMPNotificationBean, 10);
                WLDFSNMPNotificationBean[] wLDFSNMPNotificationBeanArray = this.getSNMPNotifications();
                WLDFSNMPNotificationBean[] wLDFSNMPNotificationBeanArray2 = (WLDFSNMPNotificationBean[])this._getHelper()._removeElement((Object)wLDFSNMPNotificationBeanArray, WLDFSNMPNotificationBean.class, (Object)wLDFSNMPNotificationBean);
                if (wLDFSNMPNotificationBeanArray.length == wLDFSNMPNotificationBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)wLDFSNMPNotificationBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFSNMPNotificationBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setSNMPNotifications(wLDFSNMPNotificationBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFSNMPNotificationBean lookupSNMPNotification(String string) {
        for (WLDFSNMPNotificationBeanImpl wLDFSNMPNotificationBeanImpl : Arrays.asList((Object[])this._SNMPNotifications)) {
            String string2 = string;
            if (!wLDFSNMPNotificationBeanImpl.getName().equals(string2)) continue;
            return wLDFSNMPNotificationBeanImpl;
        }
        return null;
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        WatchValidator.validateWatchNotificationBean(this);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 6;
        }
        try {
            switch (n) {
                case 6: {
                    this._ImageNotifications = new WLDFImageNotificationBean[0];
                    if (bl) break;
                }
                case 7: {
                    this._JMSNotifications = new WLDFJMSNotificationBean[0];
                    if (bl) break;
                }
                case 8: {
                    this._JMXNotifications = new WLDFJMXNotificationBean[0];
                    if (bl) break;
                }
                case 3: {
                    this._LogWatchSeverity = "Warning";
                    if (bl) break;
                }
                case 5: {
                    this._Notifications = new WLDFNotificationBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._SMTPNotifications = new WLDFSMTPNotificationBean[0];
                    if (bl) break;
                }
                case 10: {
                    this._SNMPNotifications = new WLDFSNMPNotificationBean[0];
                    if (bl) break;
                }
                case 2: {
                    this._Severity = "Notice";
                    if (bl) break;
                }
                case 4: {
                    this._Watches = new WLDFWatchBean[0];
                    if (bl) break;
                }
                case 1: {
                    this._Enabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/weblogic-diagnostics/1.0/weblogic-diagnostics.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/weblogic-diagnostics";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public static class SchemaHelper2
    extends WLDFBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 18: {
                    if (string.equals("image-notification")) {
                        return 6;
                    }
                    if (!string.equals("log-watch-severity")) break;
                    return 3;
                }
                case 16: {
                    if (string.equals("jms-notification")) {
                        return 7;
                    }
                    if (!string.equals("jmx-notification")) break;
                    return 8;
                }
                case 12: {
                    if (!string.equals("notification")) break;
                    return 5;
                }
                case 17: {
                    if (string.equals("smtp-notification")) {
                        return 9;
                    }
                    if (!string.equals("snmp-notification")) break;
                    return 10;
                }
                case 8: {
                    if (!string.equals("severity")) break;
                    return 2;
                }
                case 6: {
                    if (!string.equals("watche")) break;
                    return 4;
                }
                case 7: {
                    if (!string.equals("enabled")) break;
                    return 1;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 6: {
                    return new WLDFImageNotificationBeanImpl.SchemaHelper2();
                }
                case 7: {
                    return new WLDFJMSNotificationBeanImpl.SchemaHelper2();
                }
                case 8: {
                    return new WLDFJMXNotificationBeanImpl.SchemaHelper2();
                }
                case 9: {
                    return new WLDFSMTPNotificationBeanImpl.SchemaHelper2();
                }
                case 10: {
                    return new WLDFSNMPNotificationBeanImpl.SchemaHelper2();
                }
                case 4: {
                    return new WLDFWatchBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 6: {
                    return "image-notification";
                }
                case 7: {
                    return "jms-notification";
                }
                case 8: {
                    return "jmx-notification";
                }
                case 3: {
                    return "log-watch-severity";
                }
                case 5: {
                    return "notification";
                }
                case 9: {
                    return "smtp-notification";
                }
                case 10: {
                    return "snmp-notification";
                }
                case 2: {
                    return "severity";
                }
                case 4: {
                    return "watche";
                }
                case 1: {
                    return "enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 6: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 5: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 6: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 0: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends WLDFBeanImpl.Helper {
        private WLDFWatchNotificationBeanImpl bean;

        protected Helper(WLDFWatchNotificationBeanImpl wLDFWatchNotificationBeanImpl) {
            super(wLDFWatchNotificationBeanImpl);
            this.bean = wLDFWatchNotificationBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 6: {
                    return "ImageNotifications";
                }
                case 7: {
                    return "JMSNotifications";
                }
                case 8: {
                    return "JMXNotifications";
                }
                case 3: {
                    return "LogWatchSeverity";
                }
                case 5: {
                    return "Notifications";
                }
                case 9: {
                    return "SMTPNotifications";
                }
                case 10: {
                    return "SNMPNotifications";
                }
                case 2: {
                    return "Severity";
                }
                case 4: {
                    return "Watches";
                }
                case 1: {
                    return "Enabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ImageNotifications")) {
                return 6;
            }
            if (string.equals("JMSNotifications")) {
                return 7;
            }
            if (string.equals("JMXNotifications")) {
                return 8;
            }
            if (string.equals("LogWatchSeverity")) {
                return 3;
            }
            if (string.equals("Notifications")) {
                return 5;
            }
            if (string.equals("SMTPNotifications")) {
                return 9;
            }
            if (string.equals("SNMPNotifications")) {
                return 10;
            }
            if (string.equals("Severity")) {
                return 2;
            }
            if (string.equals("Watches")) {
                return 4;
            }
            if (string.equals("Enabled")) {
                return 1;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getImageNotifications()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getJMSNotifications()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getJMXNotifications()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getSMTPNotifications()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getSNMPNotifications()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getWatches()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                l2 = 0L;
                for (n = 0; n < this.bean.getImageNotifications().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getImageNotifications()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getJMSNotifications().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getJMSNotifications()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getJMXNotifications().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getJMXNotifications()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isLogWatchSeveritySet()) {
                    stringBuffer.append("LogWatchSeverity");
                    stringBuffer.append(String.valueOf(this.bean.getLogWatchSeverity()));
                }
                if (this.bean.isNotificationsSet()) {
                    stringBuffer.append("Notifications");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getNotifications())));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getSMTPNotifications().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getSMTPNotifications()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getSNMPNotifications().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getSNMPNotifications()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isSeveritySet()) {
                    stringBuffer.append("Severity");
                    stringBuffer.append(String.valueOf(this.bean.getSeverity()));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getWatches().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getWatches()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isEnabledSet()) {
                    stringBuffer.append("Enabled");
                    stringBuffer.append(String.valueOf(this.bean.isEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WLDFWatchNotificationBeanImpl wLDFWatchNotificationBeanImpl = (WLDFWatchNotificationBeanImpl)abstractDescriptorBean;
                this.computeChildDiff("ImageNotifications", this.bean.getImageNotifications(), wLDFWatchNotificationBeanImpl.getImageNotifications(), true);
                this.computeChildDiff("JMSNotifications", this.bean.getJMSNotifications(), wLDFWatchNotificationBeanImpl.getJMSNotifications(), true);
                this.computeChildDiff("JMXNotifications", this.bean.getJMXNotifications(), wLDFWatchNotificationBeanImpl.getJMXNotifications(), true);
                this.computeDiff("LogWatchSeverity", this.bean.getLogWatchSeverity(), wLDFWatchNotificationBeanImpl.getLogWatchSeverity(), true);
                this.computeChildDiff("SMTPNotifications", this.bean.getSMTPNotifications(), wLDFWatchNotificationBeanImpl.getSMTPNotifications(), true);
                this.computeChildDiff("SNMPNotifications", this.bean.getSNMPNotifications(), wLDFWatchNotificationBeanImpl.getSNMPNotifications(), true);
                this.computeDiff("Severity", this.bean.getSeverity(), wLDFWatchNotificationBeanImpl.getSeverity(), true);
                this.computeChildDiff("Watches", this.bean.getWatches(), wLDFWatchNotificationBeanImpl.getWatches(), true);
                this.computeDiff("Enabled", this.bean.isEnabled(), wLDFWatchNotificationBeanImpl.isEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WLDFWatchNotificationBeanImpl wLDFWatchNotificationBeanImpl = (WLDFWatchNotificationBeanImpl)beanUpdateEvent.getSourceBean();
                WLDFWatchNotificationBeanImpl wLDFWatchNotificationBeanImpl2 = (WLDFWatchNotificationBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ImageNotifications")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        wLDFWatchNotificationBeanImpl.addImageNotification((WLDFImageNotificationBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        wLDFWatchNotificationBeanImpl.removeImageNotification((WLDFImageNotificationBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (wLDFWatchNotificationBeanImpl.getImageNotifications() == null || wLDFWatchNotificationBeanImpl.getImageNotifications().length == 0) {
                        wLDFWatchNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 6);
                    }
                } else if (string.equals("JMSNotifications")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        wLDFWatchNotificationBeanImpl.addJMSNotification((WLDFJMSNotificationBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        wLDFWatchNotificationBeanImpl.removeJMSNotification((WLDFJMSNotificationBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (wLDFWatchNotificationBeanImpl.getJMSNotifications() == null || wLDFWatchNotificationBeanImpl.getJMSNotifications().length == 0) {
                        wLDFWatchNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    }
                } else if (string.equals("JMXNotifications")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        wLDFWatchNotificationBeanImpl.addJMXNotification((WLDFJMXNotificationBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        wLDFWatchNotificationBeanImpl.removeJMXNotification((WLDFJMXNotificationBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (wLDFWatchNotificationBeanImpl.getJMXNotifications() == null || wLDFWatchNotificationBeanImpl.getJMXNotifications().length == 0) {
                        wLDFWatchNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    }
                } else if (string.equals("LogWatchSeverity")) {
                    wLDFWatchNotificationBeanImpl.setLogWatchSeverity(wLDFWatchNotificationBeanImpl2.getLogWatchSeverity());
                    wLDFWatchNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                } else if (!string.equals("Notifications")) {
                    if (string.equals("SMTPNotifications")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                            wLDFWatchNotificationBeanImpl.addSMTPNotification((WLDFSMTPNotificationBean)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            wLDFWatchNotificationBeanImpl.removeSMTPNotification((WLDFSMTPNotificationBean)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (wLDFWatchNotificationBeanImpl.getSMTPNotifications() == null || wLDFWatchNotificationBeanImpl.getSMTPNotifications().length == 0) {
                            wLDFWatchNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                        }
                    } else if (string.equals("SNMPNotifications")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                            wLDFWatchNotificationBeanImpl.addSNMPNotification((WLDFSNMPNotificationBean)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            wLDFWatchNotificationBeanImpl.removeSNMPNotification((WLDFSNMPNotificationBean)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (wLDFWatchNotificationBeanImpl.getSNMPNotifications() == null || wLDFWatchNotificationBeanImpl.getSNMPNotifications().length == 0) {
                            wLDFWatchNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                        }
                    } else if (string.equals("Severity")) {
                        wLDFWatchNotificationBeanImpl.setSeverity(wLDFWatchNotificationBeanImpl2.getSeverity());
                        wLDFWatchNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("Watches")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                            wLDFWatchNotificationBeanImpl.addWatch((WLDFWatchBean)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            wLDFWatchNotificationBeanImpl.removeWatch((WLDFWatchBean)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (wLDFWatchNotificationBeanImpl.getWatches() == null || wLDFWatchNotificationBeanImpl.getWatches().length == 0) {
                            wLDFWatchNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 4);
                        }
                    } else if (string.equals("Enabled")) {
                        wLDFWatchNotificationBeanImpl.setEnabled(wLDFWatchNotificationBeanImpl2.isEnabled());
                        wLDFWatchNotificationBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 1);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                int n;
                WLDFBean[] wLDFBeanArray;
                WLDFBean[] wLDFBeanArray2;
                WLDFWatchNotificationBeanImpl wLDFWatchNotificationBeanImpl = (WLDFWatchNotificationBeanImpl)abstractDescriptorBean;
                super.finishCopy(wLDFWatchNotificationBeanImpl, bl, list);
                if (!(list != null && list.contains("ImageNotifications") || !this.bean.isImageNotificationsSet() || wLDFWatchNotificationBeanImpl._isSet(6))) {
                    wLDFBeanArray2 = this.bean.getImageNotifications();
                    wLDFBeanArray = new WLDFImageNotificationBean[wLDFBeanArray2.length];
                    for (n = 0; n < wLDFBeanArray.length; ++n) {
                        wLDFBeanArray[n] = (WLDFImageNotificationBean)this.createCopy((AbstractDescriptorBean)wLDFBeanArray2[n], bl);
                    }
                    wLDFWatchNotificationBeanImpl.setImageNotifications((WLDFImageNotificationBean[])wLDFBeanArray);
                }
                if (!(list != null && list.contains("JMSNotifications") || !this.bean.isJMSNotificationsSet() || wLDFWatchNotificationBeanImpl._isSet(7))) {
                    wLDFBeanArray2 = this.bean.getJMSNotifications();
                    wLDFBeanArray = new WLDFJMSNotificationBean[wLDFBeanArray2.length];
                    for (n = 0; n < wLDFBeanArray.length; ++n) {
                        wLDFBeanArray[n] = (WLDFJMSNotificationBean)this.createCopy((AbstractDescriptorBean)wLDFBeanArray2[n], bl);
                    }
                    wLDFWatchNotificationBeanImpl.setJMSNotifications((WLDFJMSNotificationBean[])wLDFBeanArray);
                }
                if (!(list != null && list.contains("JMXNotifications") || !this.bean.isJMXNotificationsSet() || wLDFWatchNotificationBeanImpl._isSet(8))) {
                    wLDFBeanArray2 = this.bean.getJMXNotifications();
                    wLDFBeanArray = new WLDFJMXNotificationBean[wLDFBeanArray2.length];
                    for (n = 0; n < wLDFBeanArray.length; ++n) {
                        wLDFBeanArray[n] = (WLDFJMXNotificationBean)this.createCopy((AbstractDescriptorBean)wLDFBeanArray2[n], bl);
                    }
                    wLDFWatchNotificationBeanImpl.setJMXNotifications((WLDFJMXNotificationBean[])wLDFBeanArray);
                }
                if ((list == null || !list.contains("LogWatchSeverity")) && this.bean.isLogWatchSeveritySet()) {
                    wLDFWatchNotificationBeanImpl.setLogWatchSeverity(this.bean.getLogWatchSeverity());
                }
                if (!(list != null && list.contains("SMTPNotifications") || !this.bean.isSMTPNotificationsSet() || wLDFWatchNotificationBeanImpl._isSet(9))) {
                    wLDFBeanArray2 = this.bean.getSMTPNotifications();
                    wLDFBeanArray = new WLDFSMTPNotificationBean[wLDFBeanArray2.length];
                    for (n = 0; n < wLDFBeanArray.length; ++n) {
                        wLDFBeanArray[n] = (WLDFSMTPNotificationBean)this.createCopy((AbstractDescriptorBean)wLDFBeanArray2[n], bl);
                    }
                    wLDFWatchNotificationBeanImpl.setSMTPNotifications((WLDFSMTPNotificationBean[])wLDFBeanArray);
                }
                if (!(list != null && list.contains("SNMPNotifications") || !this.bean.isSNMPNotificationsSet() || wLDFWatchNotificationBeanImpl._isSet(10))) {
                    wLDFBeanArray2 = this.bean.getSNMPNotifications();
                    wLDFBeanArray = new WLDFSNMPNotificationBean[wLDFBeanArray2.length];
                    for (n = 0; n < wLDFBeanArray.length; ++n) {
                        wLDFBeanArray[n] = (WLDFSNMPNotificationBean)this.createCopy((AbstractDescriptorBean)wLDFBeanArray2[n], bl);
                    }
                    wLDFWatchNotificationBeanImpl.setSNMPNotifications((WLDFSNMPNotificationBean[])wLDFBeanArray);
                }
                if ((list == null || !list.contains("Severity")) && this.bean.isSeveritySet()) {
                    wLDFWatchNotificationBeanImpl.setSeverity(this.bean.getSeverity());
                }
                if (!(list != null && list.contains("Watches") || !this.bean.isWatchesSet() || wLDFWatchNotificationBeanImpl._isSet(4))) {
                    wLDFBeanArray2 = this.bean.getWatches();
                    wLDFBeanArray = new WLDFWatchBean[wLDFBeanArray2.length];
                    for (n = 0; n < wLDFBeanArray.length; ++n) {
                        wLDFBeanArray[n] = (WLDFWatchBean)this.createCopy((AbstractDescriptorBean)wLDFBeanArray2[n], bl);
                    }
                    wLDFWatchNotificationBeanImpl.setWatches((WLDFWatchBean[])wLDFBeanArray);
                }
                if ((list == null || !list.contains("Enabled")) && this.bean.isEnabledSet()) {
                    wLDFWatchNotificationBeanImpl.setEnabled(this.bean.isEnabled());
                }
                return wLDFWatchNotificationBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getImageNotifications(), clazz, object);
            this.inferSubTree(this.bean.getJMSNotifications(), clazz, object);
            this.inferSubTree(this.bean.getJMXNotifications(), clazz, object);
            this.inferSubTree(this.bean.getNotifications(), clazz, object);
            this.inferSubTree(this.bean.getSMTPNotifications(), clazz, object);
            this.inferSubTree(this.bean.getSNMPNotifications(), clazz, object);
            this.inferSubTree(this.bean.getWatches(), clazz, object);
        }
    }
}

