/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester;

import java.util.Date;
import weblogic.diagnostics.accessor.ColumnInfo;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.harvester.LogSupport;
import weblogic.diagnostics.utils.SharedConstants;
import weblogic.utils.PlatformConstants;

public final class HarvesterDataSample
extends DataRecord {
    static final long serialVersionUID = 1L;
    private static final ColumnInfo[] columnInfos = ArchiveConstants.getColumns(2);
    private static final int RECORD_SIZE = ArchiveConstants.HARVESTER_ARCHIVE_COLUMNS_COUNT;
    private static final int RECORDID_INDEX = HarvesterDataSample.getColumnIndex("RECORDID");
    private static final int TIMESTAMP_INDEX = HarvesterDataSample.getColumnIndex("TIMESTAMP");
    private static final int DOMAIN_INDEX = HarvesterDataSample.getColumnIndex("DOMAIN");
    private static final int SERVER_INDEX = HarvesterDataSample.getColumnIndex("SERVER");
    private static final int TYPE_INDEX = HarvesterDataSample.getColumnIndex("TYPE");
    private static final int INST_NAME_INDEX = HarvesterDataSample.getColumnIndex("NAME");
    private static final int ATTR_NAME_INDEX = HarvesterDataSample.getColumnIndex("ATTRNAME");
    private static final int ATTR_TYPE_INDEX = HarvesterDataSample.getColumnIndex("ATTRTYPE");
    private static final int ATTR_VALUE_INDEX = HarvesterDataSample.getColumnIndex("ATTRVALUE");

    public HarvesterDataSample() {
    }

    public HarvesterDataSample(long l, String string, String string2, String string3, Object object) {
        super(new Object[RECORD_SIZE]);
        Object[] objectArray = this.getValues();
        objectArray[HarvesterDataSample.TIMESTAMP_INDEX] = new Long(l);
        objectArray[HarvesterDataSample.DOMAIN_INDEX] = SharedConstants.DOMAIN_NAME;
        objectArray[HarvesterDataSample.SERVER_INDEX] = SharedConstants.SERVER_NAME;
        objectArray[HarvesterDataSample.TYPE_INDEX] = string;
        objectArray[HarvesterDataSample.INST_NAME_INDEX] = string2;
        objectArray[HarvesterDataSample.ATTR_NAME_INDEX] = string3;
        objectArray[HarvesterDataSample.ATTR_TYPE_INDEX] = new Integer(this.getValueType(object));
        objectArray[HarvesterDataSample.ATTR_VALUE_INDEX] = object;
    }

    public long getRecordID() {
        Object object = this.getValues()[RECORDID_INDEX];
        if (object instanceof Long) {
            return (Long)object;
        }
        return 0L;
    }

    public long getTimestamp() {
        Object object = this.getValues()[TIMESTAMP_INDEX];
        if (object instanceof Long) {
            return (Long)object;
        }
        return 0L;
    }

    public String getInstanceName() {
        return (String)this.getValues()[INST_NAME_INDEX];
    }

    public String getDomainName() {
        return (String)this.getValues()[DOMAIN_INDEX];
    }

    public String getServerName() {
        return (String)this.getValues()[SERVER_INDEX];
    }

    public String getTypeName() {
        return (String)this.getValues()[TYPE_INDEX];
    }

    public String getAttributeName() {
        return (String)this.getValues()[ATTR_NAME_INDEX];
    }

    public Object getAttributeValue() {
        return this.getValues()[ATTR_VALUE_INDEX];
    }

    public String toString() {
        return this.toStringLong();
    }

    public String toStringShort() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = columnInfos[ATTR_TYPE_INDEX].getColumnTypeName();
        stringBuffer.append("Sample: ^" + this.getAttributeName() + "^" + this.getAttributeValue() + "^" + this.getTypeName() + "^" + string + "^" + this.getInstanceName());
        stringBuffer.append(PlatformConstants.EOL);
        return stringBuffer.toString();
    }

    public String toStringLong() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = this.getTimestamp();
        stringBuffer.append("   RecordID: " + this.getRecordID() + PlatformConstants.EOL);
        stringBuffer.append("  Timestamp: [" + l + "] (sometime slightly after) " + new Date(l) + PlatformConstants.EOL);
        stringBuffer.append("  Domain: " + this.getDomainName() + PlatformConstants.EOL);
        stringBuffer.append("  Server: " + this.getServerName() + PlatformConstants.EOL);
        stringBuffer.append("  Type: " + this.getTypeName() + PlatformConstants.EOL);
        stringBuffer.append("  Instance: " + this.getInstanceName() + PlatformConstants.EOL);
        stringBuffer.append("  Attribute: " + this.getAttributeName() + PlatformConstants.EOL);
        String string = columnInfos[ATTR_TYPE_INDEX].getColumnTypeName();
        stringBuffer.append("  Attribute type: " + string + PlatformConstants.EOL);
        stringBuffer.append("  Attribute value: " + this.getAttributeValue() + PlatformConstants.EOL);
        stringBuffer.append(PlatformConstants.EOL);
        return stringBuffer.toString();
    }

    private static final int getColumnIndex(String string) {
        for (int i = 0; i < columnInfos.length; ++i) {
            ColumnInfo columnInfo = columnInfos[i];
            String string2 = columnInfo.getColumnName();
            if (!string2.equals(string)) continue;
            return i;
        }
        throw new AssertionError((Object)LogSupport.getGenericHarvesterProblemText("Column name " + string + " not found in column info " + "from diagnostics achive subsystem"));
    }

    private int getValueType(Object object) {
        if (object instanceof Number) {
            return 4;
        }
        if (object instanceof String) {
            return 5;
        }
        return 6;
    }
}

