/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester;

import weblogic.diagnostics.harvester.I18NConstants;
import weblogic.diagnostics.harvester.I18NSupport;
import weblogic.diagnostics.type.DiagnosticException;

public abstract class HarvesterException
extends DiagnosticException
implements I18NConstants {
    HarvesterException() {
    }

    HarvesterException(String string) {
        super(string);
    }

    HarvesterException(Throwable throwable) {
        super(throwable);
    }

    HarvesterException(String string, Throwable throwable) {
        super(string, throwable);
    }

    private static String genStringFromArray(String[] stringArray) {
        String string = "";
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                string = i == n - 1 ? string + " and " : string + ", ";
            }
            string = string + stringArray[i];
        }
        return string;
    }

    public static class WatchTypeMetricNotFound
    extends HarvesterException {
        public WatchTypeMetricNotFound(String string, String string2) {
            super(I18NSupport.formatter().getWatchTypeMetricNotFoundMessage(string, string2));
        }
    }

    public static class WatchInstanceMetricNotFound
    extends HarvesterException {
        public WatchInstanceMetricNotFound(String string, String string2, String string3) {
            super(I18NSupport.formatter().getWatchInstanceMetricNotFoundMessage(string, string2, string3));
        }
    }

    public static class InconsistentTypesInWatchInst
    extends HarvesterException {
        private String instanceName;
        private String specifiedTypeName;
        private String actualTypeName;

        public InconsistentTypesInWatchInst(String string, String string2, String string3) {
            super(I18NSupport.formatter().getInconsistentTypesInWatchInstVarMessage(string, string2, string3));
            this.instanceName = string;
            this.specifiedTypeName = string2;
            this.actualTypeName = string3;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public String getSpecifiedTypeName() {
            return this.specifiedTypeName;
        }

        public String getActualTypeName() {
            return this.actualTypeName;
        }
    }

    public static class InvalidPlugInState
    extends IllegalStateException {
        public InvalidPlugInState(String string, String string2) {
            super(I18NSupport.formatter().getInvalidPluginStateMessage(string, string2));
        }
    }

    public static class ValidationError
    extends IllegalArgumentException {
        public ValidationError(String string, String string2, String string3) {
            super(I18NSupport.formatter().getNotHarvestableMessage(string, string2, string3));
        }
    }

    public static class NullName
    extends IllegalArgumentException {
        public NullName(String string) {
            super(I18NSupport.formatter().getNullParamMessage(string));
        }
    }

    public static abstract class FatalTypeException
    extends HarvesterException {
        public FatalTypeException(String string) {
            super(string);
        }

        public FatalTypeException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class HarvestingNotEnabled
    extends HarvesterException {
        public HarvestingNotEnabled() {
            super(I18NSupport.formatter().getHarvesterNotAvailableMessage());
        }
    }

    public static class AmbiguousTypeName
    extends FatalTypeException {
        private String name = this.name;
        private String[] providerNames = null;

        public String getAmbiguousName() {
            return this.name;
        }

        public String[] getProviderNames() {
            return this.providerNames;
        }

        public AmbiguousTypeName(String string, String string2, String string3) {
            super(AmbiguousTypeName.getExplanation(string, string2, string3));
            this.providerNames = new String[]{string2, string3};
        }

        private static String getExplanation(String string, String string2, String string3) {
            return I18NSupport.formatter().getAmbiguousTypeNameMessage(string, string2, string3);
        }
    }

    public static class AmbiguousInstanceName
    extends HarvesterException {
        private String name;
        private String[] providerNames = null;
        private String[] typeNames = null;

        public String getAmbiguousName() {
            return this.name;
        }

        public String[] getProviderNames() {
            return this.providerNames;
        }

        public String[] getTypeNames() {
            return this.typeNames;
        }

        public AmbiguousInstanceName(String string, String string2, String string3, String string4, String string5) {
            super(AmbiguousInstanceName.getExplanation(string, string2, string3, string4, string5));
            this.name = string;
            this.providerNames = new String[]{string2, string4};
            this.typeNames = new String[]{string3, string5};
        }

        private static String getExplanation(String string, String string2, String string3, String string4, String string5) {
            return I18NSupport.formatter().getAmbiguousInstanceNameMessage(string, string2, string3, string4, string5);
        }
    }

    public static class TypeNotHarvestable
    extends FatalTypeException {
        private String typeName;

        public String getTypeName() {
            return this.typeName;
        }

        public TypeNotHarvestable(String string) {
            this(string, null);
        }

        public TypeNotHarvestable(String string, Throwable throwable) {
            super(TypeNotHarvestable.getExplanation(string), throwable);
            this.typeName = string;
        }

        private static String getExplanation(String string) {
            return I18NSupport.formatter().getItemNotHarvestableMessage(TYPE_I18N, string);
        }
    }

    public static class MissingConfigurationType
    extends MissingConfiguration {
        private String typeName;

        public String getTypeName() {
            return this.typeName;
        }

        public MissingConfigurationType(String string) {
            this(string, null);
        }

        public MissingConfigurationType(String string, Throwable throwable) {
            super(MissingConfigurationType.getExplanation(string), throwable);
            this.typeName = string;
        }

        private static String getExplanation(String string) {
            return I18NSupport.formatter().getNoTypeConfigMessage(string);
        }
    }

    public static abstract class MissingConfiguration
    extends HarvesterException {
        public MissingConfiguration(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class HarvestableTypesNotFoundException
    extends HarvesterException {
        private String[] types;

        public String[] getTypes() {
            return this.types;
        }

        public HarvestableTypesNotFoundException(String[] stringArray) {
            this(stringArray, null);
        }

        public HarvestableTypesNotFoundException(String[] stringArray, Throwable throwable) {
            super(HarvestableTypesNotFoundException.getExplanation(stringArray), throwable);
            this.types = this.types != null ? this.types : new String[]{};
        }

        private static String getExplanation(String string) {
            return I18NSupport.formatter().getHarvesterTypeNotFoundMessage(string);
        }

        private static String getExplanation(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return I18NSupport.formatter().getTypeNotDefinedMessage();
            }
            String string = HarvesterException.genStringFromArray(stringArray);
            return I18NSupport.formatter().getTypesDoNotExistMessage(string);
        }
    }

    public static class HarvestableInstancesNotFoundException
    extends HarvesterException {
        private String[] instances;

        public String[] getInstances() {
            return this.instances;
        }

        public HarvestableInstancesNotFoundException(String[] stringArray) {
            this(stringArray, null);
        }

        public HarvestableInstancesNotFoundException(String[] stringArray, Throwable throwable) {
            super(HarvestableInstancesNotFoundException.getExplanation(stringArray), throwable);
            this.instances = stringArray != null ? stringArray : new String[]{};
        }

        private static String getExplanation(String[] stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                return I18NSupport.formatter().getInstanceNotRegisteredMessage();
            }
            String string = HarvesterException.genStringFromArray(stringArray);
            return I18NSupport.formatter().getInstancesDoNotExistMessage(string);
        }
    }
}

