/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.management.ObjectName;
import weblogic.diagnostics.harvester.InvalidHarvesterInstanceNameException;
import weblogic.diagnostics.harvester.InvalidSequence;
import weblogic.diagnostics.i18n.DiagnosticsTextTextFormatter;

public class InstanceNameNormalizer {
    private String instanceNameSpecification;
    private boolean regexPattern;
    private String normalizedName;
    private boolean objectNamePattern;

    public InstanceNameNormalizer(String string) {
        this.instanceNameSpecification = string;
    }

    public boolean isPattern() {
        if (this.instanceNameSpecification == null) {
            try {
                this.translateHarvesterSpec();
            }
            catch (InvalidHarvesterInstanceNameException invalidHarvesterInstanceNameException) {
                // empty catch block
            }
        }
        return this.regexPattern || this.objectNamePattern;
    }

    public boolean isRegexPattern() {
        if (this.instanceNameSpecification == null) {
            try {
                this.translateHarvesterSpec();
            }
            catch (InvalidHarvesterInstanceNameException invalidHarvesterInstanceNameException) {
                // empty catch block
            }
        }
        return this.regexPattern;
    }

    public boolean isObjectNamePattern() {
        if (this.instanceNameSpecification == null) {
            try {
                this.translateHarvesterSpec();
            }
            catch (InvalidHarvesterInstanceNameException invalidHarvesterInstanceNameException) {
                // empty catch block
            }
        }
        return this.objectNamePattern;
    }

    public synchronized String translateHarvesterSpec() throws InvalidHarvesterInstanceNameException {
        if (this.instanceNameSpecification == null) {
            throw new InvalidHarvesterInstanceNameException(DiagnosticsTextTextFormatter.getInstance().getInvalidHarvesterInstanceNameText(this.instanceNameSpecification));
        }
        if (this.normalizedName == null) {
            boolean bl = false;
            ObjectName objectName = null;
            try {
                objectName = new ObjectName(this.instanceNameSpecification);
                bl = true;
                this.normalizedName = objectName.getCanonicalName();
                this.objectNamePattern = objectName.isPattern();
            }
            catch (Exception exception) {
                bl = false;
            }
            if (!bl) {
                this.regexPattern = this.instanceNameSpecification.contains("*");
                if (!this.isPattern()) {
                    throw new InvalidHarvesterInstanceNameException(DiagnosticsTextTextFormatter.getInstance().getInvalidHarvesterInstanceNameText(this.instanceNameSpecification));
                }
                this.normalizedName = this.normalizePattern(this.instanceNameSpecification);
                this.normalizedName = this.normalizedName.replaceAll("\\[", "\\\\[");
                this.normalizedName = this.normalizedName.replaceAll("\\]", "\\\\]");
                this.normalizedName = this.normalizedName.replaceAll("\\*", "(.*?)");
            }
        }
        return this.normalizedName;
    }

    private String normalizePattern(String string) throws InvalidHarvesterInstanceNameException {
        this.scanInstanceName(this.instanceNameSpecification);
        String string2 = string;
        String[] stringArray = string.split(":");
        if (stringArray.length == 2) {
            try {
                string2 = this.normalizeObjectNamePattern(stringArray[0], stringArray[1]);
            }
            catch (InvalidSequence invalidSequence) {}
        } else if (stringArray.length > 2) {
            throw new InvalidHarvesterInstanceNameException(this.instanceNameSpecification);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private String normalizeObjectNamePattern(String string, String object) throws InvalidHarvesterInstanceNameException, InvalidSequence {
        void var8_10;
        if (string == null || object == null) {
            throw new InvalidHarvesterInstanceNameException(this.instanceNameSpecification);
        }
        String string2 = "";
        String[] stringArray = ((String)object).split(",");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length);
        boolean bl = false;
        String[] object2 = stringArray;
        int n = object2.length;
        for (int i = 0; i < n; ++i) {
            String string3 = object2[i];
            if (string3 == null) continue;
            String[] stringArray2 = (string3 = string3.trim()).split("=");
            if (stringArray2.length < 2) {
                throw new InvalidSequence();
            }
            String string4 = stringArray2[0];
            if (string4 == null || string4.length() == 0) {
                throw new InvalidSequence();
            }
            if ((string4 = string4.trim()).contains("*")) {
                throw new InvalidSequence();
            }
            arrayList.add(string4);
            hashMap.put(string4, string3);
        }
        Collections.sort(arrayList);
        String string5 = "";
        for (n = 0; n < arrayList.size(); ++n) {
            String string6 = (String)arrayList.get(n);
            String string7 = (String)var8_10 + (String)hashMap.get(string6);
            if (n >= arrayList.size() - 1) continue;
            String string8 = string7 + ",";
        }
        object = var8_10;
        string2 = string + ":" + (String)object;
        if (bl) {
            string2 = string2 + ",*";
        }
        return string2;
    }

    private void scanInstanceName(String string) throws InvalidHarvesterInstanceNameException {
        if (string == null || string.length() == 0) {
            throw new InvalidHarvesterInstanceNameException(string);
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        for (char c : cArray) {
            if (this.isValidChar(c)) continue;
            throw new InvalidHarvesterInstanceNameException(string);
        }
    }

    private boolean isValidChar(char c) {
        return Character.isLetterOrDigit(c) || c == ':' || c == '.' || c == '=' || c == '*' || c == '_' || c == ',' || c == '\\' || c == '?' || c == '\"' || c == '[' || c == ']';
    }

    public static void main(String[] stringArray) {
        for (String string : stringArray) {
            System.out.println("Normalizing name: " + string);
            try {
                InstanceNameNormalizer instanceNameNormalizer = new InstanceNameNormalizer(string);
                String string2 = instanceNameNormalizer.translateHarvesterSpec();
                System.out.println("Normalized name: " + string2);
            }
            catch (InvalidHarvesterInstanceNameException invalidHarvesterInstanceNameException) {
                System.out.println("Normalization failed: " + invalidHarvesterInstanceNameException.getMessage());
                invalidHarvesterInstanceNameException.printStackTrace();
            }
        }
    }
}

